/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.explosion.vanillant.standard;

import com.hbm.explosion.vanillant.ExplosionVNT;
import com.hbm.explosion.vanillant.interfaces.ICustomDamageHandler;
import com.hbm.explosion.vanillant.interfaces.IEntityProcessor;
import com.hbm.explosion.vanillant.interfaces.IEntityRangeMutator;
import java.util.HashMap;
import java.util.List;
import net.minecraft.enchantment.EnchantmentProtection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Vec3;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.ForgeEventFactory;

public class EntityProcessorCross
implements IEntityProcessor {
    protected double nodeDist = 2.0;
    protected IEntityRangeMutator range;
    protected ICustomDamageHandler damage;

    public EntityProcessorCross(double nodeDist) {
        this.nodeDist = nodeDist;
    }

    @Override
    public HashMap<EntityPlayer, Vec3> process(ExplosionVNT explosion, World world, double x, double y, double z, float size) {
        HashMap<EntityPlayer, Vec3> affectedPlayers = new HashMap<EntityPlayer, Vec3>();
        size *= 2.0f;
        if (this.range != null) {
            size = this.range.mutateRange(explosion, size);
        }
        double minX = x - (double)size - 1.0;
        double maxX = x + (double)size + 1.0;
        double minY = y - (double)size - 1.0;
        double maxY = y + (double)size + 1.0;
        double minZ = z - (double)size - 1.0;
        double maxZ = z + (double)size + 1.0;
        List list = world.func_72839_b(explosion.exploder, AxisAlignedBB.func_72330_a((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ));
        ForgeEventFactory.onExplosionDetonate((World)world, (Explosion)explosion.compat, (List)list, (double)size);
        Vec3[] nodes = new Vec3[7];
        for (int i = 0; i < 7; ++i) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)i);
            nodes[i] = Vec3.func_72443_a((double)(x + (double)dir.offsetX * this.nodeDist), (double)(y + (double)dir.offsetY * this.nodeDist), (double)(z + (double)dir.offsetZ * this.nodeDist));
        }
        for (int index = 0; index < list.size(); ++index) {
            double deltaZ;
            double deltaY;
            double deltaX;
            double distance;
            Entity entity = (Entity)list.get(index);
            double distanceScaled = entity.func_70011_f(x, y, z) / (double)size;
            if (!(distanceScaled <= 1.0) || (distance = Math.sqrt((deltaX = entity.field_70165_t - x) * deltaX + (deltaY = entity.field_70163_u + (double)entity.func_70047_e() - y) * deltaY + (deltaZ = entity.field_70161_v - z) * deltaZ)) == 0.0) continue;
            deltaX /= distance;
            deltaY /= distance;
            deltaZ /= distance;
            double density = 0.0;
            for (Vec3 vec : nodes) {
                double d = world.func_72842_a(vec, entity.field_70121_D);
                if (!(d > density)) continue;
                density = d;
            }
            double knockback = (1.0 - distanceScaled) * density;
            entity.func_70097_a(DamageSource.func_94539_a((Explosion)explosion.compat), (float)((int)((knockback * knockback + knockback) / 2.0 * 8.0 * (double)size + 1.0)));
            double enchKnockback = EnchantmentProtection.func_92092_a((Entity)entity, (double)knockback);
            entity.field_70159_w += deltaX * enchKnockback;
            entity.field_70181_x += deltaY * enchKnockback;
            entity.field_70179_y += deltaZ * enchKnockback;
            if (entity instanceof EntityPlayer) {
                affectedPlayers.put((EntityPlayer)entity, Vec3.func_72443_a((double)(deltaX * knockback), (double)(deltaY * knockback), (double)(deltaZ * knockback)));
            }
            if (this.damage == null) continue;
            this.damage.handleAttack(explosion, entity, distanceScaled);
        }
        return affectedPlayers;
    }

    public EntityProcessorCross withRangeMod(final float mod) {
        this.range = new IEntityRangeMutator(){

            @Override
            public float mutateRange(ExplosionVNT explosion, float range) {
                return range * mod;
            }
        };
        return this;
    }

    public EntityProcessorCross withDamageMod(ICustomDamageHandler damage) {
        this.damage = damage;
        return this;
    }
}

