/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.explosion.nt;

import com.hbm.explosion.nt.IExplosionLogic;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

@Deprecated
public class Mark5Ausf2
implements IExplosionLogic {
    private HorizontalSegment[] segments;
    private HorizontalSegment[] repopulatedSegments;
    private Set<BlockPos> buffer = new HashSet<BlockPos>();
    private World world;
    private float strength;
    float originX;
    float originY;
    float originZ;
    float length;
    int phase = 0;
    private int processBow = 0;
    private int processRing = 0;
    private boolean isDone = false;

    public Mark5Ausf2(World world, float strength, float x, float y, float z) {
        this.world = world;
        this.strength = strength;
        this.originX = x;
        this.originY = y;
        this.originZ = z;
        this.initRays();
    }

    private double getResolutionMult() {
        return 5.0;
    }

    private void initRays() {
        this.length = 5.0f;
        double bow = (double)this.length * Math.PI;
        int bowCount = (int)Math.ceil(bow * this.getResolutionMult());
        double bowDelta = Math.PI / (double)(bowCount - 1);
        this.segments = new HorizontalSegment[bowCount];
        for (int i = 0; i < bowCount; ++i) {
            double currBow = bowDelta * (double)i;
            double ringRadius = Math.sin(currBow) * (double)this.length;
            double ringCircumference = 2.0 * ringRadius * Math.PI;
            int ringCount = (int)Math.max(Math.ceil(ringCircumference * this.getResolutionMult()), 1.0);
            double ringDelta = Math.PI * 2 / (double)(ringCount - 1);
            HorizontalSegment seg = new HorizontalSegment(ringCount);
            float pitch = (float)currBow;
            for (int j = 0; j < ringCount; ++j) {
                float yaw = (float)(ringDelta * (double)j);
                seg.rays[j] = new MVRay(this.strength, this.originX, this.originY, this.originZ, yaw, pitch, this.length);
            }
            this.segments[i] = seg;
        }
    }

    @Override
    public void updateLogic() {
        switch (this.phase) {
            case 0: {
                this.processRays(50000);
                break;
            }
            case 1: {
                this.breakBlocks(2000);
                break;
            }
            case 2: {
                this.repopulate();
            }
        }
    }

    private void endPhaseZero() {
        this.processBow = 0;
        this.processRing = 0;
        this.phase = 1;
    }

    private void processRays(int amount) {
        while (amount >= 0) {
            if (this.segments[this.processBow] == null || this.processRing >= this.segments[this.processBow].rays.length) {
                this.processRing = 0;
                ++this.processBow;
                if (this.processBow < this.segments.length) continue;
                this.endPhaseZero();
                return;
            }
            if (this.processBow >= this.segments.length) {
                this.endPhaseZero();
                return;
            }
            MVRay ray = this.segments[this.processBow].rays[this.processRing];
            if (ray != null) {
                Vec3 vec = Vec3.func_72443_a((double)1.0, (double)0.0, (double)0.0);
                vec.func_72446_c(ray.pitch);
                vec.func_72442_b(ray.yaw);
                double finalX = 0.0;
                double finalY = 0.0;
                double finalZ = 0.0;
                for (float i = 0.0f; i < ray.length; i += 0.5f) {
                    finalX = (double)ray.x + vec.field_72450_a * (double)i;
                    finalY = (double)ray.y + vec.field_72448_b * (double)i;
                    finalZ = (double)ray.z + vec.field_72449_c * (double)i;
                    int x = (int)Math.floor(finalX);
                    int y = (int)Math.floor(finalY);
                    int z = (int)Math.floor(finalZ);
                    BlockPos pos = new BlockPos(x, y, z);
                    if (y > 255 || y < 0) break;
                    Block b = this.world.func_147439_a(x, y, z);
                    float res = b.func_149688_o().func_76224_d() ? (float)Math.pow(Blocks.field_150350_a.func_149638_a(null), 1.25) : (float)Math.pow(b.func_149638_a(null), 1.25);
                    ray.power -= res;
                    if (ray.power <= 0.0f) break;
                    if (b == Blocks.field_150350_a) continue;
                    this.buffer.add(pos);
                }
                if (ray.power <= 0.0f || finalY < 0.0 || finalY > 255.0 || this.length > this.strength) {
                    this.segments[this.processBow].rays[this.processRing] = null;
                }
                ray.x = (float)finalX;
                ray.y = (float)finalY;
                ray.z = (float)finalZ;
            }
            --amount;
            ++this.processRing;
        }
        return;
    }

    private void breakBlocks(int amount) {
        if (this.phase == 1 && this.buffer.isEmpty()) {
            this.phase = 2;
            return;
        }
        int rem = 0;
        ArrayList<BlockPos> toRem = new ArrayList<BlockPos>();
        for (BlockPos pos : this.buffer) {
            this.world.func_147465_d(pos.x, pos.y, pos.z, Blocks.field_150350_a, 0, 3);
            toRem.add(pos);
            if (++rem != amount) continue;
            break;
        }
        this.buffer.removeAll(toRem);
        if (this.buffer.isEmpty()) {
            this.phase = 2;
        }
    }

    private void repopulate() {
        boolean didYouDoLiterallyAnything = false;
        this.length *= 2.0f;
        double bow = (double)this.length * Math.PI;
        int bowCount = (int)Math.ceil(bow * this.getResolutionMult());
        double bowDelta = Math.PI / (double)(bowCount - 1);
        this.repopulatedSegments = new HorizontalSegment[bowCount];
        for (int i = 0; i < bowCount; ++i) {
            double currBow = bowDelta * (double)i;
            double ringRadius = Math.sin(currBow) * (double)this.length;
            double ringCircumference = 2.0 * ringRadius * Math.PI;
            int ringCount = (int)Math.max(Math.ceil(ringCircumference * this.getResolutionMult()), 1.0);
            double ringDelta = Math.PI * 2 / (double)(ringCount - 1);
            float pitch = (float)currBow;
            HorizontalSegment parentSegment = this.fromAngle(pitch);
            if (parentSegment == null) continue;
            HorizontalSegment seg = new HorizontalSegment(ringCount);
            for (int j = 0; j < ringCount; ++j) {
                MVRay newRay;
                float yaw = (float)(ringDelta * (double)j);
                MVRay parentRay = parentSegment.fromAngle(yaw);
                if (parentRay == null || !(parentRay.power > 0.0f)) continue;
                Vec3 len = Vec3.func_72443_a((double)(parentRay.x - this.originX), (double)(parentRay.y - this.originY), (double)(parentRay.z - this.originZ));
                double totalLen = len.func_72433_c();
                Vec3 normal = Vec3.func_72443_a((double)totalLen, (double)0.0, (double)0.0);
                normal.func_72446_c(pitch);
                normal.func_72442_b(yaw);
                float newPower = parentRay.power;
                seg.rays[j] = newRay = new MVRay(newPower, (float)((double)this.originX - normal.field_72450_a), (float)((double)this.originY - normal.field_72448_b), (float)((double)this.originZ - normal.field_72449_c), yaw, pitch, (float)((double)this.length - totalLen));
                this.repopulatedSegments[i] = seg;
                didYouDoLiterallyAnything = true;
            }
        }
        this.segments = this.repopulatedSegments;
        this.repopulatedSegments = null;
        this.phase = 0;
        if (!didYouDoLiterallyAnything) {
            this.isDone = true;
        }
    }

    private HorizontalSegment fromAngle(float pitch) {
        int size = this.segments.length;
        int index = (int)Math.floor((double)(pitch * (float)size) / Math.PI) % this.segments.length;
        if (index >= this.segments.length || index < 0) {
            return null;
        }
        return this.segments[index];
    }

    @Override
    public boolean isDone() {
        return this.isDone;
    }

    public static class BlockPos {
        int x;
        int y;
        int z;

        public BlockPos(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.x;
            result = 31 * result + this.y;
            result = 31 * result + this.z;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BlockPos other = (BlockPos)obj;
            if (this.x != other.x) {
                return false;
            }
            if (this.y != other.y) {
                return false;
            }
            return this.z == other.z;
        }
    }

    public static class MVRay {
        float power;
        boolean collected = false;
        float x;
        float y;
        float z;
        float yaw;
        float pitch;
        float length;
        boolean tracked;

        public MVRay(float power, float x, float y, float z, float yaw, float pitch, float length) {
            this.power = power;
            this.x = x;
            this.y = y;
            this.z = z;
            this.yaw = yaw;
            this.pitch = pitch;
            this.length = length;
        }

        public MVRay(float power, float x, float y, float z, Vec3 dir, float length) {
            double len = dir.func_72433_c();
            float yaw = (float)Math.atan2(dir.field_72449_c, dir.field_72450_a);
            float pitch = (float)Math.asin(dir.field_72448_b / len);
            this.power = power;
            this.x = x;
            this.y = y;
            this.z = z;
            this.yaw = yaw;
            this.pitch = pitch;
            this.length = length;
        }
    }

    public static class HorizontalSegment {
        MVRay[] rays;

        private HorizontalSegment(int size) {
            this.rays = new MVRay[size];
        }

        private MVRay fromAngle(float yaw) {
            int size = this.rays.length;
            int index = (int)Math.floor((double)(yaw * (float)size) / (Math.PI * 2)) % this.rays.length;
            if (index >= this.rays.length || index < 0) {
                return null;
            }
            return this.rays[index];
        }
    }
}

