/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.explosion;

import com.hbm.config.BombConfig;
import com.hbm.entity.logic.EntityNukeExplosionMK5;
import com.hbm.explosion.ExplosionLarge;
import com.hbm.explosion.ExplosionNT;
import com.hbm.explosion.ExplosionNukeGeneric;
import com.hbm.handler.radiation.ChunkRadiationManager;
import com.hbm.main.MainRegistry;
import com.hbm.packet.AuxParticlePacketNT;
import com.hbm.packet.PacketDispatcher;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class ExplosionNukeSmall {
    public static MukeParams PARAMS_SAFE = new MukeParams(){
        {
            this.safe = true;
            this.killRadius = 45.0f;
            this.radiationLevel = 2.0f;
        }
    };
    public static MukeParams PARAMS_TOTS = new MukeParams(){
        {
            this.blastRadius = 10.0f;
            this.killRadius = 30.0f;
            this.particle = "tinytot";
            this.shrapnelCount = 0;
            this.resolution = 32;
            this.radiationLevel = 1.0f;
        }
    };
    public static MukeParams PARAMS_LOW = new MukeParams(){
        {
            this.blastRadius = 15.0f;
            this.killRadius = 45.0f;
            this.radiationLevel = 2.0f;
        }
    };
    public static MukeParams PARAMS_MEDIUM = new MukeParams(){
        {
            this.blastRadius = 20.0f;
            this.killRadius = 55.0f;
            this.radiationLevel = 3.0f;
        }
    };
    public static MukeParams PARAMS_HIGH = new MukeParams(){
        {
            this.miniNuke = false;
            this.blastRadius = BombConfig.fatmanRadius;
            this.shrapnelCount = 0;
            this.radiationLevel = 4.0f;
        }
    };

    public static void explode(World world, double posX, double posY, double posZ, MukeParams params) {
        if (params.particle != null) {
            NBTTagCompound data = new NBTTagCompound();
            data.func_74778_a("type", params.particle);
            if (params.particle.equals("muke") && (MainRegistry.polaroidID == 11 || world.field_73012_v.nextInt(100) == 0)) {
                data.func_74757_a("balefire", true);
            }
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(data, posX, posY + 0.5, posZ), new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, posX, posY, posZ, 250.0));
        }
        world.func_72908_a(posX, posY, posZ, "hbm:weapon.mukeExplosion", 15.0f, 1.0f);
        if (params.shrapnelCount > 0) {
            ExplosionLarge.spawnShrapnels(world, posX, posY, posZ, params.shrapnelCount);
        }
        if (params.miniNuke && !params.safe) {
            new ExplosionNT(world, null, posX, posY, posZ, params.blastRadius).addAllAttrib(params.explosionAttribs).overrideResolution(params.resolution).explode();
        }
        if (params.killRadius > 0.0f) {
            ExplosionNukeGeneric.dealDamage(world, posX, posY, posZ, params.killRadius);
        }
        if (!params.miniNuke) {
            world.func_72838_d((Entity)EntityNukeExplosionMK5.statFac(world, (int)params.blastRadius, posX, posY, posZ).mute());
        }
        float radMod = params.radiationLevel / 3.0f;
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                if (Math.abs(i) + Math.abs(j) >= 4) continue;
                ChunkRadiationManager.proxy.incrementRad(world, (int)Math.floor(posX + (double)(i * 16)), (int)Math.floor(posY), (int)Math.floor(posZ + (double)(j * 16)), (float)(50 / (Math.abs(i) + Math.abs(j) + 1)) * radMod);
            }
        }
    }

    public static class MukeParams {
        public boolean miniNuke = true;
        public boolean safe = false;
        public float blastRadius;
        public float killRadius;
        public float radiationLevel = 1.0f;
        public String particle = "muke";
        public int shrapnelCount = 25;
        public int resolution = 64;
        public ExplosionNT.ExAttrib[] explosionAttribs = new ExplosionNT.ExAttrib[]{ExplosionNT.ExAttrib.FIRE, ExplosionNT.ExAttrib.NOPARTICLE, ExplosionNT.ExAttrib.NOSOUND, ExplosionNT.ExAttrib.NODROP, ExplosionNT.ExAttrib.NOHURT};
    }
}

