/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.explosion;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.init.Blocks;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class ExplosionNukeRay {
    List<FloatTriplet> affectedBlocks = new ArrayList<FloatTriplet>();
    int posX;
    int posY;
    int posZ;
    World world;
    int strength;
    int length;
    int processed;
    int gspNumMax;
    int gspNum;
    double gspX;
    double gspY;
    public boolean isAusf3Complete = false;

    public ExplosionNukeRay(World world, int x, int y, int z, int strength, int count, int speed, int length) {
        this.world = world;
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.strength = strength;
        this.length = length;
        this.gspNumMax = (int)(7.853981633974483 * Math.pow(this.strength, 2.0));
        this.gspNum = 1;
        this.gspX = Math.PI;
        this.gspY = 0.0;
    }

    private void generateGspUp() {
        if (this.gspNum < this.gspNumMax) {
            int k = this.gspNum + 1;
            double hk = -1.0 + 2.0 * ((double)k - 1.0) / ((double)this.gspNumMax - 1.0);
            this.gspX = Math.acos(hk);
            double prev_lon = this.gspY;
            double lon = prev_lon + 3.6 / Math.sqrt(this.gspNumMax) / Math.sqrt(1.0 - hk * hk);
            this.gspY = lon % (Math.PI * 2);
        } else {
            this.gspX = 0.0;
            this.gspY = 0.0;
        }
        ++this.gspNum;
    }

    private Vec3 getSpherical2cartesian() {
        double dx = Math.sin(this.gspX) * Math.cos(this.gspY);
        double dz = Math.sin(this.gspX) * Math.sin(this.gspY);
        double dy = Math.cos(this.gspX);
        return Vec3.func_72443_a((double)dx, (double)dy, (double)dz);
    }

    public void collectTipMk4_5(int count) {
        int amountProcessed = 0;
        while (this.gspNumMax >= this.gspNum) {
            Vec3 vec = this.getSpherical2cartesian();
            int length = (int)Math.ceil(this.strength);
            float res = this.strength;
            FloatTriplet lastPos = null;
            for (int i = 0; i < length && i <= this.length; ++i) {
                float x0 = (float)((double)this.posX + vec.field_72450_a * (double)i);
                float y0 = (float)((double)this.posY + vec.field_72448_b * (double)i);
                float z0 = (float)((double)this.posZ + vec.field_72449_c * (double)i);
                double fac = 100.0 - (double)i / (double)length * 100.0;
                res = !this.world.func_147439_a((int)x0, (int)y0, (int)z0).func_149688_o().func_76224_d() ? (float)((double)res - Math.pow(this.world.func_147439_a((int)x0, (int)y0, (int)z0).func_149638_a(null), 7.5 - fac)) : (float)((double)res - Math.pow(Blocks.field_150350_a.func_149638_a(null), 7.5 - (fac *= 0.07)));
                if (res > 0.0f && this.world.func_147439_a((int)x0, (int)y0, (int)z0) != Blocks.field_150350_a) {
                    lastPos = new FloatTriplet(x0, y0, z0);
                }
                if (!(res <= 0.0f) && i + 1 < this.length) continue;
                if (this.affectedBlocks.size() >= 2147483547 || lastPos == null) break;
                this.affectedBlocks.add(lastPos);
                break;
            }
            this.generateGspUp();
            if (++amountProcessed < count) continue;
            return;
        }
        this.isAusf3Complete = true;
    }

    public void processTip(int count) {
        int processedBlocks = 0;
        int braker = 0;
        for (int l = 0; l < Integer.MAX_VALUE; ++l) {
            if (processedBlocks >= count) {
                return;
            }
            if (braker >= count * 50) {
                return;
            }
            if (l > this.affectedBlocks.size() - 1) break;
            if (this.affectedBlocks.isEmpty()) {
                return;
            }
            int in = this.affectedBlocks.size() - 1;
            float x = this.affectedBlocks.get((int)in).xCoord;
            float y = this.affectedBlocks.get((int)in).yCoord;
            float z = this.affectedBlocks.get((int)in).zCoord;
            this.world.func_147449_b((int)x, (int)y, (int)z, Blocks.field_150350_a);
            Vec3 vec = Vec3.func_72443_a((double)(x - (float)this.posX), (double)(y - (float)this.posY), (double)(z - (float)this.posZ));
            double pX = vec.field_72450_a / vec.func_72433_c();
            double pY = vec.field_72448_b / vec.func_72433_c();
            double pZ = vec.field_72449_c / vec.func_72433_c();
            int i = 0;
            while ((double)i < vec.func_72433_c()) {
                int x0 = (int)((double)this.posX + pX * (double)i);
                int y0 = (int)((double)this.posY + pY * (double)i);
                int z0 = (int)((double)this.posZ + pZ * (double)i);
                if (!this.world.func_147437_c(x0, y0, z0)) {
                    this.world.func_147449_b(x0, y0, z0, Blocks.field_150350_a);
                    ++processedBlocks;
                }
                ++braker;
                ++i;
            }
            this.affectedBlocks.remove(in);
        }
        this.processed += count;
    }

    public void deleteStorage() {
        this.affectedBlocks.clear();
    }

    public int getStoredSize() {
        return this.affectedBlocks.size();
    }

    public int getProgress() {
        return this.processed;
    }

    public class FloatTriplet {
        public float xCoord;
        public float yCoord;
        public float zCoord;

        public FloatTriplet(float x, float y, float z) {
            this.xCoord = x;
            this.yCoord = y;
            this.zCoord = z;
        }
    }
}

