/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.projectile;

import com.hbm.entity.projectile.EntityDebrisBase;
import com.hbm.items.ModItems;
import com.hbm.potion.HbmPotion;
import com.hbm.tileentity.machine.rbmk.RBMKDials;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityRBMKDebris
extends EntityDebrisBase {
    public float rot;
    public float lastRot;
    private boolean hasSizeSet = false;

    public EntityRBMKDebris(World world) {
        super(world);
    }

    public EntityRBMKDebris(World world, double x, double y, double z, DebrisType type) {
        super(world);
        this.func_70107_b(x, y, z);
        this.setType(type);
    }

    @Override
    public boolean func_130002_c(EntityPlayer player) {
        if (!this.field_70170_p.field_72995_K) {
            switch (this.getType()) {
                case BLANK: {
                    if (!player.field_71071_by.func_70441_a(new ItemStack(ModItems.debris_metal))) break;
                    this.func_70106_y();
                    break;
                }
                case ELEMENT: {
                    if (!player.field_71071_by.func_70441_a(new ItemStack(ModItems.debris_metal))) break;
                    this.func_70106_y();
                    break;
                }
                case FUEL: {
                    if (!player.field_71071_by.func_70441_a(new ItemStack(ModItems.debris_fuel))) break;
                    this.func_70106_y();
                    break;
                }
                case GRAPHITE: {
                    if (!player.field_71071_by.func_70441_a(new ItemStack(ModItems.debris_graphite))) break;
                    this.func_70106_y();
                    break;
                }
                case LID: {
                    if (!player.field_71071_by.func_70441_a(new ItemStack(ModItems.rbmk_lid))) break;
                    this.func_70106_y();
                    break;
                }
                case ROD: {
                    if (!player.field_71071_by.func_70441_a(new ItemStack(ModItems.debris_metal))) break;
                    this.func_70106_y();
                }
            }
            player.field_71069_bz.func_75142_b();
        }
        return false;
    }

    public void func_70071_h_() {
        if (!this.hasSizeSet) {
            switch (this.getType()) {
                case BLANK: {
                    this.func_70105_a(0.5f, 0.5f);
                    break;
                }
                case ELEMENT: {
                    this.func_70105_a(1.0f, 1.0f);
                    break;
                }
                case FUEL: {
                    this.func_70105_a(0.25f, 0.25f);
                    break;
                }
                case GRAPHITE: {
                    this.func_70105_a(0.25f, 0.25f);
                    break;
                }
                case LID: {
                    this.func_70105_a(1.0f, 0.5f);
                    break;
                }
                case ROD: {
                    this.func_70105_a(0.75f, 0.5f);
                }
            }
            this.hasSizeSet = true;
        }
        if (!this.field_70170_p.field_72995_K) {
            Vec3 next;
            Vec3 pos;
            MovingObjectPosition mop;
            if (this.getType() == DebrisType.LID && this.field_70181_x > 0.0 && (mop = this.field_70170_p.func_147447_a(pos = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v), next = Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w * 2.0), (double)(this.field_70163_u + this.field_70181_x * 2.0), (double)(this.field_70161_v + this.field_70179_y * 2.0)), false, false, false)) != null) {
                MovingObjectPosition.MovingObjectType cfr_ignored_0 = mop.field_72313_a;
                if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                    int x = mop.field_72311_b;
                    int y = mop.field_72312_c;
                    int z = mop.field_72309_d;
                    for (int i = -1; i <= 1; ++i) {
                        for (int j = -1; j <= 1; ++j) {
                            for (int k = -1; k <= 1; ++k) {
                                int rn = Math.abs(i) + Math.abs(j) + Math.abs(k);
                                if (rn > 1 && this.field_70146_Z.nextInt(rn) != 0) continue;
                                this.field_70170_p.func_147468_f(x + i, y + j, z + k);
                            }
                        }
                    }
                    this.func_70106_y();
                }
            }
            if (this.getType() == DebrisType.FUEL || this.getType() == DebrisType.GRAPHITE) {
                List entities = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.field_70121_D.func_72314_b(2.5, 2.5, 2.5));
                int level = this.getType() == DebrisType.FUEL ? 9 : 4;
                for (EntityLivingBase e : entities) {
                    e.func_70690_d(new PotionEffect(HbmPotion.radiation.field_76415_H, 1200, level));
                }
            }
            if (!RBMKDials.getPermaScrap(this.field_70170_p) && this.field_70173_aa > this.getLifetime() + this.func_145782_y() % 50) {
                this.func_70106_y();
            }
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.field_70181_x -= 0.04;
        this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.lastRot = this.rot;
        if (this.field_70122_E) {
            this.field_70159_w *= 0.85;
            this.field_70179_y *= 0.85;
            this.field_70181_x *= -0.5;
        } else {
            this.rot += 10.0f;
            if (this.rot >= 360.0f) {
                this.rot -= 360.0f;
                this.lastRot -= 360.0f;
            }
        }
    }

    @Override
    protected int getLifetime() {
        switch (this.getType()) {
            case BLANK: {
                return 3600;
            }
            case ELEMENT: {
                return 3600;
            }
            case FUEL: {
                return 12000;
            }
            case GRAPHITE: {
                return 18000;
            }
            case LID: {
                return 600;
            }
            case ROD: {
                return 1200;
            }
        }
        return 0;
    }

    public void setType(DebrisType type) {
        this.field_70180_af.func_75692_b(20, (Object)type.ordinal());
    }

    public DebrisType getType() {
        return DebrisType.values()[Math.abs(this.field_70180_af.func_75679_c(20)) % DebrisType.values().length];
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbt) {
        this.field_70180_af.func_75692_b(20, (Object)nbt.func_74762_e("debtype"));
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74768_a("debtype", this.field_70180_af.func_75679_c(20));
    }

    public static enum DebrisType {
        BLANK,
        ELEMENT,
        FUEL,
        ROD,
        GRAPHITE,
        LID;

    }
}

