/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.mob.siege;

import com.hbm.items.ModItems;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;

public class SiegeTier {
    public static SiegeTier[] tiers = new SiegeTier[100];
    private static int nextID = 0;
    public static SiegeTier DEFAULT_BUFF;
    public static SiegeTier CLAY;
    public static SiegeTier STONE;
    public static SiegeTier IRON;
    public static SiegeTier SILVER;
    public static SiegeTier GOLD;
    public static SiegeTier DESH;
    public static SiegeTier SCHRAB;
    public static SiegeTier DNT;
    public int id;
    public float dt = 0.0f;
    public float dr = 0.0f;
    public float health = 20.0f;
    public String name = "";
    public float damageMod = 1.0f;
    public float speedMod = 0.0f;
    public boolean fireProof = false;
    public boolean noFall = false;
    public boolean noFriendlyFire = false;
    public List<ItemStack> dropItem = new ArrayList<ItemStack>();
    public float laserBreak = 0.0f;
    public float laserExplosive = 0.0f;
    public boolean laserIncendiary = false;
    public Consumer<EntityLivingBase> delegate;

    public static int getLength() {
        return nextID;
    }

    public static void registerTiers() {
        DEFAULT_BUFF = new SiegeTier(20.0f, "buff").addDrop(new ItemStack(ModItems.ingot_steel, 1, 0)).setDR(0.2f).setDMG(2.0f).setLaser(0.0f, 0.0f, false);
        CLAY = new SiegeTier(30.0f, "clay").addDrop(new ItemStack(ModItems.ingot_steel, 1, 0)).setDR(0.2f).setDMG(3.0f).setLaser(0.0f, 0.0f, false);
        STONE = new SiegeTier(40.0f, "stone").addDrop(new ItemStack(ModItems.ingot_steel, 1, 0)).setDR(0.3f).setDT(1.0f).setFP().setDMG(5.0f).setLaser(0.0f, 0.0f, true);
        IRON = new SiegeTier(50.0f, "iron").addDrop(new ItemStack(ModItems.ingot_steel, 1, 0)).setDR(0.3f).setDT(2.0f).setFP().setDMG(7.5f).setFF().setLaser(0.0f, 1.0f, true);
        SILVER = new SiegeTier(70.0f, "silver").addDrop(new ItemStack(ModItems.ingot_steel, 1, 0)).setDR(0.5f).setDT(3.0f).setNF().setFP().setDMG(10.0f).setSP(0.5f).setFF().setLaser(0.01f, 1.0f, true);
        GOLD = new SiegeTier(100.0f, "gold").addDrop(new ItemStack(ModItems.ingot_steel, 1, 0)).setDR(0.5f).setDT(5.0f).setNF().setFP().setDMG(15.0f).setSP(0.5f).setFF().setLaser(0.02f, 1.5f, true);
        DESH = new SiegeTier(150.0f, "desh").addDrop(new ItemStack(ModItems.ingot_steel, 1, 0)).setDR(0.7f).setDT(7.0f).setNF().setFP().setDMG(25.0f).setSP(0.5f).setFF().setLaser(0.05f, 1.5f, true);
        SCHRAB = new SiegeTier(250.0f, "schrab").addDrop(new ItemStack(ModItems.ingot_steel, 1, 0)).setDR(0.7f).setDT(10.0f).setNF().setFP().setDMG(50.0f).setSP(1.0f).setFF().setLaser(0.1f, 2.0f, true);
        DNT = new SiegeTier(500.0f, "dnt").addDrop(new ItemStack(ModItems.ingot_steel, 1, 0)).setDR(0.9f).setDT(20.0f).setNF().setFP().setDMG(100.0f).setSP(1.0f).setFF().setLaser(0.2f, 2.0f, true);
    }

    public SiegeTier(float baseHealth, String name) {
        this.id = nextID++;
        SiegeTier.tiers[this.id] = this;
        this.health = baseHealth;
        this.name = name;
    }

    private SiegeTier setDT(float dt) {
        this.dt = dt;
        return this;
    }

    private SiegeTier setDR(float dr) {
        this.dr = dr;
        return this;
    }

    private SiegeTier setDMG(float dmg) {
        this.damageMod = dmg;
        return this;
    }

    private SiegeTier setSP(float sp) {
        this.speedMod = sp;
        return this;
    }

    private SiegeTier setFP() {
        this.fireProof = true;
        return this;
    }

    private SiegeTier setNF() {
        this.noFall = true;
        return this;
    }

    private SiegeTier setFF() {
        this.noFriendlyFire = true;
        return this;
    }

    private SiegeTier setLaser(float breaking, float explosive, boolean incendiary) {
        this.laserBreak = breaking;
        this.laserExplosive = explosive;
        this.laserIncendiary = incendiary;
        return this;
    }

    private SiegeTier addDrop(Item drop) {
        return this.addDrop(new ItemStack(drop));
    }

    private SiegeTier addDrop(ItemStack drop) {
        this.dropItem.add(drop);
        return this;
    }

    private SiegeTier setAura(int range, PotionEffect ... effects) {
        this.daisyChain(x -> SiegeTier.doAura(x, range, effects));
        return this;
    }

    private SiegeTier daisyChain(Consumer<EntityLivingBase> link) {
        if (this.delegate == null) {
            this.delegate = link;
        } else {
            this.delegate.andThen(link);
        }
        return this;
    }

    public void runDelegate(EntityLivingBase entity) {
        if (this.delegate != null) {
            this.delegate.accept(entity);
        }
    }

    private static void doAura(EntityLivingBase entity, int range, PotionEffect ... effects) {
        List players = entity.field_70170_p.func_72872_a(EntityPlayer.class, entity.field_70121_D.func_72314_b((double)range, (double)range, (double)range));
        for (EntityPlayer player : players) {
            if (!(player.func_70068_e((Entity)entity) < (double)(range * range))) continue;
            for (PotionEffect e : effects) {
                player.func_70690_d(new PotionEffect(e));
            }
        }
    }
}

