/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.mob.siege;

import api.hbm.entity.IRadiationImmune;
import com.hbm.entity.mob.EntityUFOBase;
import com.hbm.entity.mob.siege.SiegeTier;
import com.hbm.entity.projectile.EntitySiegeLaser;
import com.hbm.handler.SiegeOrchestrator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntitySiegeUFO
extends EntityUFOBase
implements IRadiationImmune {
    private int attackCooldown;

    public EntitySiegeUFO(World world) {
        super(world);
        this.func_70105_a(1.5f, 1.0f);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_70096_w().func_75682_a(12, (Object)0);
    }

    public void setTier(SiegeTier tier) {
        this.func_70096_w().func_75692_b(12, (Object)tier.id);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)tier.speedMod);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)tier.health * 0.25);
        this.func_70606_j(this.func_110138_aP());
    }

    public SiegeTier getTier() {
        SiegeTier tier = SiegeTier.tiers[this.func_70096_w().func_75679_c(12)];
        return tier != null ? tier : SiegeTier.CLAY;
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (this.func_85032_ar()) {
            return false;
        }
        if (SiegeOrchestrator.isSiegeMob(source.func_76346_g())) {
            return false;
        }
        SiegeTier tier = this.getTier();
        if (tier.fireProof && source.func_76347_k()) {
            this.func_70066_B();
            return false;
        }
        if (tier.noFriendlyFire && source instanceof EntityDamageSource && !(((EntityDamageSource)source).func_76346_g() instanceof EntityPlayer)) {
            return false;
        }
        if ((damage -= tier.dt) < 0.0f) {
            this.field_70170_p.func_72956_a((Entity)this, "random.break", 5.0f, 1.0f + this.field_70146_Z.nextFloat() * 0.5f);
            return false;
        }
        return super.func_70097_a(source, damage *= 1.0f - tier.dr);
    }

    @Override
    protected void func_70626_be() {
        super.func_70626_be();
        if (this.courseChangeCooldown > 0) {
            --this.courseChangeCooldown;
        }
        if (this.scanCooldown > 0) {
            --this.scanCooldown;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.attackCooldown > 0) {
                --this.attackCooldown;
            }
            if (this.attackCooldown == 0 && this.target != null) {
                this.attackCooldown = 20 + this.field_70146_Z.nextInt(5);
                double x = this.field_70165_t;
                double y = this.field_70163_u;
                double z = this.field_70161_v;
                Vec3 vec = Vec3.func_72443_a((double)(this.target.field_70165_t - x), (double)(this.target.field_70163_u + (double)this.target.field_70131_O * 0.5 - y), (double)(this.target.field_70161_v - z)).func_72432_b();
                SiegeTier tier = this.getTier();
                EntitySiegeLaser laser = new EntitySiegeLaser(this.field_70170_p, (EntityLivingBase)this);
                laser.func_70107_b(x, y, z);
                laser.func_70186_c(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, 1.0f, 0.15f);
                laser.setColor(0x802000);
                laser.setDamage(tier.damageMod);
                laser.setExplosive(tier.laserExplosive);
                laser.setBreakChance(tier.laserBreak);
                if (tier.laserIncendiary) {
                    laser.setIncendiary();
                }
                this.field_70170_p.func_72838_d((Entity)laser);
                this.func_85030_a("hbm:weapon.ballsLaser", 2.0f, 1.0f);
            }
        }
        if (this.courseChangeCooldown > 0) {
            this.approachPosition(this.target == null ? 0.25 : 0.5 + this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() * 1.0);
        }
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("siegeTier", this.getTier().id);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setTier(SiegeTier.tiers[nbt.func_74762_e("siegeTier")]);
    }

    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        this.setTier(SiegeTier.tiers[this.field_70146_Z.nextInt(SiegeTier.getLength())]);
        return super.func_110161_a(data);
    }

    protected void func_70628_a(boolean byPlayer, int fortune) {
        if (byPlayer) {
            for (ItemStack drop : this.getTier().dropItem) {
                this.func_70099_a(drop.func_77946_l(), 0.0f);
            }
        }
    }
}

