/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.mob.siege;

import api.hbm.entity.IRadiationImmune;
import com.hbm.entity.mob.siege.SiegeTier;
import com.hbm.entity.projectile.EntitySiegeLaser;
import com.hbm.handler.SiegeOrchestrator;
import com.hbm.items.ModItems;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIArrowAttack;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntitySiegeSkeleton
extends EntityMob
implements IRangedAttackMob,
IRadiationImmune {
    public EntitySiegeSkeleton(World world) {
        super(world);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIArrowAttack((IRangedAttackMob)this, 1.0, 20, 60, 15.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (this.func_85032_ar()) {
            return false;
        }
        if (SiegeOrchestrator.isSiegeMob(source.func_76346_g())) {
            return false;
        }
        SiegeTier tier = this.getTier();
        if (tier.fireProof && source.func_76347_k()) {
            this.func_70066_B();
            return false;
        }
        if (tier.noFall && source == DamageSource.field_76379_h) {
            return false;
        }
        if (tier.noFriendlyFire && source instanceof EntityDamageSource && !(((EntityDamageSource)source).func_76346_g() instanceof EntityPlayer)) {
            return false;
        }
        if ((damage -= tier.dt) < 0.0f) {
            this.field_70170_p.func_72956_a((Entity)this, "random.break", 5.0f, 1.0f + this.field_70146_Z.nextFloat() * 0.5f);
            return false;
        }
        return super.func_70097_a(source, damage *= 1.0f - tier.dr);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_70096_w().func_75682_a(12, (Object)0);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.23);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
    }

    public void setTier(SiegeTier tier) {
        this.func_70096_w().func_75692_b(12, (Object)tier.id);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(new AttributeModifier("Tier Speed Mod", (double)tier.speedMod, 1));
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111121_a(new AttributeModifier("Tier Damage Mod", (double)tier.damageMod, 1));
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)tier.health);
        this.func_70606_j(this.func_110138_aP());
    }

    public SiegeTier getTier() {
        SiegeTier tier = SiegeTier.tiers[this.func_70096_w().func_75679_c(12)];
        return tier != null ? tier : SiegeTier.CLAY;
    }

    protected void func_82164_bB() {
        super.func_82164_bB();
        this.func_70062_b(0, new ItemStack(ModItems.detonator_laser));
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("siegeTier", this.getTier().id);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setTier(SiegeTier.tiers[nbt.func_74762_e("siegeTier")]);
    }

    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        this.setTier(SiegeTier.tiers[this.field_70146_Z.nextInt(SiegeTier.getLength())]);
        this.func_82164_bB();
        return super.func_110161_a(data);
    }

    public void func_82196_d(EntityLivingBase target, float f) {
        double x = this.field_70165_t;
        double y = this.field_70163_u + (double)this.func_70047_e();
        double z = this.field_70161_v;
        Vec3 vec = Vec3.func_72443_a((double)(target.field_70165_t - x), (double)(target.field_70163_u + target.func_70033_W() + (double)target.field_70131_O * 0.5 - y), (double)(target.field_70161_v - z)).func_72432_b();
        SiegeTier tier = this.getTier();
        for (int i = 0; i < 3; ++i) {
            EntitySiegeLaser laser = new EntitySiegeLaser(this.field_70170_p, (EntityLivingBase)this);
            laser.func_70107_b(x, y, z);
            laser.func_70186_c(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, 1.0f, i == 1 ? 0.15f : 5.0f);
            laser.setColor(0x808000);
            laser.setDamage(tier.damageMod);
            laser.setExplosive(tier.laserExplosive);
            laser.setBreakChance(tier.laserBreak);
            if (tier.laserIncendiary) {
                laser.setIncendiary();
            }
            this.field_70170_p.func_72838_d((Entity)laser);
        }
        this.func_85030_a("hbm:weapon.ballsLaser", 2.0f, 0.9f + this.field_70146_Z.nextFloat() * 0.2f);
    }

    protected boolean func_70650_aV() {
        return true;
    }

    protected String func_70639_aQ() {
        return "hbm:entity.siegeIdle";
    }

    protected String func_70621_aR() {
        return "hbm:entity.siegeHurt";
    }

    protected String func_70673_aS() {
        return "hbm:entity.siegeDeath";
    }

    protected void func_70628_a(boolean byPlayer, int fortune) {
        if (byPlayer) {
            for (ItemStack drop : this.getTier().dropItem) {
                this.func_70099_a(drop.func_77946_l(), 0.0f);
            }
        }
    }
}

