/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.mob.siege;

import com.hbm.entity.mob.EntityUFOBase;
import com.hbm.entity.mob.siege.SiegeTier;
import com.hbm.entity.projectile.EntitySiegeLaser;
import com.hbm.handler.SiegeOrchestrator;
import com.hbm.lib.ModDamageSource;
import com.hbm.packet.AuxParticlePacketNT;
import com.hbm.packet.PacketDispatcher;
import com.hbm.util.ContaminationUtil;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntitySiegeCraft
extends EntityUFOBase
implements IBossDisplayData {
    private int attackCooldown;
    private int beamCountdown;

    public EntitySiegeCraft(World world) {
        super(world);
        this.func_70105_a(7.0f, 1.0f);
        this.field_70178_ae = true;
        this.field_70158_ak = true;
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (this.func_85032_ar()) {
            return false;
        }
        if (SiegeOrchestrator.isSiegeMob(source.func_76346_g())) {
            return false;
        }
        SiegeTier tier = this.getTier();
        if (tier.fireProof && source.func_76347_k()) {
            this.func_70066_B();
            return false;
        }
        if (tier.noFriendlyFire && source instanceof EntityDamageSource && !(((EntityDamageSource)source).func_76346_g() instanceof EntityPlayer)) {
            return false;
        }
        if ((damage -= tier.dt) < 0.0f) {
            this.field_70170_p.func_72956_a((Entity)this, "random.break", 5.0f, 1.0f + this.field_70146_Z.nextFloat() * 0.5f);
            return false;
        }
        return super.func_70097_a(source, damage *= 1.0f - tier.dr);
    }

    protected void func_70609_aI() {
        this.beamCountdown = 200;
        this.setBeam(false);
        this.field_70181_x -= 0.05;
        if (this.field_70725_aQ == 19 && !this.field_70170_p.field_72995_K) {
            NBTTagCompound data = new NBTTagCompound();
            data.func_74778_a("type", "tinytot");
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(data, this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v), new NetworkRegistry.TargetPoint(this.field_71093_bK, this.field_70165_t, this.field_70163_u, this.field_70161_v, 250.0));
            this.field_70170_p.func_72908_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, "hbm:weapon.mukeExplosion", 15.0f, 1.0f);
        }
        super.func_70609_aI();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_70096_w().func_75682_a(12, (Object)0);
        this.func_70096_w().func_75682_a(13, (Object)Float.valueOf(0.0f));
        this.func_70096_w().func_75682_a(14, (Object)Float.valueOf(0.0f));
        this.func_70096_w().func_75682_a(15, (Object)Float.valueOf(0.0f));
        this.func_70096_w().func_75682_a(16, (Object)0);
    }

    public void setTier(SiegeTier tier) {
        this.func_70096_w().func_75692_b(12, (Object)tier.id);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)tier.speedMod);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)(tier.health * 25.0f));
        this.func_70606_j(this.func_110138_aP());
    }

    public SiegeTier getTier() {
        SiegeTier tier = SiegeTier.tiers[this.func_70096_w().func_75679_c(12)];
        return tier != null ? tier : SiegeTier.CLAY;
    }

    public void setBeam(boolean beam) {
        this.func_70096_w().func_75692_b(16, (Object)(beam ? (byte)1 : 0));
    }

    public boolean getBeam() {
        return this.func_70096_w().func_75683_a(16) == 1;
    }

    public void setLockon(double x, double y, double z) {
        this.func_70096_w().func_75692_b(13, (Object)Float.valueOf((float)x));
        this.func_70096_w().func_75692_b(14, (Object)Float.valueOf((float)y));
        this.func_70096_w().func_75692_b(15, (Object)Float.valueOf((float)z));
    }

    public Vec3 getLockon() {
        return Vec3.func_72443_a((double)this.func_70096_w().func_111145_d(13), (double)this.func_70096_w().func_111145_d(14), (double)this.func_70096_w().func_111145_d(15));
    }

    @Override
    protected int getScanRange() {
        return 100;
    }

    @Override
    protected int targetHeightOffset() {
        return 7 + this.field_70146_Z.nextInt(5);
    }

    @Override
    protected int wanderHeightOffset() {
        return 10 + this.field_70146_Z.nextInt(2);
    }

    @Override
    protected void func_70626_be() {
        super.func_70626_be();
        if (this.courseChangeCooldown > 0) {
            --this.courseChangeCooldown;
        }
        if (this.scanCooldown > 0) {
            --this.scanCooldown;
        }
        if (!this.field_70170_p.field_72995_K) {
            double z;
            double y;
            double x;
            if (this.attackCooldown > 0) {
                --this.attackCooldown;
            }
            if (this.beamCountdown > 0) {
                --this.beamCountdown;
            }
            if (this.field_70146_Z.nextInt(50) == 0) {
                NBTTagCompound dPart = new NBTTagCompound();
                dPart.func_74778_a("type", "tau");
                dPart.func_74774_a("count", (byte)(2 + this.field_70146_Z.nextInt(3)));
                PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(dPart, this.field_70165_t + this.field_70146_Z.nextGaussian() * 2.0, this.field_70163_u + this.field_70146_Z.nextGaussian(), this.field_70161_v + this.field_70146_Z.nextGaussian() * 2.0), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.field_76574_g, this.field_70165_t, this.field_70163_u, this.field_70161_v, 50.0));
            }
            boolean beam = false;
            if (this.target == null || this.beamCountdown <= 0) {
                this.beamCountdown = 300;
            } else {
                if (this.beamCountdown >= 60 && this.beamCountdown < 120) {
                    x = this.target.field_70165_t;
                    y = this.target.field_70163_u + (double)this.target.field_70131_O * 0.5;
                    z = this.target.field_70161_v;
                    this.setLockon(x, y, z);
                    if (this.beamCountdown == 110) {
                        this.field_70170_p.func_72956_a(this.target, "hbm:weapon.stingerLockOn", 2.0f, 0.75f);
                    }
                }
                if (this.beamCountdown >= 40 && this.beamCountdown < 100) {
                    Vec3 lockon = this.getLockon();
                    NBTTagCompound fx = new NBTTagCompound();
                    fx.func_74778_a("type", "vanillaburst");
                    fx.func_74778_a("mode", "reddust");
                    fx.func_74780_a("motion", 0.2);
                    fx.func_74768_a("count", 5);
                    PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(fx, lockon.field_72450_a, lockon.field_72448_b, lockon.field_72449_c), new NetworkRegistry.TargetPoint(this.field_71093_bK, lockon.field_72450_a, lockon.field_72448_b, lockon.field_72449_c, 100.0));
                }
                if (this.beamCountdown < 40) {
                    Vec3 lockon = this.getLockon();
                    if (this.beamCountdown == 39) {
                        this.field_70170_p.func_72908_a(lockon.field_72450_a, lockon.field_72448_b, lockon.field_72449_c, "hbm:entity.ufoBlast", 5.0f, 0.9f + this.field_70170_p.field_73012_v.nextFloat() * 0.2f);
                    }
                    List entities = this.field_70170_p.func_72839_b((Entity)this, AxisAlignedBB.func_72330_a((double)lockon.field_72450_a, (double)lockon.field_72448_b, (double)lockon.field_72449_c, (double)lockon.field_72450_a, (double)lockon.field_72448_b, (double)lockon.field_72449_c).func_72314_b(2.0, 2.0, 2.0));
                    for (Entity e : entities) {
                        if (!this.func_70686_a(e.getClass())) continue;
                        e.func_70097_a(ModDamageSource.causeCombineDamage((Entity)this, e), 1000.0f);
                        e.func_70015_d(5);
                        if (!(e instanceof EntityLivingBase)) continue;
                        ContaminationUtil.contaminate((EntityLivingBase)e, ContaminationUtil.HazardType.RADIATION, ContaminationUtil.ContaminationType.CREATIVE, 5.0f);
                    }
                    NBTTagCompound data = new NBTTagCompound();
                    data.func_74778_a("type", "plasmablast");
                    data.func_74776_a("r", 0.0f);
                    data.func_74776_a("g", 0.75f);
                    data.func_74776_a("b", 1.0f);
                    data.func_74776_a("pitch", -90.0f + this.field_70146_Z.nextFloat() * 180.0f);
                    data.func_74776_a("yaw", this.field_70146_Z.nextFloat() * 180.0f);
                    data.func_74776_a("scale", 5.0f);
                    PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(data, lockon.field_72450_a, lockon.field_72448_b, lockon.field_72449_c), new NetworkRegistry.TargetPoint(this.field_71093_bK, lockon.field_72450_a, lockon.field_72448_b, lockon.field_72449_c, 150.0));
                    beam = true;
                }
            }
            this.setBeam(beam);
            if (this.attackCooldown == 0 && this.target != null) {
                this.attackCooldown = 30 + this.field_70146_Z.nextInt(10);
                x = this.field_70165_t;
                y = this.field_70163_u;
                z = this.field_70161_v;
                Vec3 vec = Vec3.func_72443_a((double)(this.target.field_70165_t - x), (double)(this.target.field_70163_u + (double)this.target.field_70131_O * 0.5 - y), (double)(this.target.field_70161_v - z)).func_72432_b();
                SiegeTier tier = this.getTier();
                float health = this.func_110143_aJ() / this.func_110138_aP();
                int r = (int)(255.0f * (1.0f - health));
                int g = (int)(255.0f * health);
                int b = 0;
                int color = r << 16 | g << 8 | b;
                for (int i = 0; i < 7; ++i) {
                    Vec3 copy = Vec3.func_72443_a((double)vec.field_72450_a, (double)vec.field_72448_b, (double)vec.field_72449_c);
                    copy.func_72442_b((float)Math.PI / 180 * (float)(i - 3) * 5.0f);
                    EntitySiegeLaser laser = new EntitySiegeLaser(this.field_70170_p, (EntityLivingBase)this);
                    laser.func_70107_b(x, y, z);
                    laser.func_70186_c(copy.field_72450_a, copy.field_72448_b, copy.field_72449_c, 1.0f, 0.0f);
                    laser.setColor(color);
                    laser.setDamage(tier.damageMod);
                    laser.setBreakChance(tier.laserBreak * 2.0f);
                    if (tier.laserIncendiary) {
                        laser.setIncendiary();
                    }
                    this.field_70170_p.func_72838_d((Entity)laser);
                }
                this.func_85030_a("hbm:weapon.ballsLaser", 2.0f, 1.0f);
            }
        }
        if (this.courseChangeCooldown > 0) {
            this.approachPosition(this.target == null ? 0.25 : 0.5 + this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() * 1.0);
        }
    }

    @Override
    protected void setCourseWithoutTaget() {
        int x = (int)Math.floor(this.field_70165_t + this.field_70146_Z.nextGaussian() * 15.0);
        int z = (int)Math.floor(this.field_70161_v + this.field_70146_Z.nextGaussian() * 15.0);
        this.setWaypoint(x, this.field_70170_p.func_72976_f(x, z) + 5 + this.field_70146_Z.nextInt(6), z);
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("siegeTier", this.getTier().id);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setTier(SiegeTier.tiers[nbt.func_74762_e("siegeTier")]);
    }

    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        this.setTier(SiegeTier.tiers[this.field_70146_Z.nextInt(SiegeTier.getLength())]);
        return super.func_110161_a(data);
    }

    protected void func_70628_a(boolean byPlayer, int fortune) {
        if (byPlayer) {
            for (ItemStack drop : this.getTier().dropItem) {
                this.func_70099_a(drop.func_77946_l(), 0.0f);
            }
        }
    }
}

