/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.mob;

import com.hbm.config.MobConfig;
import com.hbm.entity.pathfinder.PathFinderUtils;
import com.hbm.handler.pollution.PollutionHandler;
import com.hbm.items.ModItems;
import com.hbm.main.ResourceManager;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class EntityGlyphid
extends EntityMob {
    public EntityGlyphid(World world) {
        super(world);
        this.func_70105_a(1.75f, 1.0f);
    }

    public ResourceLocation getSkin() {
        return ResourceManager.glyphid_tex;
    }

    public double getScale() {
        return 1.0;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)new Byte(0));
        this.field_70180_af.func_75682_a(17, (Object)new Byte(31));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(5.0);
    }

    protected void func_70628_a(boolean byPlayer, int looting) {
        if (this.field_70146_Z.nextInt(3) == 0) {
            this.func_70099_a(new ItemStack(ModItems.glyphid_meat, 1 + this.field_70146_Z.nextInt(2) + looting), 0.0f);
        }
    }

    protected Entity func_70782_k() {
        if (this.func_70644_a(Potion.field_76440_q)) {
            return null;
        }
        EntityPlayer entityplayer = this.field_70170_p.func_72856_b((Entity)this, this.useExtendedTargeting() ? 128.0 : 16.0);
        return entityplayer != null && this.func_70685_l((Entity)entityplayer) ? entityplayer : null;
    }

    protected void func_70626_be() {
        super.func_70626_be();
        if (this.func_70644_a(Potion.field_76440_q)) {
            this.field_70789_a = null;
            this.func_70778_a(null);
        } else if (this.useExtendedTargeting() && this.field_70789_a != null && !this.func_70781_l()) {
            this.func_70778_a(PathFinderUtils.getPathEntityToEntityPartial(this.field_70170_p, (Entity)this, this.field_70789_a, 16.0f, true, false, false, true));
        }
    }

    public boolean useExtendedTargeting() {
        return (double)PollutionHandler.getPollution(this.field_70170_p, (int)Math.floor(this.field_70165_t), (int)Math.floor(this.field_70163_u), (int)Math.floor(this.field_70161_v), PollutionHandler.PollutionType.SOOT) >= MobConfig.targetingThreshold;
    }

    protected boolean func_70692_ba() {
        return this.field_70789_a == null;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (!(source.func_151517_h() || source.func_76363_c() || this.field_70170_p.field_72995_K || source.func_76347_k() || source.func_76355_l().equals("ice"))) {
            byte armor = this.field_70180_af.func_75683_a(17);
            if (armor != 0) {
                if (amount < this.getDamageThreshold()) {
                    return false;
                }
                int chance = this.getArmorBreakChance(amount);
                if (this.field_70146_Z.nextInt(chance) == 0 && amount > 1.0f) {
                    this.breakOffArmor();
                    amount *= 0.25f;
                }
                if ((amount -= this.getDamageThreshold()) < 0.0f) {
                    return true;
                }
            }
            amount = this.calculateDamage(amount);
        }
        if (source.func_76347_k()) {
            amount *= 4.0f;
        }
        return super.func_70097_a(source, amount);
    }

    public int getArmorBreakChance(float amount) {
        return amount < 10.0f ? 5 : (amount < 20.0f ? 3 : 2);
    }

    public float calculateDamage(float amount) {
        byte armor = this.field_70180_af.func_75683_a(17);
        int divisor = 1;
        for (int i = 0; i < 5; ++i) {
            if ((armor & 1 << i) <= 0) continue;
            ++divisor;
        }
        return amount /= (float)divisor;
    }

    public float getDamageThreshold() {
        return 0.5f;
    }

    public void breakOffArmor() {
        byte armor = this.field_70180_af.func_75683_a(17);
        List<Integer> indices = Arrays.asList(0, 1, 2, 3, 4);
        Collections.shuffle(indices);
        for (Integer i : indices) {
            byte bit = (byte)(1 << i);
            if ((armor & bit) <= 0) continue;
            armor = (byte)(armor & ~bit);
            armor = (byte)(armor & 0x1F);
            this.field_70180_af.func_75692_b(17, (Object)armor);
            this.field_70170_p.func_72956_a((Entity)this, "mob.zombie.woodbreak", 1.0f, 1.25f);
            break;
        }
    }

    public boolean func_70652_k(Entity victum) {
        if (this.field_82175_bq) {
            return false;
        }
        this.func_71038_i();
        return super.func_70652_k(victum);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.setBesideClimbableBlock(this.field_70123_F);
            if (this.field_70170_p.func_82737_E() % 200L == 0L) {
                this.func_71038_i();
            }
        }
    }

    protected void func_82168_bl() {
        int i = this.swingDuration();
        if (this.field_82175_bq) {
            ++this.field_110158_av;
            if (this.field_110158_av >= i) {
                this.field_110158_av = 0;
                this.field_82175_bq = false;
            }
        } else {
            this.field_110158_av = 0;
        }
        this.field_70733_aJ = (float)this.field_110158_av / (float)i;
    }

    public int swingDuration() {
        return 15;
    }

    public void func_70110_aj() {
    }

    public boolean func_70617_f_() {
        return this.isBesideClimbableBlock();
    }

    public boolean isBesideClimbableBlock() {
        return (this.field_70180_af.func_75683_a(16) & 1) != 0;
    }

    public void setBesideClimbableBlock(boolean climbable) {
        byte watchable = this.field_70180_af.func_75683_a(16);
        watchable = climbable ? (byte)(watchable | 1) : (byte)(watchable & 0xFFFFFFFE);
        this.field_70180_af.func_75692_b(16, (Object)watchable);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74774_a("armor", this.field_70180_af.func_75683_a(17));
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.field_70180_af.func_75692_b(17, (Object)nbt.func_74771_c("armor"));
    }
}

