/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.effect;

import com.hbm.extprop.HbmLivingProps;
import com.hbm.handler.radiation.ChunkRadiationManager;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.trait.FT_Corrosive;
import com.hbm.inventory.fluid.trait.FT_Flammable;
import com.hbm.inventory.fluid.trait.FT_Poison;
import com.hbm.inventory.fluid.trait.FT_Toxin;
import com.hbm.inventory.fluid.trait.FT_VentRadiation;
import com.hbm.inventory.fluid.trait.FluidTrait;
import com.hbm.inventory.fluid.trait.FluidTraitSimple;
import com.hbm.main.MainRegistry;
import com.hbm.util.ArmorUtil;
import com.hbm.util.ContaminationUtil;
import com.hbm.util.EntityDamageUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class EntityMist
extends Entity {
    public EntityMist(World world) {
        super(world);
        this.field_70145_X = true;
    }

    public EntityMist setArea(float width, float height) {
        this.field_70180_af.func_75692_b(11, (Object)Float.valueOf(width));
        this.field_70180_af.func_75692_b(12, (Object)Float.valueOf(height));
        return this;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(10, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(11, (Object)new Float(0.0f));
        this.field_70180_af.func_75682_a(12, (Object)new Float(0.0f));
    }

    public EntityMist setType(FluidType fluid) {
        this.field_70180_af.func_75692_b(10, (Object)fluid.getID());
        return this;
    }

    public FluidType getType() {
        return Fluids.fromID(this.field_70180_af.func_75679_c(10));
    }

    public void func_70030_z() {
        float height = this.field_70180_af.func_111145_d(12);
        this.field_70129_M = 0.0f;
        this.func_70105_a(this.field_70180_af.func_111145_d(11), height);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        if (!this.field_70170_p.field_72995_K) {
            FluidType type;
            if (this.field_70173_aa > this.getMaxAge()) {
                this.func_70106_y();
            }
            if ((type = this.getType()).hasTrait(FT_VentRadiation.class)) {
                FT_VentRadiation trait = type.getTrait(FT_VentRadiation.class);
                ChunkRadiationManager.proxy.incrementRad(this.field_70170_p, (int)Math.floor(this.field_70165_t), (int)Math.floor(this.field_70163_u), (int)Math.floor(this.field_70161_v), trait.getRadPerMB() * 2.0f);
            }
            double intensity = 1.0 - (double)this.field_70173_aa / (double)this.getMaxAge();
            if (type.hasTrait(FT_Flammable.class) && this.func_70027_ad()) {
                this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u + (double)(height / 2.0f), this.field_70161_v, (float)intensity * 15.0f, true);
                this.func_70106_y();
                return;
            }
            AxisAlignedBB aabb = this.field_70121_D.func_72329_c();
            List affected = this.field_70170_p.func_72839_b((Entity)this, aabb.func_72317_d((double)(-this.field_70130_N / 2.0f), 0.0, (double)(-this.field_70130_N / 2.0f)));
            for (Entity e : affected) {
                this.affect(e, intensity);
            }
        } else {
            for (int i = 0; i < 2; ++i) {
                double x = this.field_70121_D.field_72340_a + (this.field_70146_Z.nextDouble() - 0.5) * (this.field_70121_D.field_72336_d - this.field_70121_D.field_72340_a);
                double y = this.field_70121_D.field_72338_b + this.field_70146_Z.nextDouble() * (this.field_70121_D.field_72337_e - this.field_70121_D.field_72338_b);
                double z = this.field_70121_D.field_72339_c + (this.field_70146_Z.nextDouble() - 0.5) * (this.field_70121_D.field_72334_f - this.field_70121_D.field_72339_c);
                NBTTagCompound fx = new NBTTagCompound();
                fx.func_74778_a("type", "tower");
                fx.func_74776_a("lift", 0.5f);
                fx.func_74776_a("base", 0.75f);
                fx.func_74776_a("max", 2.0f);
                fx.func_74768_a("life", 50 + this.field_70170_p.field_73012_v.nextInt(10));
                fx.func_74768_a("color", this.getType().getColor());
                fx.func_74780_a("posX", x);
                fx.func_74780_a("posY", y);
                fx.func_74780_a("posZ", z);
                MainRegistry.proxy.effectNT(fx);
            }
        }
    }

    protected void affect(Entity e, double intensity) {
        FluidTrait trait;
        EntityLivingBase living;
        FluidType type = this.getType();
        EntityLivingBase entityLivingBase = living = e instanceof EntityLivingBase ? (EntityLivingBase)e : null;
        if (type.temperature >= 100) {
            EntityDamageUtil.attackEntityFromIgnoreIFrame(e, new DamageSource("boil"), 5.0f + (float)(type.temperature - 100) * 0.02f);
            if (type.temperature >= 500) {
                e.func_70015_d(10);
            }
        }
        if (type.temperature < -20 && living != null) {
            EntityDamageUtil.attackEntityFromIgnoreIFrame(e, new DamageSource("ice"), 5.0f + (float)(type.temperature + 20) * -0.05f);
            living.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 100, 2));
            living.func_70690_d(new PotionEffect(Potion.field_76419_f.field_76415_H, 100, 4));
        }
        if (type.hasTrait(Fluids.DELICIOUS.getClass()) && living != null && living.func_70089_S()) {
            living.func_70691_i(2.0f * (float)intensity);
        }
        if (type.hasTrait(FT_Flammable.class) && type.hasTrait(FluidTraitSimple.FT_Liquid.class) && living != null) {
            HbmLivingProps.setOil(living, 200);
        }
        if (this.isExtinguishing(type)) {
            e.func_70066_B();
        }
        if (type.hasTrait(FT_Corrosive.class)) {
            trait = type.getTrait(FT_Corrosive.class);
            EntityDamageUtil.attackEntityFromIgnoreIFrame(e, new DamageSource("acidPlayer"), (float)((FT_Corrosive)trait).getRating() / 20.0f);
            if (living != null) {
                for (int i = 0; i < 4; ++i) {
                    ArmorUtil.damageSuit(living, i, ((FT_Corrosive)trait).getRating() / 5);
                }
            }
        }
        if (type.hasTrait(FT_VentRadiation.class)) {
            trait = type.getTrait(FT_VentRadiation.class);
            if (living != null) {
                ContaminationUtil.contaminate(living, ContaminationUtil.HazardType.RADIATION, ContaminationUtil.ContaminationType.CREATIVE, ((FT_VentRadiation)trait).getRadPerMB() * 5.0f);
            }
        }
        if (type.hasTrait(FT_Poison.class)) {
            trait = type.getTrait(FT_Poison.class);
            if (living != null) {
                living.func_70690_d(new PotionEffect(((FT_Poison)trait).isWithering() ? Potion.field_82731_v.field_76415_H : Potion.field_76436_u.field_76415_H, (int)(100.0 * intensity)));
            }
        }
        if (type.hasTrait(FT_Toxin.class)) {
            trait = type.getTrait(FT_Toxin.class);
            if (living != null) {
                ((FT_Toxin)trait).affect(living, intensity);
            }
        }
    }

    protected boolean isExtinguishing(FluidType type) {
        return EntityMist.getStyleFromType(type) == SprayStyle.MIST && this.getType().temperature < 50 && !type.hasTrait(FT_Flammable.class);
    }

    public int getMaxAge() {
        return EntityMist.getStyleFromType(this.getType()) == SprayStyle.GAS ? 600 : 150;
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        this.setType(Fluids.fromID(nbt.func_74762_e("type")));
        this.setArea(nbt.func_74760_g("width"), nbt.func_74760_g("height"));
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74768_a("type", this.getType().getID());
        nbt.func_74776_a("width", this.field_70180_af.func_111145_d(11));
        nbt.func_74776_a("height", this.field_70180_af.func_111145_d(12));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_90999_ad() {
        return false;
    }

    public void func_70091_d(double x, double y, double z) {
    }

    public void func_70024_g(double x, double y, double z) {
    }

    public void func_70107_b(double x, double y, double z) {
        if (this.field_70173_aa == 0) {
            super.func_70107_b(x, y, z);
        }
    }

    public static SprayStyle getStyleFromType(FluidType type) {
        if (type.hasTrait(FluidTraitSimple.FT_Viscous.class)) {
            return SprayStyle.NULL;
        }
        if (type.hasTrait(FluidTraitSimple.FT_Gaseous.class) || type.hasTrait(FluidTraitSimple.FT_Gaseous_ART.class)) {
            return SprayStyle.GAS;
        }
        if (type.hasTrait(FluidTraitSimple.FT_Liquid.class)) {
            return SprayStyle.MIST;
        }
        return SprayStyle.NULL;
    }

    public static enum SprayStyle {
        MIST,
        GAS,
        NULL;

    }
}

