/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.config;

import com.google.common.collect.HashBiMap;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.blocks.ModBlocks;
import com.hbm.inventory.RecipesCommon;
import com.hbm.main.MainRegistry;
import com.hbm.util.Compat;
import com.hbm.util.Tuple;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class FalloutConfigJSON {
    public static final List<FalloutEntry> entries = new ArrayList<FalloutEntry>();
    public static Random rand = new Random();
    public static final Gson gson = new Gson();
    public static HashBiMap<String, Material> matNames = HashBiMap.create();

    public static void initialize() {
        File folder = MainRegistry.configHbmDir;
        File config = new File(folder.getAbsolutePath() + File.separatorChar + "hbmFallout.json");
        File template = new File(folder.getAbsolutePath() + File.separatorChar + "_hbmFallout.json");
        FalloutConfigJSON.initDefault();
        if (!config.exists()) {
            FalloutConfigJSON.writeDefault(template);
        } else {
            List<FalloutEntry> conf = FalloutConfigJSON.readConfig(config);
            if (conf != null) {
                entries.clear();
                entries.addAll(conf);
            }
        }
    }

    private static void initDefault() {
        Block stone;
        double woodEffectRange = 65.0;
        entries.add(new FalloutEntry().mB((Block)Blocks.field_150362_t).prim(new Tuple.Triplet<Block, Integer, Integer>(Blocks.field_150350_a, 0, 1)).max(woodEffectRange));
        entries.add(new FalloutEntry().mB((Block)Blocks.field_150361_u).prim(new Tuple.Triplet<Block, Integer, Integer>(Blocks.field_150350_a, 0, 1)).max(woodEffectRange));
        entries.add(new FalloutEntry().mB(ModBlocks.waste_leaves).prim(new Tuple.Triplet<Block, Integer, Integer>(Blocks.field_150350_a, 0, 1)).max(woodEffectRange));
        entries.add(new FalloutEntry().mB((Block)Blocks.field_150362_t).prim(new Tuple.Triplet<Block, Integer, Integer>(ModBlocks.waste_leaves, 0, 1)).min(woodEffectRange));
        entries.add(new FalloutEntry().mB((Block)Blocks.field_150361_u).prim(new Tuple.Triplet<Block, Integer, Integer>(ModBlocks.waste_leaves, 0, 1)).min(woodEffectRange));
        entries.add(new FalloutEntry().mB(Blocks.field_150364_r).prim(new Tuple.Triplet<Block, Integer, Integer>(ModBlocks.waste_log, 0, 1)).max(woodEffectRange));
        entries.add(new FalloutEntry().mB(Blocks.field_150363_s).prim(new Tuple.Triplet<Block, Integer, Integer>(ModBlocks.waste_log, 0, 1)).max(woodEffectRange));
        entries.add(new FalloutEntry().mB(Blocks.field_150419_aX).mM(10).prim(new Tuple.Triplet<Block, Integer, Integer>(ModBlocks.waste_log, 0, 1)).max(woodEffectRange));
        entries.add(new FalloutEntry().mB(Blocks.field_150420_aW).mM(10).prim(new Tuple.Triplet<Block, Integer, Integer>(ModBlocks.waste_log, 0, 1)).max(woodEffectRange));
        entries.add(new FalloutEntry().mB(Blocks.field_150419_aX).prim(new Tuple.Triplet<Block, Integer, Integer>(Blocks.field_150350_a, 0, 1)).max(woodEffectRange));
        entries.add(new FalloutEntry().mB(Blocks.field_150420_aW).prim(new Tuple.Triplet<Block, Integer, Integer>(Blocks.field_150350_a, 0, 1)).max(woodEffectRange));
        entries.add(new FalloutEntry().mB(Blocks.field_150344_f).prim(new Tuple.Triplet<Block, Integer, Integer>(ModBlocks.waste_planks, 0, 1)).max(woodEffectRange));
        FalloutEntry stoneCore = new FalloutEntry().prim(new Tuple.Triplet<Block, Integer, Integer>(ModBlocks.sellafield, 1, 1)).max(5.0).sol(true);
        FalloutEntry stoneInner = new FalloutEntry().prim(new Tuple.Triplet<Block, Integer, Integer>(ModBlocks.sellafield, 0, 1)).min(5.0).max(15.0).sol(true);
        FalloutEntry stoneOuter = new FalloutEntry().prim(new Tuple.Triplet<Block, Integer, Integer>(ModBlocks.sellafield_slaked, 0, 1)).min(15.0).max(50.0).sol(true);
        entries.add(stoneCore.clone().mB(Blocks.field_150348_b));
        entries.add(stoneInner.clone().mB(Blocks.field_150348_b));
        entries.add(stoneOuter.clone().mB(Blocks.field_150348_b));
        entries.add(stoneCore.clone().mB(Blocks.field_150351_n));
        entries.add(stoneInner.clone().mB(Blocks.field_150351_n));
        entries.add(stoneOuter.clone().mB(Blocks.field_150351_n));
        entries.add(stoneCore.clone().mB(ModBlocks.sellafield_slaked));
        entries.add(stoneInner.clone().mB(ModBlocks.sellafield_slaked));
        entries.add(new FalloutEntry().mB((Block)Blocks.field_150349_c).prim(new Tuple.Triplet<Block, Integer, Integer>(ModBlocks.waste_earth, 0, 1)));
        entries.add(new FalloutEntry().mB((Block)Blocks.field_150391_bh).prim(new Tuple.Triplet<Block, Integer, Integer>(ModBlocks.waste_mycelium, 0, 1)));
        entries.add(new FalloutEntry().mB((Block)Blocks.field_150354_m).mM(0).prim(new Tuple.Triplet<Block, Integer, Integer>(ModBlocks.waste_trinitite, 0, 1)).c(0.05));
        entries.add(new FalloutEntry().mB((Block)Blocks.field_150354_m).mM(1).prim(new Tuple.Triplet<Block, Integer, Integer>(ModBlocks.waste_trinitite_red, 0, 1)).c(0.05));
        entries.add(new FalloutEntry().mB(Blocks.field_150435_aG).prim(new Tuple.Triplet<Block, Integer, Integer>(Blocks.field_150405_ch, 0, 1)));
        entries.add(new FalloutEntry().mB(Blocks.field_150341_Y).prim(new Tuple.Triplet<Block, Integer, Integer>(Blocks.field_150365_q, 0, 1)));
        entries.add(new FalloutEntry().mB(Blocks.field_150365_q).prim(new Tuple.Triplet<Block, Integer, Integer>(Blocks.field_150482_ag, 0, 3), new Tuple.Triplet<Block, Integer, Integer>(Blocks.field_150412_bA, 0, 2)).c(0.5));
        entries.add(new FalloutEntry().mB(ModBlocks.ore_lignite).prim(new Tuple.Triplet<Block, Integer, Integer>(Blocks.field_150482_ag, 0, 1)).c(0.2));
        entries.add(new FalloutEntry().mB(ModBlocks.ore_uranium).prim(new Tuple.Triplet<Block, Integer, Integer>(ModBlocks.ore_schrabidium, 0, 1), new Tuple.Triplet<Block, Integer, Integer>(ModBlocks.ore_uranium_scorched, 0, 99)));
        entries.add(new FalloutEntry().mB(ModBlocks.ore_nether_uranium).prim(new Tuple.Triplet<Block, Integer, Integer>(ModBlocks.ore_nether_schrabidium, 0, 1), new Tuple.Triplet<Block, Integer, Integer>(ModBlocks.ore_nether_uranium_scorched, 0, 99)));
        entries.add(new FalloutEntry().mB(ModBlocks.ore_gneiss_uranium).prim(new Tuple.Triplet<Block, Integer, Integer>(ModBlocks.ore_gneiss_schrabidium, 0, 1), new Tuple.Triplet<Block, Integer, Integer>(ModBlocks.ore_gneiss_uranium_scorched, 0, 99)));
        Block deepslate = Compat.tryLoadBlock("etfuturum", "deepslate");
        if (deepslate != null) {
            entries.add(stoneCore.clone().mB(deepslate));
            entries.add(stoneInner.clone().mB(deepslate));
            entries.add(stoneOuter.clone().mB(deepslate));
        }
        if ((stone = Compat.tryLoadBlock("etfuturum", "stone")) != null) {
            entries.add(stoneCore.clone().mB(stone));
            entries.add(stoneInner.clone().mB(stone));
            entries.add(stoneOuter.clone().mB(stone));
        }
    }

    private static void writeDefault(File file) {
        try {
            JsonWriter writer = new JsonWriter((Writer)new FileWriter(file));
            writer.setIndent("  ");
            writer.beginObject();
            writer.name("entries").beginArray();
            for (FalloutEntry entry : entries) {
                writer.beginObject();
                entry.write(writer);
                writer.endObject();
            }
            writer.endArray();
            writer.endObject();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static List<FalloutEntry> readConfig(File config) {
        try {
            JsonObject json = (JsonObject)gson.fromJson((Reader)new FileReader(config), JsonObject.class);
            JsonArray recipes = json.get("entries").getAsJsonArray();
            ArrayList<FalloutEntry> conf = new ArrayList<FalloutEntry>();
            for (JsonElement recipe : recipes) {
                conf.add(FalloutEntry.readEntry(recipe));
            }
            return conf;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    static {
        matNames.put((Object)"grass", (Object)Material.field_151577_b);
        matNames.put((Object)"ground", (Object)Material.field_151578_c);
        matNames.put((Object)"wood", (Object)Material.field_151575_d);
        matNames.put((Object)"rock", (Object)Material.field_151576_e);
        matNames.put((Object)"iron", (Object)Material.field_151573_f);
        matNames.put((Object)"anvil", (Object)Material.field_151574_g);
        matNames.put((Object)"water", (Object)Material.field_151586_h);
        matNames.put((Object)"lava", (Object)Material.field_151587_i);
        matNames.put((Object)"leaves", (Object)Material.field_151584_j);
        matNames.put((Object)"plants", (Object)Material.field_151585_k);
        matNames.put((Object)"vine", (Object)Material.field_151582_l);
        matNames.put((Object)"sponge", (Object)Material.field_151583_m);
        matNames.put((Object)"cloth", (Object)Material.field_151580_n);
        matNames.put((Object)"fire", (Object)Material.field_151581_o);
        matNames.put((Object)"sand", (Object)Material.field_151595_p);
        matNames.put((Object)"circuits", (Object)Material.field_151594_q);
        matNames.put((Object)"carpet", (Object)Material.field_151593_r);
        matNames.put((Object)"redstoneLight", (Object)Material.field_151591_t);
        matNames.put((Object)"tnt", (Object)Material.field_151590_u);
        matNames.put((Object)"coral", (Object)Material.field_151589_v);
        matNames.put((Object)"ice", (Object)Material.field_151588_w);
        matNames.put((Object)"packedIce", (Object)Material.field_151598_x);
        matNames.put((Object)"snow", (Object)Material.field_151597_y);
        matNames.put((Object)"craftedSnow", (Object)Material.field_151596_z);
        matNames.put((Object)"cactus", (Object)Material.field_151570_A);
        matNames.put((Object)"clay", (Object)Material.field_151571_B);
        matNames.put((Object)"gourd", (Object)Material.field_151572_C);
        matNames.put((Object)"dragonEgg", (Object)Material.field_151566_D);
        matNames.put((Object)"portal", (Object)Material.field_151567_E);
        matNames.put((Object)"cake", (Object)Material.field_151568_F);
        matNames.put((Object)"web", (Object)Material.field_151569_G);
    }

    public static class FalloutEntry {
        private Block matchesBlock = null;
        private int matchesMeta = -1;
        private Material matchesMaterial = null;
        private boolean matchesOpaque = false;
        private Tuple.Triplet<Block, Integer, Integer>[] primaryBlocks = null;
        private Tuple.Triplet<Block, Integer, Integer>[] secondaryBlocks = null;
        private double primaryChance = 1.0;
        private double minDist = 0.0;
        private double maxDist = 100.0;
        private boolean isSolid = false;

        public FalloutEntry clone() {
            FalloutEntry entry = new FalloutEntry();
            entry.mB(this.matchesBlock);
            entry.mM(this.matchesMeta);
            entry.mMa(this.matchesMaterial);
            entry.mO(this.matchesOpaque);
            entry.prim(this.primaryBlocks);
            entry.sec(this.secondaryBlocks);
            entry.min(this.minDist);
            entry.max(this.maxDist);
            entry.sol(this.isSolid);
            return entry;
        }

        public FalloutEntry mB(Block block) {
            this.matchesBlock = block;
            return this;
        }

        public FalloutEntry mM(int meta) {
            this.matchesMeta = meta;
            return this;
        }

        public FalloutEntry mMa(Material mat) {
            this.matchesMaterial = mat;
            return this;
        }

        public FalloutEntry mO(boolean opaque) {
            this.matchesOpaque = opaque;
            return this;
        }

        public FalloutEntry prim(Tuple.Triplet<Block, Integer, Integer> ... blocks) {
            this.primaryBlocks = blocks;
            return this;
        }

        public FalloutEntry sec(Tuple.Triplet<Block, Integer, Integer> ... blocks) {
            this.secondaryBlocks = blocks;
            return this;
        }

        public FalloutEntry c(double chance) {
            this.primaryChance = chance;
            return this;
        }

        public FalloutEntry min(double min) {
            this.minDist = min;
            return this;
        }

        public FalloutEntry max(double max) {
            this.maxDist = max;
            return this;
        }

        public FalloutEntry sol(boolean solid) {
            this.isSolid = solid;
            return this;
        }

        public boolean eval(World world, int x, int y, int z, Block b, int meta, double dist) {
            if (this.matchesBlock != null && b != this.matchesBlock) {
                return false;
            }
            if (this.matchesMaterial != null && b.func_149688_o() != this.matchesMaterial) {
                return false;
            }
            if (this.matchesMeta != -1 && meta != this.matchesMeta) {
                return false;
            }
            if (this.matchesOpaque && !b.func_149662_c()) {
                return false;
            }
            if (dist > this.maxDist || dist < this.minDist) {
                return false;
            }
            if (this.primaryChance == 1.0 || rand.nextDouble() < this.primaryChance) {
                if (this.primaryBlocks == null) {
                    return false;
                }
                RecipesCommon.MetaBlock block = this.chooseRandomOutcome(this.primaryBlocks);
                world.func_147465_d(x, y, z, block.block, block.meta, 3);
                return true;
            }
            if (this.secondaryBlocks == null) {
                return false;
            }
            RecipesCommon.MetaBlock block = this.chooseRandomOutcome(this.secondaryBlocks);
            world.func_147465_d(x, y, z, block.block, block.meta, 3);
            return true;
        }

        private RecipesCommon.MetaBlock chooseRandomOutcome(Tuple.Triplet<Block, Integer, Integer>[] blocks) {
            int weight = 0;
            for (Tuple.Triplet<Block, Integer, Integer> choice : blocks) {
                weight += choice.getZ().intValue();
            }
            int r = rand.nextInt(weight);
            for (Tuple.Triplet<Block, Integer, Integer> choice : blocks) {
                if ((r -= choice.getZ().intValue()) > 0) continue;
                return new RecipesCommon.MetaBlock(choice.getX(), choice.getY());
            }
            return new RecipesCommon.MetaBlock(blocks[0].getX(), blocks[0].getY());
        }

        public boolean isSolid() {
            return this.isSolid;
        }

        public void write(JsonWriter writer) throws IOException {
            String matName;
            if (this.matchesBlock != null) {
                writer.name("matchesBlock").value(Block.field_149771_c.func_148750_c((Object)this.matchesBlock));
            }
            if (this.matchesMeta != -1) {
                writer.name("matchesMeta").value((long)this.matchesMeta);
            }
            if (this.matchesOpaque) {
                writer.name("mustBeOpaque").value(true);
            }
            if (this.matchesMaterial != null && (matName = (String)matNames.inverse().get((Object)this.matchesMaterial)) != null) {
                writer.name("matchesMaterial").value(matName);
            }
            if (this.isSolid) {
                writer.name("restrictDepth").value(true);
            }
            if (this.primaryBlocks != null) {
                writer.name("primarySubstitution");
                FalloutEntry.writeMetaArray(writer, this.primaryBlocks);
            }
            if (this.secondaryBlocks != null) {
                writer.name("secondarySubstitutions");
                FalloutEntry.writeMetaArray(writer, this.secondaryBlocks);
            }
            if (this.primaryChance != 1.0) {
                writer.name("chance").value(this.primaryChance);
            }
            if (this.minDist != 0.0) {
                writer.name("minimumDistancePercent").value(this.minDist);
            }
            if (this.maxDist != 100.0) {
                writer.name("maximumDistancePercent").value(this.maxDist);
            }
        }

        private static FalloutEntry readEntry(JsonElement recipe) {
            FalloutEntry entry = new FalloutEntry();
            if (!recipe.isJsonObject()) {
                return null;
            }
            JsonObject obj = recipe.getAsJsonObject();
            if (obj.has("matchesBlock")) {
                entry.mB((Block)Block.field_149771_c.func_82594_a(obj.get("matchesBlock").getAsString()));
            }
            if (obj.has("matchesMeta")) {
                entry.mM(obj.get("matchesMeta").getAsInt());
            }
            if (obj.has("mustBeOpaque")) {
                entry.mO(obj.get("mustBeOpaque").getAsBoolean());
            }
            if (obj.has("matchesMaterial")) {
                entry.mMa((Material)matNames.get((Object)obj.get("mustBeOpaque").getAsString()));
            }
            if (obj.has("restrictDepth")) {
                entry.sol(obj.get("restrictDepth").getAsBoolean());
            }
            if (obj.has("primarySubstitution")) {
                entry.prim(FalloutEntry.readMetaArray(obj.get("primarySubstitution")));
            }
            if (obj.has("secondarySubstitutions")) {
                entry.sec(FalloutEntry.readMetaArray(obj.get("secondarySubstitutions")));
            }
            if (obj.has("chance")) {
                entry.c(obj.get("chance").getAsDouble());
            }
            if (obj.has("minimumDistancePercent")) {
                entry.min(obj.get("minimumDistancePercent").getAsDouble());
            }
            if (obj.has("maximumDistancePercent")) {
                entry.max(obj.get("maximumDistancePercent").getAsDouble());
            }
            return entry;
        }

        private static void writeMetaArray(JsonWriter writer, Tuple.Triplet<Block, Integer, Integer>[] array) throws IOException {
            writer.beginArray();
            writer.setIndent("");
            for (Tuple.Triplet<Block, Integer, Integer> meta : array) {
                writer.beginArray();
                writer.value(Block.field_149771_c.func_148750_c((Object)meta.getX()));
                writer.value((Number)meta.getY());
                writer.value((Number)meta.getZ());
                writer.endArray();
            }
            writer.endArray();
            writer.setIndent("  ");
        }

        private static Tuple.Triplet<Block, Integer, Integer>[] readMetaArray(JsonElement jsonElement) {
            if (!jsonElement.isJsonArray()) {
                return null;
            }
            JsonArray array = jsonElement.getAsJsonArray();
            Tuple.Triplet[] metaArray = new Tuple.Triplet[array.size()];
            for (int i = 0; i < metaArray.length; ++i) {
                JsonElement metaBlock = array.get(i);
                if (!metaBlock.isJsonArray()) {
                    throw new IllegalStateException("Could not read meta block " + metaBlock.toString());
                }
                JsonArray mBArray = metaBlock.getAsJsonArray();
                metaArray[i] = new Tuple.Triplet<Object, Integer, Integer>(Block.field_149771_c.func_82594_a(mBArray.get(0).getAsString()), mBArray.get(1).getAsInt(), mBArray.get(2).getAsInt());
            }
            return metaArray;
        }
    }
}

