/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.rail;

import com.hbm.blocks.BlockDummyable;
import com.hbm.blocks.rail.IRailNTM;
import com.hbm.lib.Library;
import com.hbm.util.fauxpointtwelve.BlockPos;
import cpw.mods.fml.client.registry.RenderingRegistry;
import net.minecraft.block.material.Material;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class RailStandardStraight
extends BlockDummyable
implements IRailNTM {
    public static int renderID = RenderingRegistry.getNextAvailableRenderId();

    public RailStandardStraight() {
        super(Material.field_151573_f);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return null;
    }

    @Override
    public int func_149645_b() {
        return renderID;
    }

    @Override
    public int[] getDimensions() {
        return new int[]{0, 0, 2, 2, 1, 0};
    }

    @Override
    public int getOffset() {
        return 2;
    }

    @Override
    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
        return AxisAlignedBB.func_72330_a((double)((double)x + this.field_149759_B), (double)((double)y + this.field_149760_C), (double)((double)z + this.field_149754_D), (double)((double)x + this.field_149755_E), (double)((double)y + this.field_149756_F), (double)((double)z + this.field_149757_G));
    }

    @Override
    public Vec3 getSnappingPos(World world, int x, int y, int z, double trainX, double trainY, double trainZ) {
        return this.snapAndMove(world, x, y, z, trainX, trainY, trainZ, 0.0, 0.0, 0.0, 0.0, new IRailNTM.RailContext());
    }

    @Override
    public Vec3 getTravelLocation(World world, int x, int y, int z, double trainX, double trainY, double trainZ, double motionX, double motionY, double motionZ, double speed, IRailNTM.RailContext info, IRailNTM.MoveContext context) {
        return this.snapAndMove(world, x, y, z, trainX, trainY, trainZ, motionX, motionY, motionZ, speed, info);
    }

    public Vec3 snapAndMove(World world, int x, int y, int z, double trainX, double trainY, double trainZ, double motionX, double motionY, double motionZ, double speed, IRailNTM.RailContext info) {
        int[] pos = this.findCore(world, x, y, z);
        if (pos == null) {
            return Vec3.func_72443_a((double)trainX, (double)trainY, (double)trainZ);
        }
        int cX = pos[0];
        int cY = pos[1];
        int cZ = pos[2];
        int meta = world.func_72805_g(cX, cY, cZ) - 10;
        ForgeDirection dir = ForgeDirection.getOrientation((int)meta);
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        Vec3 vec = Vec3.func_72443_a((double)trainX, (double)trainY, (double)trainZ);
        if (speed == 0.0) {
            // empty if block
        }
        if (dir == Library.POS_X || dir == Library.NEG_X) {
            double targetX = trainX;
            if (motionX > 0.0) {
                targetX += speed;
                info.yaw(-90.0f);
            } else {
                targetX -= speed;
                info.yaw(90.0f);
            }
            vec.field_72450_a = MathHelper.func_151237_a((double)targetX, (double)(cX - 2), (double)(cX + 3));
            vec.field_72448_b = (double)y + 0.1875;
            vec.field_72449_c = (double)cZ + 0.5 + (double)rot.offsetZ * 0.5;
            info.dist(Math.abs(targetX - vec.field_72450_a) * Math.signum(speed));
            info.pos(new BlockPos(cX + (motionX * speed > 0.0 ? 3 : -3), y, cZ));
        } else {
            double targetZ = trainZ;
            if (motionZ > 0.0) {
                targetZ += speed;
                info.yaw(0.0f);
            } else {
                targetZ -= speed;
                info.yaw(180.0f);
            }
            vec.field_72450_a = (double)cX + 0.5 + (double)rot.offsetX * 0.5;
            vec.field_72448_b = (double)y + 0.1875;
            vec.field_72449_c = MathHelper.func_151237_a((double)targetZ, (double)(cZ - 2), (double)(cZ + 3));
            info.dist(Math.abs(targetZ - vec.field_72449_c) * Math.signum(speed));
            info.pos(new BlockPos(cX, y, cZ + (motionZ * speed > 0.0 ? 3 : -3)));
        }
        return vec;
    }

    @Override
    public IRailNTM.TrackGauge getGauge(World world, int x, int y, int z) {
        return IRailNTM.TrackGauge.STANDARD;
    }
}

