/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.rail;

import com.hbm.blocks.BlockDummyable;
import com.hbm.blocks.rail.IRailNTM;
import com.hbm.lib.Library;
import com.hbm.util.fauxpointtwelve.BlockPos;
import cpw.mods.fml.client.registry.RenderingRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class RailStandardCurve
extends BlockDummyable
implements IRailNTM {
    public static int renderID = RenderingRegistry.getNextAvailableRenderId();

    public RailStandardCurve() {
        super(Material.field_151573_f);
    }

    public TileEntity func_149915_a(World p_149915_1_, int p_149915_2_) {
        return null;
    }

    @Override
    public int func_149645_b() {
        return renderID;
    }

    @Override
    public Vec3 getSnappingPos(World world, int x, int y, int z, double trainX, double trainY, double trainZ) {
        return this.snapAndMove(world, x, y, z, trainX, trainY, trainZ, 0.0, 0.0, 0.0, 0.0, new IRailNTM.RailContext());
    }

    @Override
    public Vec3 getTravelLocation(World world, int x, int y, int z, double trainX, double trainY, double trainZ, double motionX, double motionY, double motionZ, double speed, IRailNTM.RailContext info, IRailNTM.MoveContext context) {
        return this.snapAndMove(world, x, y, z, trainX, trainY, trainZ, motionX, motionY, motionZ, speed, info);
    }

    public Vec3 snapAndMove(World world, int x, int y, int z, double trainX, double trainY, double trainZ, double motionX, double motionY, double motionZ, double speed, IRailNTM.RailContext info) {
        int[] pos = this.findCore(world, x, y, z);
        if (pos == null) {
            return Vec3.func_72443_a((double)trainX, (double)trainY, (double)trainZ);
        }
        int cX = pos[0];
        int cY = pos[1];
        int cZ = pos[2];
        int meta = world.func_72805_g(cX, cY, cZ) - 10;
        ForgeDirection dir = ForgeDirection.getOrientation((int)meta);
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        double turnRadius = 4.0;
        double axisDist = 4.5;
        Vec3 vec = Vec3.func_72443_a((double)trainX, (double)trainY, (double)trainZ);
        double axisX = (double)cX + 0.5 + (double)dir.offsetX * 0.5 + (double)rot.offsetX * axisDist;
        double axisZ = (double)cZ + 0.5 + (double)dir.offsetZ * 0.5 + (double)rot.offsetZ * axisDist;
        Vec3 dist = Vec3.func_72443_a((double)(vec.field_72450_a - axisX), (double)0.0, (double)(vec.field_72449_c - axisZ));
        dist = dist.func_72432_b();
        dist.field_72450_a *= turnRadius;
        dist.field_72449_c *= turnRadius;
        double moveAngle = Math.atan2(motionX, motionZ) * 180.0 / Math.PI + 90.0;
        if (speed == 0.0) {
            info.dist(0.0).pos(new BlockPos(x, y, z)).yaw((float)moveAngle);
            return Vec3.func_72443_a((double)(axisX + dist.field_72450_a), (double)y, (double)(axisZ + dist.field_72449_c));
        }
        double angleDeg = Math.atan2(dist.field_72450_a, dist.field_72449_c) * 180.0 / Math.PI + 90.0;
        if (dir == Library.NEG_X) {
            angleDeg -= 90.0;
        }
        if (dir == Library.POS_X) {
            angleDeg += 90.0;
        }
        if (dir == Library.POS_Z) {
            angleDeg += 180.0;
        }
        angleDeg = MathHelper.func_76138_g((double)angleDeg);
        double length90Deg = turnRadius * Math.PI / 2.0;
        double angularChange = speed / length90Deg * 90.0;
        ForgeDirection moveDir = ForgeDirection.UNKNOWN;
        if (Math.abs(motionX) > Math.abs(motionZ)) {
            moveDir = motionX > 0.0 ? Library.POS_X : Library.NEG_X;
        } else {
            ForgeDirection forgeDirection = moveDir = motionZ > 0.0 ? Library.POS_Z : Library.NEG_Z;
        }
        if (moveDir == dir || moveDir == rot.getOpposite()) {
            angularChange *= -1.0;
        }
        double effAngle = angleDeg + angularChange;
        moveAngle += angularChange;
        if (effAngle > 90.0) {
            double angleOvershoot = effAngle - 90.0;
            double lengthOvershoot = angleOvershoot * length90Deg / 90.0;
            info.dist(lengthOvershoot * Math.signum(speed * angularChange)).pos(new BlockPos(cX - dir.offsetX * 4 + rot.offsetX * 5, y, cZ - dir.offsetZ * 4 + rot.offsetZ * 5)).yaw((float)(moveAngle -= angleOvershoot));
            return Vec3.func_72443_a((double)(axisX - (double)dir.offsetX * turnRadius), (double)((double)y + 0.1875), (double)(axisZ - (double)dir.offsetZ * turnRadius));
        }
        if (effAngle < 0.0) {
            double angleOvershoot = -effAngle;
            double lengthOvershoot = angleOvershoot * length90Deg / 90.0;
            info.dist(-lengthOvershoot * Math.signum(speed * angularChange)).pos(new BlockPos(cX + dir.offsetX, y, cZ + dir.offsetZ)).yaw((float)(moveAngle -= angleOvershoot));
            return Vec3.func_72443_a((double)(axisX - (double)rot.offsetX * turnRadius), (double)((double)y + 0.1875), (double)(axisZ - (double)rot.offsetZ * turnRadius));
        }
        double radianChange = angularChange * Math.PI / 180.0;
        dist.func_72442_b((float)radianChange);
        return Vec3.func_72443_a((double)(axisX + dist.field_72450_a), (double)((double)y + 0.1875), (double)(axisZ + dist.field_72449_c));
    }

    @Override
    public IRailNTM.TrackGauge getGauge(World world, int x, int y, int z) {
        return IRailNTM.TrackGauge.STANDARD;
    }

    @Override
    public int[] getDimensions() {
        return new int[]{0, 0, 4, 0, 4, 0};
    }

    @Override
    public int getOffset() {
        return 0;
    }

    @Override
    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
        return AxisAlignedBB.func_72330_a((double)((double)x + this.field_149759_B), (double)((double)y + this.field_149760_C), (double)((double)z + this.field_149754_D), (double)((double)x + this.field_149755_E), (double)((double)y + this.field_149756_F), (double)((double)z + this.field_149757_G));
    }

    @Override
    protected boolean checkRequirement(World world, int x, int y, int z, ForgeDirection dir, int o) {
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        dir = dir.getOpposite();
        int dX = dir.offsetX;
        int dZ = dir.offsetZ;
        int rX = rot.offsetX;
        int rZ = rot.offsetZ;
        return world.func_147439_a(x + dX, y, z + dZ).isReplaceable((IBlockAccess)world, x + dX, y, z + dZ) && world.func_147439_a(x + rX, y, z + rZ).isReplaceable((IBlockAccess)world, x + rX, y, z + rZ) && world.func_147439_a(x + dX + rX, y, z + dZ + rZ).isReplaceable((IBlockAccess)world, x + dX + rX, y, z + dZ + rZ) && world.func_147439_a(x + dX + rX * 2, y, z + dZ + rZ * 2).isReplaceable((IBlockAccess)world, x + dX + rX * 2, y, z + dZ + rZ * 2) && world.func_147439_a(x + dX * 2 + rX, y, z + dZ * 2 + rZ).isReplaceable((IBlockAccess)world, x + dX * 2 + rX, y, z + dZ * 2 + rZ) && world.func_147439_a(x + dX * 2 + rX * 2, y, z + dZ * 2 + rZ * 2).isReplaceable((IBlockAccess)world, x + dX * 2 + rX * 2, y, z + dZ * 2 + rZ * 2) && world.func_147439_a(x + dX * 3 + rX, y, z + dZ * 3 + rZ).isReplaceable((IBlockAccess)world, x + dX * 3 + rX, y, z + dZ * 3 + rZ) && world.func_147439_a(x + dX * 3 + rX * 2, y, z + dZ * 3 + rZ * 2).isReplaceable((IBlockAccess)world, x + dX * 3 + rX * 2, y, z + dZ * 3 + rZ * 2) && world.func_147439_a(x + dX * 2 + rX * 3, y, z + dZ * 2 + rZ * 3).isReplaceable((IBlockAccess)world, x + dX * 2 + rX * 3, y, z + dZ * 2 + rZ * 3) && world.func_147439_a(x + dX * 3 + rX * 3, y, z + dZ * 3 + rZ * 3).isReplaceable((IBlockAccess)world, x + dX * 3 + rX * 3, y, z + dZ * 3 + rZ * 3) && world.func_147439_a(x + dX * 4 + rX * 3, y, z + dZ * 4 + rZ * 3).isReplaceable((IBlockAccess)world, x + dX * 4 + rX * 3, y, z + dZ * 4 + rZ * 3) && world.func_147439_a(x + dX * 3 + rX * 4, y, z + dZ * 3 + rZ * 4).isReplaceable((IBlockAccess)world, x + dX * 3 + rX * 4, y, z + dZ * 3 + rZ * 4) && world.func_147439_a(x + dX * 4 + rX * 4, y, z + dZ * 4 + rZ * 4).isReplaceable((IBlockAccess)world, x + dX * 4 + rX * 4, y, z + dZ * 4 + rZ * 4);
    }

    @Override
    protected void fillSpace(World world, int x, int y, int z, ForgeDirection dir, int o) {
        BlockDummyable.safeRem = true;
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        dir = dir.getOpposite();
        int dX = dir.offsetX;
        int dZ = dir.offsetZ;
        int rX = rot.offsetX;
        int rZ = rot.offsetZ;
        world.func_147465_d(x + dX, y, z + dZ, (Block)this, dir.ordinal(), 3);
        world.func_147465_d(x + rX, y, z + rZ, (Block)this, rot.ordinal(), 3);
        world.func_147465_d(x + dX + rX, y, z + dZ + rZ, (Block)this, rot.ordinal(), 3);
        world.func_147465_d(x + dX + rX * 2, y, z + dZ + rZ * 2, (Block)this, rot.ordinal(), 3);
        world.func_147465_d(x + dX * 2 + rX, y, z + dZ * 2 + rZ, (Block)this, dir.ordinal(), 3);
        world.func_147465_d(x + dX * 2 + rX * 2, y, z + dZ * 2 + rZ * 2, (Block)this, dir.ordinal(), 3);
        world.func_147465_d(x + dX * 3 + rX, y, z + dZ * 3 + rZ, (Block)this, dir.ordinal(), 3);
        world.func_147465_d(x + dX * 3 + rX * 2, y, z + dZ * 3 + rZ * 2, (Block)this, dir.ordinal(), 3);
        world.func_147465_d(x + dX * 2 + rX * 3, y, z + dZ * 2 + rZ * 3, (Block)this, rot.ordinal(), 3);
        world.func_147465_d(x + dX * 3 + rX * 3, y, z + dZ * 3 + rZ * 3, (Block)this, rot.ordinal(), 3);
        world.func_147465_d(x + dX * 4 + rX * 3, y, z + dZ * 4 + rZ * 3, (Block)this, dir.ordinal(), 3);
        world.func_147465_d(x + dX * 3 + rX * 4, y, z + dZ * 3 + rZ * 4, (Block)this, rot.ordinal(), 3);
        world.func_147465_d(x + dX * 4 + rX * 4, y, z + dZ * 4 + rZ * 4, (Block)this, rot.ordinal(), 3);
        BlockDummyable.safeRem = false;
    }
}

