/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.network;

import api.hbm.fluid.IPipeNet;
import com.hbm.blocks.IBlockMultiPass;
import com.hbm.blocks.ILookOverlay;
import com.hbm.blocks.ITooltipProvider;
import com.hbm.blocks.network.FluidDuctBase;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.render.block.RenderBlockMultipass;
import com.hbm.tileentity.INBTPacketReceiver;
import com.hbm.tileentity.network.TileEntityPipeBaseNT;
import com.hbm.util.I18nUtil;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;

public class FluidDuctGauge
extends FluidDuctBase
implements IBlockMultiPass,
ILookOverlay,
ITooltipProvider {
    @SideOnly(value=Side.CLIENT)
    protected IIcon overlay;
    @SideOnly(value=Side.CLIENT)
    protected IIcon overlayGauge;

    public FluidDuctGauge() {
        super(Material.field_151573_f);
    }

    @Override
    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityPipeGauge();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        this.field_149761_L = reg.func_94245_a("hbm:deco_steel");
        this.overlay = reg.func_94245_a("hbm:fluid_duct_paintable_overlay");
        this.overlayGauge = reg.func_94245_a("hbm:pipe_gauge");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        if (RenderBlockMultipass.currentPass == 0) {
            return this.field_149761_L;
        }
        return side == world.func_72805_g(x, y, z) ? this.overlayGauge : this.overlay;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack stack) {
        int l = BlockPistonBase.func_150071_a((World)world, (int)x, (int)y, (int)z, (EntityLivingBase)player);
        world.func_72921_c(x, y, z, l, 2);
    }

    @Override
    public int getPasses() {
        return 2;
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean ext) {
        this.addStandardInfo(stack, player, list, ext);
    }

    @Override
    public void printHook(RenderGameOverlayEvent.Pre event, World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof TileEntityPipeBaseNT)) {
            return;
        }
        TileEntityPipeGauge duct = (TileEntityPipeGauge)te;
        ArrayList<String> text = new ArrayList<String>();
        text.add("&[" + duct.getType().getColor() + "&]" + I18nUtil.resolveKey(duct.getType().getUnlocalizedName(), new Object[0]));
        text.add(String.format("%,d", duct.deltaTick) + " mB/t");
        text.add(String.format("%,d", duct.deltaLastSecond) + " mB/s");
        ILookOverlay.printGeneric(event, I18nUtil.resolveKey(this.func_149739_a() + ".name", new Object[0]), 0xFFFF00, 0x404000, text);
    }

    public int func_149645_b() {
        return IBlockMultiPass.getRenderType();
    }

    @Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="OpenComputers")})
    public static class TileEntityPipeGauge
    extends TileEntityPipeBaseNT
    implements INBTPacketReceiver,
    SimpleComponent {
        private BigInteger lastMeasurement = BigInteger.valueOf(10L);
        private long deltaTick = 0L;
        private long deltaSecond = 0L;
        private long deltaLastSecond = 0L;

        @Override
        public void func_145845_h() {
            super.func_145845_h();
            if (!this.field_145850_b.field_72995_K) {
                IPipeNet net = this.getPipeNet(this.getType());
                if (net != null && this.getType() != Fluids.NONE) {
                    BigInteger total = net.getTotalTransfer();
                    BigInteger delta = total.subtract(this.lastMeasurement);
                    this.lastMeasurement = total;
                    try {
                        this.deltaTick = delta.longValueExact();
                        if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                            this.deltaLastSecond = this.deltaSecond;
                            this.deltaSecond = 0L;
                        }
                        this.deltaSecond += this.deltaTick;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                NBTTagCompound data = new NBTTagCompound();
                data.func_74772_a("deltaT", this.deltaTick);
                data.func_74772_a("deltaS", this.deltaLastSecond);
                INBTPacketReceiver.networkPack(this, data, 25);
            }
        }

        @Override
        public void networkUnpack(NBTTagCompound nbt) {
            this.deltaTick = Math.max(nbt.func_74763_f("deltaT"), 0L);
            this.deltaLastSecond = Math.max(nbt.func_74763_f("deltaS"), 0L);
        }

        public String getComponentName() {
            return "ntm_fluid_gauge";
        }

        @Callback(direct=true, limit=8)
        @Optional.Method(modid="OpenComputers")
        public Object[] getTransfer(Context context, Arguments args) {
            return new Object[]{this.deltaTick, this.deltaSecond};
        }

        @Callback(direct=true, limit=8)
        @Optional.Method(modid="OpenComputers")
        public Object[] getFluid(Context context, Arguments args) {
            return new Object[]{this.getType().getName()};
        }

        @Callback(direct=true, limit=8)
        @Optional.Method(modid="OpenComputers")
        public Object[] getInfo(Context context, Arguments args) {
            return new Object[]{this.deltaTick, this.deltaSecond, this.getType().getName(), this.field_145851_c, this.field_145848_d, this.field_145849_e};
        }
    }
}

