/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.network;

import api.hbm.fluid.IPipeNet;
import api.hbm.fluid.PipeNet;
import com.hbm.blocks.IAnalyzable;
import com.hbm.blocks.network.IBlockFluidDuct;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.items.machine.IItemFluidIdentifier;
import com.hbm.tileentity.network.TileEntityPipeBaseNT;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class FluidDuctBase
extends BlockContainer
implements IBlockFluidDuct,
IAnalyzable {
    public FluidDuctBase(Material mat) {
        super(mat);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityPipeBaseNT();
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float fX, float fY, float fZ) {
        if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() instanceof IItemFluidIdentifier) {
            IItemFluidIdentifier id = (IItemFluidIdentifier)player.func_70694_bm().func_77973_b();
            FluidType type = id.getType(world, x, y, z, player.func_70694_bm());
            if (!player.func_70093_af()) {
                TileEntityPipeBaseNT pipe;
                TileEntity te = world.func_147438_o(x, y, z);
                if (te instanceof TileEntityPipeBaseNT && (pipe = (TileEntityPipeBaseNT)te).getType() != type) {
                    pipe.setType(type);
                    return true;
                }
            } else {
                TileEntity te = world.func_147438_o(x, y, z);
                if (te instanceof TileEntityPipeBaseNT) {
                    TileEntityPipeBaseNT pipe = (TileEntityPipeBaseNT)te;
                    this.changeTypeRecursively(world, x, y, z, pipe.getType(), type, 64);
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void changeTypeRecursively(World world, int x, int y, int z, FluidType prevType, FluidType type, int loopsRemaining) {
        TileEntityPipeBaseNT pipe;
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityPipeBaseNT && (pipe = (TileEntityPipeBaseNT)te).getType() == prevType && pipe.getType() != type) {
            pipe.setType(type);
            if (loopsRemaining > 0) {
                for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                    Block b = world.func_147439_a(x, y, z);
                    if (!(b instanceof IBlockFluidDuct)) continue;
                    ((IBlockFluidDuct)b).changeTypeRecursively(world, x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ, prevType, type, loopsRemaining - 1);
                }
            }
        }
    }

    @Override
    public List<String> getDebugInfo(World world, int x, int y, int z) {
        IPipeNet net;
        TileEntityPipeBaseNT pipe;
        FluidType type;
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityPipeBaseNT && (type = (pipe = (TileEntityPipeBaseNT)te).getType()) != null && (net = pipe.getPipeNet(type)) instanceof PipeNet) {
            PipeNet pipeNet = (PipeNet)net;
            ArrayList<String> debug = new ArrayList<String>();
            debug.add("=== DEBUG START ===");
            debug.addAll(pipeNet.debug);
            debug.add("=== DEBUG END ===");
            debug.add("Links: " + pipeNet.getLinks().size());
            debug.add("Subscribers: " + pipeNet.getSubscribers().size());
            debug.add("Transfer: " + pipeNet.getTotalTransfer());
            return debug;
        }
        return null;
    }
}

