/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.network;

import api.hbm.conveyor.IConveyorBelt;
import api.hbm.conveyor.IConveyorItem;
import api.hbm.conveyor.IConveyorPackage;
import api.hbm.conveyor.IEnterableBlock;
import com.hbm.blocks.BlockDummyable;
import com.hbm.blocks.ITooltipProvider;
import com.hbm.entity.item.EntityMovingItem;
import com.hbm.tileentity.network.TileEntityCraneSplitter;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class CraneSplitter
extends BlockDummyable
implements IConveyorBelt,
IEnterableBlock,
ITooltipProvider {
    @SideOnly(value=Side.CLIENT)
    public IIcon iconTopLeft;
    @SideOnly(value=Side.CLIENT)
    public IIcon iconTopRight;
    @SideOnly(value=Side.CLIENT)
    public IIcon iconFrontLeft;
    @SideOnly(value=Side.CLIENT)
    public IIcon iconFrontRight;
    @SideOnly(value=Side.CLIENT)
    public IIcon iconBackLeft;
    @SideOnly(value=Side.CLIENT)
    public IIcon iconBackRight;
    @SideOnly(value=Side.CLIENT)
    public IIcon iconLeft;
    @SideOnly(value=Side.CLIENT)
    public IIcon iconRight;
    @SideOnly(value=Side.CLIENT)
    public IIcon iconBelt;
    @SideOnly(value=Side.CLIENT)
    public IIcon iconInner;
    @SideOnly(value=Side.CLIENT)
    public IIcon iconInnerSide;
    public static int renderID = RenderingRegistry.getNextAvailableRenderId();

    public CraneSplitter() {
        super(Material.field_151573_f);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityCraneSplitter();
    }

    @Override
    public int[] getDimensions() {
        return new int[]{0, 0, 0, 0, 0, 1};
    }

    @Override
    public int getOffset() {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        super.func_149651_a(iconRegister);
        this.iconTopLeft = iconRegister.func_94245_a("hbm:crane_splitter_top_left");
        this.iconTopRight = iconRegister.func_94245_a("hbm:crane_splitter_top_right");
        this.iconFrontLeft = iconRegister.func_94245_a("hbm:crane_splitter_front_left");
        this.iconFrontRight = iconRegister.func_94245_a("hbm:crane_splitter_front_right");
        this.iconBackLeft = iconRegister.func_94245_a("hbm:crane_splitter_back_left");
        this.iconBackRight = iconRegister.func_94245_a("hbm:crane_splitter_back_right");
        this.iconLeft = iconRegister.func_94245_a("hbm:crane_splitter_left");
        this.iconRight = iconRegister.func_94245_a("hbm:crane_splitter_right");
        this.iconBelt = iconRegister.func_94245_a("hbm:crane_splitter_belt");
        this.iconInner = iconRegister.func_94245_a("hbm:crane_splitter_inner");
        this.iconInnerSide = iconRegister.func_94245_a("hbm:crane_splitter_inner_side");
    }

    @Override
    public int func_149645_b() {
        return renderID;
    }

    @Override
    public boolean canItemEnter(World world, int x, int y, int z, ForgeDirection dir, IConveyorItem entity) {
        return this.getTravelDirection(world, x, y, z, null) == dir;
    }

    @Override
    public boolean canPackageEnter(World world, int x, int y, int z, ForgeDirection dir, IConveyorPackage entity) {
        return false;
    }

    @Override
    public void onPackageEnter(World world, int x, int y, int z, ForgeDirection dir, IConveyorPackage entity) {
    }

    @Override
    public void onItemEnter(World world, int x, int y, int z, ForgeDirection dir, IConveyorItem entity) {
        int[] core = this.findCore(world, x, y, z);
        if (core == null) {
            return;
        }
        x = core[0];
        y = core[1];
        z = core[2];
        TileEntity tile = world.func_147438_o(x, y, z);
        if (!(tile instanceof TileEntityCraneSplitter)) {
            return;
        }
        TileEntityCraneSplitter splitter = (TileEntityCraneSplitter)tile;
        boolean pos = splitter.getPosition();
        ItemStack stack = entity.getItemStack();
        ForgeDirection rot = ForgeDirection.getOrientation((int)(splitter.func_145832_p() - 10)).getRotation(ForgeDirection.DOWN);
        if (stack.field_77994_a % 2 == 0) {
            stack.field_77994_a /= 2;
            this.spawnMovingItem(world, x, y, z, stack.func_77946_l());
            this.spawnMovingItem(world, x + rot.offsetX, y, z + rot.offsetZ, stack.func_77946_l());
        } else {
            int baseSize = stack.field_77994_a /= 2;
            stack.field_77994_a = baseSize + (pos ? 0 : 1);
            this.spawnMovingItem(world, x, y, z, stack.func_77946_l());
            stack.field_77994_a = baseSize + (pos ? 1 : 0);
            this.spawnMovingItem(world, x + rot.offsetX, y, z + rot.offsetZ, stack.func_77946_l());
            splitter.setPosition(!pos);
        }
    }

    private void spawnMovingItem(World world, int x, int y, int z, ItemStack stack) {
        if (stack.field_77994_a <= 0) {
            return;
        }
        EntityMovingItem moving = new EntityMovingItem(world);
        Vec3 pos = Vec3.func_72443_a((double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5));
        Vec3 snap = this.getClosestSnappingPosition(world, x, y, z, pos);
        moving.func_70107_b(snap.field_72450_a, snap.field_72448_b, snap.field_72449_c);
        moving.setItemStack(stack);
        world.func_72838_d((Entity)moving);
    }

    @Override
    public boolean canItemStay(World world, int x, int y, int z, Vec3 itemPos) {
        return true;
    }

    @Override
    public Vec3 getTravelLocation(World world, int x, int y, int z, Vec3 itemPos, double speed) {
        ForgeDirection dir = this.getTravelDirection(world, x, y, z, itemPos);
        Vec3 snap = this.getClosestSnappingPosition(world, x, y, z, itemPos);
        Vec3 dest = Vec3.func_72443_a((double)(snap.field_72450_a - (double)dir.offsetX * speed), (double)(snap.field_72448_b - (double)dir.offsetY * speed), (double)(snap.field_72449_c - (double)dir.offsetZ * speed));
        Vec3 motion = Vec3.func_72443_a((double)(dest.field_72450_a - itemPos.field_72450_a), (double)(dest.field_72448_b - itemPos.field_72448_b), (double)(dest.field_72449_c - itemPos.field_72449_c));
        double len = motion.func_72433_c();
        Vec3 ret = Vec3.func_72443_a((double)(itemPos.field_72450_a + motion.field_72450_a / len * speed), (double)(itemPos.field_72448_b + motion.field_72448_b / len * speed), (double)(itemPos.field_72449_c + motion.field_72449_c / len * speed));
        return ret;
    }

    @Override
    public Vec3 getClosestSnappingPosition(World world, int x, int y, int z, Vec3 itemPos) {
        ForgeDirection dir = this.getTravelDirection(world, x, y, z, itemPos);
        itemPos.field_72450_a = MathHelper.func_151237_a((double)itemPos.field_72450_a, (double)x, (double)(x + 1));
        itemPos.field_72449_c = MathHelper.func_151237_a((double)itemPos.field_72449_c, (double)z, (double)(z + 1));
        double posX = (double)x + 0.5;
        double posZ = (double)z + 0.5;
        if (dir.offsetX != 0) {
            posX = itemPos.field_72450_a;
        }
        if (dir.offsetZ != 0) {
            posZ = itemPos.field_72449_c;
        }
        return Vec3.func_72443_a((double)posX, (double)((double)y + 0.25), (double)posZ);
    }

    public ForgeDirection getTravelDirection(World world, int x, int y, int z, Vec3 itemPos) {
        int meta = world.func_72805_g(x, y, z);
        if (meta >= 12) {
            return ForgeDirection.getOrientation((int)(meta - 10));
        }
        return ForgeDirection.getOrientation((int)meta).getRotation(ForgeDirection.UP);
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean ext) {
        this.addStandardInfo(stack, player, list, ext);
    }
}

