/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.network;

import api.hbm.conveyor.IConveyorItem;
import api.hbm.conveyor.IConveyorPackage;
import api.hbm.conveyor.IEnterableBlock;
import com.hbm.blocks.network.BlockCraneBase;
import com.hbm.tileentity.network.TileEntityCraneBase;
import com.hbm.tileentity.network.TileEntityCraneInserter;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class CraneInserter
extends BlockCraneBase
implements IEnterableBlock {
    public CraneInserter() {
        super(Material.field_151573_f);
    }

    @Override
    public TileEntityCraneBase createNewTileEntity(World world, int meta) {
        return new TileEntityCraneInserter();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        super.func_149651_a(iconRegister);
        this.iconDirectional = iconRegister.func_94245_a("hbm:crane_in_top");
        this.iconDirectionalUp = iconRegister.func_94245_a("hbm:crane_in_side_up");
        this.iconDirectionalDown = iconRegister.func_94245_a("hbm:crane_in_side_down");
        this.iconDirectionalTurnLeft = iconRegister.func_94245_a("hbm:crane_in_top_left");
        this.iconDirectionalTurnRight = iconRegister.func_94245_a("hbm:crane_in_top_right");
        this.iconDirectionalSideLeftTurnUp = iconRegister.func_94245_a("hbm:crane_in_side_left_turn_up");
        this.iconDirectionalSideRightTurnUp = iconRegister.func_94245_a("hbm:crane_in_side_right_turn_up");
        this.iconDirectionalSideLeftTurnDown = iconRegister.func_94245_a("hbm:crane_in_side_left_turn_down");
        this.iconDirectionalSideRightTurnDown = iconRegister.func_94245_a("hbm:crane_in_side_right_turn_down");
        this.iconDirectionalSideUpTurnLeft = iconRegister.func_94245_a("hbm:crane_in_side_up_turn_left");
        this.iconDirectionalSideUpTurnRight = iconRegister.func_94245_a("hbm:crane_in_side_up_turn_right");
        this.iconDirectionalSideDownTurnLeft = iconRegister.func_94245_a("hbm:crane_in_side_down_turn_left");
        this.iconDirectionalSideDownTurnRight = iconRegister.func_94245_a("hbm:crane_in_side_down_turn_right");
    }

    @Override
    public boolean canItemEnter(World world, int x, int y, int z, ForgeDirection dir, IConveyorItem entity) {
        ForgeDirection orientation = ForgeDirection.getOrientation((int)world.func_72805_g(x, y, z));
        return orientation == dir;
    }

    @Override
    public void onItemEnter(World world, int x, int y, int z, ForgeDirection dir, IConveyorItem entity) {
        ForgeDirection outputDirection = this.getOutputSide((IBlockAccess)world, x, y, z);
        TileEntity te = world.func_147438_o(x + outputDirection.offsetX, y + outputDirection.offsetY, z + outputDirection.offsetZ);
        if (entity == null || entity.getItemStack() == null || entity.getItemStack().field_77994_a <= 0) {
            return;
        }
        ItemStack toAdd = entity.getItemStack().func_77946_l();
        int[] access = null;
        if (te instanceof ISidedInventory) {
            ISidedInventory sided = (ISidedInventory)te;
            access = CraneInserter.masquerade(sided, outputDirection.getOpposite().ordinal());
        }
        if (te instanceof IInventory) {
            IInventory inv = (IInventory)te;
            CraneInserter.addToInventory(inv, access, toAdd, outputDirection.getOpposite().ordinal());
        }
        if (toAdd.field_77994_a > 0) {
            CraneInserter.addToInventory((IInventory)((TileEntityCraneInserter)world.func_147438_o(x, y, z)), null, toAdd, outputDirection.getOpposite().ordinal());
        }
        if (toAdd.field_77994_a > 0) {
            EntityItem drop = new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, toAdd.func_77946_l());
            world.func_72838_d((Entity)drop);
        }
    }

    public static int[] masquerade(ISidedInventory sided, int side) {
        if (sided instanceof TileEntityFurnace) {
            return new int[]{1, 0};
        }
        return sided.func_94128_d(side);
    }

    public static ItemStack addToInventory(IInventory inv, int[] access, ItemStack toAdd, int side) {
        ItemStack stack;
        int index;
        int i;
        ISidedInventory sided = inv instanceof ISidedInventory ? (ISidedInventory)inv : null;
        int limit = inv.func_70297_j_();
        int size = access == null ? inv.func_70302_i_() : access.length;
        for (i = 0; i < size; ++i) {
            index = access == null ? i : access[i];
            stack = inv.func_70301_a(index);
            if (stack == null || !toAdd.func_77969_a(stack) || !ItemStack.func_77970_a((ItemStack)toAdd, (ItemStack)stack) || stack.field_77994_a >= Math.min(stack.func_77976_d(), limit) || sided != null && !sided.func_102007_a(index, toAdd, side) || !inv.func_94041_b(index, toAdd)) continue;
            int stackLimit = Math.min(stack.func_77976_d(), limit);
            int amount = Math.min(toAdd.field_77994_a, stackLimit - stack.field_77994_a);
            stack.field_77994_a += amount;
            toAdd.field_77994_a -= amount;
            inv.func_70296_d();
            if (toAdd.field_77994_a != 0) continue;
            return null;
        }
        for (i = 0; i < size; ++i) {
            index = access == null ? i : access[i];
            stack = inv.func_70301_a(index);
            if (stack != null || sided != null && !sided.func_102007_a(index, toAdd, side) || !inv.func_94041_b(index, toAdd)) continue;
            int amount = Math.min(toAdd.field_77994_a, limit);
            ItemStack newStack = toAdd.func_77946_l();
            newStack.field_77994_a = amount;
            inv.func_70299_a(index, newStack);
            toAdd.field_77994_a -= amount;
            inv.func_70296_d();
            if (toAdd.field_77994_a != 0) continue;
            return null;
        }
        return toAdd;
    }

    @Override
    public boolean canPackageEnter(World world, int x, int y, int z, ForgeDirection dir, IConveyorPackage entity) {
        return false;
    }

    @Override
    public void onPackageEnter(World world, int x, int y, int z, ForgeDirection dir, IConveyorPackage entity) {
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World world, int x, int y, int z, int side) {
        return Container.func_94526_b((IInventory)((TileEntityCraneInserter)world.func_147438_o(x, y, z)));
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        this.dropContents(world, x, y, z, block, meta, 0, 21);
        super.func_149749_a(world, x, y, z, block, meta);
    }
}

