/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.network;

import api.hbm.block.IToolable;
import com.hbm.blocks.IBlockSideRotation;
import com.hbm.blocks.ITooltipProvider;
import com.hbm.items.tool.ItemTooling;
import com.hbm.main.MainRegistry;
import com.hbm.tileentity.network.TileEntityCraneBase;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.network.internal.FMLNetworkHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class BlockCraneBase
extends BlockContainer
implements IBlockSideRotation,
IToolable,
ITooltipProvider {
    @SideOnly(value=Side.CLIENT)
    protected IIcon iconSide;
    @SideOnly(value=Side.CLIENT)
    protected IIcon iconIn;
    @SideOnly(value=Side.CLIENT)
    protected IIcon iconSideIn;
    @SideOnly(value=Side.CLIENT)
    protected IIcon iconOut;
    @SideOnly(value=Side.CLIENT)
    protected IIcon iconSideOut;
    @SideOnly(value=Side.CLIENT)
    protected IIcon iconDirectional;
    @SideOnly(value=Side.CLIENT)
    protected IIcon iconDirectionalUp;
    @SideOnly(value=Side.CLIENT)
    protected IIcon iconDirectionalDown;
    @SideOnly(value=Side.CLIENT)
    protected IIcon iconDirectionalTurnLeft;
    @SideOnly(value=Side.CLIENT)
    protected IIcon iconDirectionalTurnRight;
    @SideOnly(value=Side.CLIENT)
    protected IIcon iconDirectionalSideLeftTurnUp;
    @SideOnly(value=Side.CLIENT)
    protected IIcon iconDirectionalSideRightTurnUp;
    @SideOnly(value=Side.CLIENT)
    protected IIcon iconDirectionalSideLeftTurnDown;
    @SideOnly(value=Side.CLIENT)
    protected IIcon iconDirectionalSideRightTurnDown;
    @SideOnly(value=Side.CLIENT)
    protected IIcon iconDirectionalSideUpTurnLeft;
    @SideOnly(value=Side.CLIENT)
    protected IIcon iconDirectionalSideUpTurnRight;
    @SideOnly(value=Side.CLIENT)
    protected IIcon iconDirectionalSideDownTurnLeft;
    @SideOnly(value=Side.CLIENT)
    protected IIcon iconDirectionalSideDownTurnRight;
    public static int renderIDClassic = RenderingRegistry.getNextAvailableRenderId();
    private final Random rand = new Random();

    public BlockCraneBase(Material mat) {
        super(mat);
    }

    public abstract TileEntityCraneBase createNewTileEntity(World var1, int var2);

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.field_149761_L = iconRegister.func_94245_a("hbm:crane_top");
        this.iconSide = iconRegister.func_94245_a("hbm:crane_side");
        this.iconIn = iconRegister.func_94245_a("hbm:crane_in");
        this.iconSideIn = iconRegister.func_94245_a("hbm:crane_side_in");
        this.iconOut = iconRegister.func_94245_a("hbm:crane_out");
        this.iconSideOut = iconRegister.func_94245_a("hbm:crane_side_out");
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() instanceof ItemTooling) {
            return false;
        }
        if (world.field_72995_K) {
            return true;
        }
        if (!player.func_70093_af()) {
            FMLNetworkHandler.openGui((EntityPlayer)player, (Object)MainRegistry.instance, (int)0, (World)world, (int)x, (int)y, (int)z);
            return true;
        }
        return false;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack stack) {
        int l = BlockPistonBase.func_150071_a((World)world, (int)x, (int)y, (int)z, (EntityLivingBase)player);
        world.func_72921_c(x, y, z, l, 2);
    }

    @Override
    public boolean onScrew(World world, EntityPlayer player, int x, int y, int z, int side, float fX, float fY, float fZ, IToolable.ToolType tool) {
        if (tool != IToolable.ToolType.SCREWDRIVER) {
            return false;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof TileEntityCraneBase)) {
            return false;
        }
        TileEntityCraneBase craneTileEntity = (TileEntityCraneBase)te;
        ForgeDirection newDirection = ForgeDirection.getOrientation((int)side);
        if (player.func_70093_af()) {
            craneTileEntity.setOutputOverride(newDirection);
        } else {
            craneTileEntity.setInput(newDirection);
        }
        return true;
    }

    public ForgeDirection getInputSide(IBlockAccess world, int x, int y, int z) {
        return ForgeDirection.getOrientation((int)world.func_72805_g(x, y, z));
    }

    protected final ForgeDirection getOutputSideOverride(IBlockAccess world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof TileEntityCraneBase)) {
            return ForgeDirection.UNKNOWN;
        }
        TileEntityCraneBase craneTileEntity = (TileEntityCraneBase)te;
        return craneTileEntity.getOutputOverride();
    }

    public ForgeDirection getOutputSide(IBlockAccess world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof TileEntityCraneBase)) {
            return ForgeDirection.UNKNOWN;
        }
        TileEntityCraneBase craneTileEntity = (TileEntityCraneBase)te;
        return craneTileEntity.getOutputSide();
    }

    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        ForgeDirection inputSide = this.getInputSide(world, x, y, z);
        ForgeDirection outputOverride = this.getOutputSideOverride(world, x, y, z);
        boolean outputSideOverridden = outputOverride != ForgeDirection.UNKNOWN && outputOverride.getOpposite() != inputSide;
        ForgeDirection outputSide = outputSideOverridden ? outputOverride : inputSide.getOpposite();
        ForgeDirection leftHandRotation = outputSide.getRotation(inputSide);
        if (side == 0 || side == 1) {
            if (side == outputSide.ordinal()) {
                return this.iconOut;
            }
            if (side == inputSide.ordinal()) {
                return this.iconIn;
            }
            if (side == 1) {
                if (outputSideOverridden) {
                    if (leftHandRotation == ForgeDirection.UP) {
                        return this.iconDirectionalTurnLeft;
                    }
                    if (leftHandRotation == ForgeDirection.DOWN) {
                        return this.iconDirectionalTurnRight;
                    }
                } else {
                    return this.iconDirectional;
                }
            }
            return this.field_149761_L;
        }
        if (side == outputSide.ordinal()) {
            return this.iconSideOut;
        }
        if (side == inputSide.ordinal()) {
            return this.iconSideIn;
        }
        if (outputSideOverridden) {
            if (leftHandRotation.ordinal() == side) {
                if (outputSide == ForgeDirection.UP) {
                    return this.iconDirectionalSideLeftTurnUp;
                }
                if (outputSide == ForgeDirection.DOWN) {
                    return this.iconDirectionalSideRightTurnDown;
                }
                if (inputSide == ForgeDirection.UP) {
                    return this.iconDirectionalSideUpTurnRight;
                }
                if (inputSide == ForgeDirection.DOWN) {
                    return this.iconDirectionalSideDownTurnLeft;
                }
            }
            if (leftHandRotation.getOpposite().ordinal() == side) {
                if (outputSide == ForgeDirection.UP) {
                    return this.iconDirectionalSideRightTurnUp;
                }
                if (outputSide == ForgeDirection.DOWN) {
                    return this.iconDirectionalSideLeftTurnDown;
                }
                if (inputSide == ForgeDirection.UP) {
                    return this.iconDirectionalSideUpTurnLeft;
                }
                if (inputSide == ForgeDirection.DOWN) {
                    return this.iconDirectionalSideDownTurnRight;
                }
            }
        } else {
            if (outputSide == ForgeDirection.UP) {
                return this.iconDirectionalUp;
            }
            if (outputSide == ForgeDirection.DOWN) {
                return this.iconDirectionalDown;
            }
        }
        return this.iconSide;
    }

    public IIcon func_149691_a(int side, int metadata) {
        if (side == 0 || side == 1) {
            if (side == metadata) {
                return this.iconOut;
            }
            if (side == ForgeDirection.getOrientation((int)metadata).getOpposite().ordinal()) {
                return this.iconIn;
            }
            return side == 1 ? this.iconDirectional : this.field_149761_L;
        }
        if (side == metadata) {
            return this.iconSideOut;
        }
        if (side == ForgeDirection.getOrientation((int)metadata).getOpposite().ordinal()) {
            return this.iconSideIn;
        }
        if (metadata == 0) {
            return this.iconDirectionalUp;
        }
        if (metadata == 1) {
            return this.iconDirectionalDown;
        }
        return this.iconSide;
    }

    @Override
    public int getRotationFromSide(IBlockAccess world, int x, int y, int z, int side) {
        int meta = world.func_72805_g(x, y, z);
        if (meta > 1 && side == 1) {
            if (meta == 2) {
                return 3;
            }
            if (meta == 3) {
                return 0;
            }
            if (meta == 4) {
                return 1;
            }
            if (meta == 5) {
                return 2;
            }
        }
        return 0;
    }

    public int func_149645_b() {
        return IBlockSideRotation.getRenderType();
    }

    public void dropContents(World world, int x, int y, int z, Block block, int meta, int start, int end) {
        ISidedInventory tileentityfurnace = (ISidedInventory)world.func_147438_o(x, y, z);
        if (tileentityfurnace != null) {
            for (int i1 = start; i1 < end; ++i1) {
                ItemStack itemstack = tileentityfurnace.func_70301_a(i1);
                if (itemstack == null) continue;
                float f = this.rand.nextFloat() * 0.8f + 0.1f;
                float f1 = this.rand.nextFloat() * 0.8f + 0.1f;
                float f2 = this.rand.nextFloat() * 0.8f + 0.1f;
                while (itemstack.field_77994_a > 0) {
                    int j1 = this.rand.nextInt(21) + 10;
                    if (j1 > itemstack.field_77994_a) {
                        j1 = itemstack.field_77994_a;
                    }
                    itemstack.field_77994_a -= j1;
                    EntityItem entityitem = new EntityItem(world, (double)((float)x + f), (double)((float)y + f1), (double)((float)z + f2), new ItemStack(itemstack.func_77973_b(), j1, itemstack.func_77960_j()));
                    if (itemstack.func_77942_o()) {
                        entityitem.func_92059_d().func_77982_d((NBTTagCompound)itemstack.func_77978_p().func_74737_b());
                    }
                    float f3 = 0.05f;
                    entityitem.field_70159_w = (float)this.rand.nextGaussian() * f3;
                    entityitem.field_70181_x = (float)this.rand.nextGaussian() * f3 + 0.2f;
                    entityitem.field_70179_y = (float)this.rand.nextGaussian() * f3;
                    world.func_72838_d((Entity)entityitem);
                }
            }
            world.func_147453_f(x, y, z, block);
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean ext) {
        this.addStandardInfo(stack, player, list, ext);
    }
}

