/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.network;

import api.hbm.block.IToolable;
import com.hbm.blocks.network.BlockConveyorBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class BlockConveyorBendable
extends BlockConveyorBase
implements IToolable {
    @SideOnly(value=Side.CLIENT)
    protected IIcon curveLeft;
    @SideOnly(value=Side.CLIENT)
    protected IIcon curveRight;

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        super.func_149651_a(iconRegister);
        this.curveLeft = iconRegister.func_94245_a(this.func_149641_N() + "_curve_left");
        this.curveRight = iconRegister.func_94245_a(this.func_149641_N() + "_curve_right");
    }

    protected int getPathDirection(int meta) {
        if (meta >= 6 && meta <= 9) {
            return 1;
        }
        if (meta >= 10 && meta <= 13) {
            return 2;
        }
        return 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        int dir = this.getPathDirection(metadata);
        if (dir > 0 && side > 1) {
            return this.sideIcon;
        }
        if (!(metadata != 2 && metadata != 3 || side != 4 && side != 5)) {
            return this.sideIcon;
        }
        if (!(metadata != 4 && metadata != 5 || side != 2 && side != 3)) {
            return this.sideIcon;
        }
        if (dir == 1) {
            return this.curveLeft;
        }
        if (dir == 2) {
            return this.curveRight;
        }
        return super.func_149691_a(side, metadata);
    }

    @Override
    public ForgeDirection getTravelDirection(World world, int x, int y, int z, Vec3 itemPos) {
        int meta = world.func_72805_g(x, y, z);
        int dir = this.getPathDirection(meta);
        ForgeDirection primary = ForgeDirection.getOrientation((int)(meta -= dir * 4));
        if (dir > 0) {
            double dZ;
            double ix = (double)x + 0.5;
            double iz = (double)z + 0.5;
            ForgeDirection secondary = primary.getRotation(ForgeDirection.UP);
            ix -= (double)(-primary.offsetX) * 0.5 + (double)secondary.offsetX * (0.5 - (double)(--dir));
            iz -= (double)(-primary.offsetZ) * 0.5 + (double)secondary.offsetZ * (0.5 - (double)dir);
            double dX = Math.abs(itemPos.field_72450_a - ix);
            if (dX + (dZ = Math.abs(itemPos.field_72449_c - iz)) >= 1.0) {
                if (dir == 0) {
                    return secondary.getOpposite();
                }
                return secondary;
            }
        }
        return primary;
    }

    @Override
    public boolean onScrew(World world, EntityPlayer player, int x, int y, int z, int side, float fX, float fY, float fZ, IToolable.ToolType tool) {
        int meta;
        if (tool != IToolable.ToolType.SCREWDRIVER) {
            return false;
        }
        int newMeta = meta = world.func_72805_g(x, y, z);
        int dir = this.getPathDirection(meta);
        if (!player.func_70093_af()) {
            if (meta > 9) {
                meta -= 8;
            }
            if (meta > 5) {
                meta -= 4;
            }
            newMeta = ForgeDirection.getOrientation((int)meta).getRotation(ForgeDirection.UP).ordinal() + dir * 4;
        } else {
            newMeta = dir < 2 ? (newMeta += 4) : (newMeta -= 8);
        }
        world.func_72921_c(x, y, z, newMeta, 3);
        return true;
    }
}

