/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.machine.pile;

import api.hbm.block.IInsertable;
import api.hbm.block.IToolable;
import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.generic.BlockFlammable;
import com.hbm.blocks.machine.pile.BlockGraphiteDrilled;
import com.hbm.blocks.machine.pile.BlockGraphiteDrilledTE;
import com.hbm.inventory.RecipesCommon;
import com.hbm.items.ModItems;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class BlockGraphiteDrilledBase
extends BlockFlammable
implements IToolable,
IInsertable {
    @SideOnly(value=Side.CLIENT)
    protected IIcon sideIcon;
    @SideOnly(value=Side.CLIENT)
    protected IIcon blockIconAluminum;

    public BlockGraphiteDrilledBase() {
        super(ModBlocks.block_graphite.func_149688_o(), ((BlockFlammable)ModBlocks.block_graphite).encouragement, ((BlockFlammable)ModBlocks.block_graphite).flammability);
        this.func_149647_a(null);
        this.func_149672_a(Block.field_149777_j);
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        super.func_149651_a(iconRegister);
        this.sideIcon = iconRegister.func_94245_a("hbm:block_graphite");
        this.blockIconAluminum = iconRegister.func_94245_a("hbm:block_graphite_drilled_aluminum");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        int cfg = metadata & 3;
        int meta = metadata & 4;
        if (side == cfg * 2 || side == cfg * 2 + 1) {
            if (meta == 4) {
                return this.blockIconAluminum;
            }
            return this.field_149761_L;
        }
        return this.sideIcon;
    }

    protected static void ejectItem(World world, int x, int y, int z, ForgeDirection dir, ItemStack stack) {
        EntityItem dust = new EntityItem(world, (double)x + 0.5 + (double)dir.offsetX * 0.75, (double)y + 0.5 + (double)dir.offsetY * 0.75, (double)z + 0.5 + (double)dir.offsetZ * 0.75, stack);
        dust.field_70159_w = (double)dir.offsetX * 0.25;
        dust.field_70181_x = (double)dir.offsetY * 0.25;
        dust.field_70179_y = (double)dir.offsetZ * 0.25;
        world.func_72838_d((Entity)dust);
    }

    public Item func_149650_a(int meta, Random rand, int fortune) {
        return null;
    }

    @Override
    public boolean onScrew(World world, EntityPlayer player, int x, int y, int z, int side, float fX, float fY, float fZ, IToolable.ToolType tool) {
        int meta;
        int cfg;
        if (tool != IToolable.ToolType.SCREWDRIVER) {
            return false;
        }
        if (!(world.field_72995_K || side != (cfg = (meta = world.func_72805_g(x, y, z)) & 3) * 2 && side != cfg * 2 + 1)) {
            world.func_147465_d(x, y, z, ModBlocks.block_graphite_drilled, meta & 7, 3);
            BlockGraphiteDrilledBase.ejectItem(world, x, y, z, ForgeDirection.getOrientation((int)side), new ItemStack(this.getInsertedItem(meta)));
        }
        return true;
    }

    protected Item getInsertedItem(int meta) {
        return this.getInsertedItem();
    }

    protected Item getInsertedItem() {
        return null;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int meta, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.add(new ItemStack(ModItems.ingot_graphite, 8));
        if ((meta & 4) == 4) {
            drops.add(new ItemStack(ModItems.hull_small_aluminium, 1));
        }
        if (this.getInsertedItem() != null) {
            drops.add(new ItemStack(this.getInsertedItem(meta), 1));
        }
        return drops;
    }

    protected RecipesCommon.MetaBlock checkInteractions(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item == ModItems.pile_rod_uranium) {
            return new RecipesCommon.MetaBlock(ModBlocks.block_graphite_fuel);
        }
        if (item == ModItems.pile_rod_pu239) {
            return new RecipesCommon.MetaBlock(ModBlocks.block_graphite_fuel, 8);
        }
        if (item == ModItems.pile_rod_plutonium) {
            return new RecipesCommon.MetaBlock(ModBlocks.block_graphite_plutonium);
        }
        if (item == ModItems.pile_rod_source) {
            return new RecipesCommon.MetaBlock(ModBlocks.block_graphite_source);
        }
        if (item == ModItems.pile_rod_boron) {
            return new RecipesCommon.MetaBlock(ModBlocks.block_graphite_rod);
        }
        if (item == ModItems.pile_rod_lithium) {
            return new RecipesCommon.MetaBlock(ModBlocks.block_graphite_lithium);
        }
        if (item == ModItems.cell_tritium) {
            return new RecipesCommon.MetaBlock(ModBlocks.block_graphite_tritium);
        }
        if (item == ModItems.pile_rod_detector) {
            return new RecipesCommon.MetaBlock(ModBlocks.block_graphite_detector);
        }
        return null;
    }

    @Override
    public boolean insertItem(World world, int x, int y, int z, ForgeDirection dir, ItemStack stack) {
        int pureMeta;
        if (stack == null) {
            return false;
        }
        RecipesCommon.MetaBlock baseBlock = this.checkInteractions(stack);
        if (baseBlock == null) {
            return false;
        }
        int side = dir.ordinal();
        if (side == (pureMeta = world.func_72805_g(x, y, z) & 3) * 2 || side == pureMeta * 2 + 1) {
            for (int i = 0; i <= 3; ++i) {
                int ix = x + dir.offsetX * i;
                int iy = y + dir.offsetY * i;
                int iz = z + dir.offsetZ * i;
                Block b = world.func_147439_a(ix, iy, iz);
                if (b instanceof BlockGraphiteDrilledBase) {
                    int baseMeta = world.func_72805_g(ix, iy, iz);
                    if ((baseMeta & 3) != pureMeta) {
                        return false;
                    }
                    if (((BlockGraphiteDrilledBase)b).getInsertedItem(baseMeta) == null) break;
                    if (i < 3) continue;
                    return false;
                }
                if (!b.func_149721_r()) break;
                return false;
            }
            int oldMeta = pureMeta | baseBlock.meta;
            Block oldBlock = baseBlock.block;
            NBTTagCompound oldTag = new NBTTagCompound();
            oldTag.func_74768_a("x", x);
            oldTag.func_74768_a("y", y);
            oldTag.func_74768_a("z", z);
            for (int i = 0; i <= 3; ++i) {
                int ix = x + dir.offsetX * i;
                int iy = y + dir.offsetY * i;
                int iz = z + dir.offsetZ * i;
                Block newBlock = world.func_147439_a(ix, iy, iz);
                if (newBlock instanceof BlockGraphiteDrilledBase) {
                    TileEntity te;
                    int newMeta = world.func_72805_g(ix, iy, iz);
                    NBTTagCompound newTag = new NBTTagCompound();
                    if (newBlock instanceof BlockGraphiteDrilledTE) {
                        te = world.func_147438_o(ix, iy, iz);
                        te.func_145841_b(newTag);
                        newTag.func_74768_a("x", te.field_145851_c + dir.offsetX);
                        newTag.func_74768_a("y", te.field_145848_d + dir.offsetY);
                        newTag.func_74768_a("z", te.field_145849_e + dir.offsetZ);
                    }
                    world.func_147465_d(ix, iy, iz, oldBlock, oldMeta & 0xFFFFFFFB | newMeta & 4, 0);
                    if (oldBlock instanceof BlockGraphiteDrilledTE && !oldTag.func_82582_d()) {
                        te = world.func_147438_o(ix, iy, iz);
                        te.func_145839_a(oldTag);
                    }
                    world.markAndNotifyBlock(ix, iy, iz, world.func_72938_d(ix, iz), newBlock, oldBlock, 3);
                    oldMeta = newMeta;
                    oldBlock = newBlock;
                    oldTag = newTag;
                    if (!(oldBlock instanceof BlockGraphiteDrilled)) continue;
                    break;
                }
                Item eject = ((BlockGraphiteDrilledBase)oldBlock).getInsertedItem(oldMeta);
                BlockGraphiteDrilledBase.ejectItem(world, ix - dir.offsetX, iy - dir.offsetY, iz - dir.offsetZ, dir, new ItemStack(eject));
                world.func_72908_a((double)ix + 0.5, (double)iy + 0.5, (double)iz + 0.5, "hbm:item.upgradePlug", 1.25f, 1.0f);
                break;
            }
            return true;
        }
        return false;
    }
}

