/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.machine;

import com.hbm.blocks.BlockDummyable;
import com.hbm.blocks.ILookOverlay;
import com.hbm.blocks.ITooltipProvider;
import com.hbm.items.ModItems;
import com.hbm.tileentity.TileEntityProxyCombo;
import com.hbm.tileentity.machine.TileEntitySawmill;
import com.hbm.util.BobMathUtil;
import com.hbm.util.I18nUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.util.ForgeDirection;

public class MachineSawmill
extends BlockDummyable
implements ILookOverlay,
ITooltipProvider {
    public MachineSawmill() {
        super(Material.field_151573_f);
        this.bounding.add(AxisAlignedBB.func_72330_a((double)-1.5, (double)0.0, (double)-1.5, (double)1.5, (double)1.0, (double)1.5));
        this.bounding.add(AxisAlignedBB.func_72330_a((double)-1.25, (double)1.0, (double)-0.5, (double)-0.625, (double)1.875, (double)0.5));
        this.bounding.add(AxisAlignedBB.func_72330_a((double)-0.625, (double)1.0, (double)-1.0, (double)1.375, (double)2.0, (double)1.0));
    }

    public TileEntity func_149915_a(World world, int meta) {
        if (meta >= 12) {
            return new TileEntitySawmill();
        }
        if (meta >= 6) {
            return new TileEntityProxyCombo().inventory();
        }
        return null;
    }

    @Override
    public int[] getDimensions() {
        return new int[]{1, 0, 1, 1, 1, 1};
    }

    @Override
    public int getOffset() {
        return 1;
    }

    @Override
    public void fillSpace(World world, int x, int y, int z, ForgeDirection dir, int o) {
        super.fillSpace(world, x, y, z, dir, o);
        this.makeExtra(world, (x += dir.offsetX * o) + 1, y, z += dir.offsetZ * o);
        this.makeExtra(world, x - 1, y, z);
        this.makeExtra(world, x, y, z + 1);
        this.makeExtra(world, x, y, z - 1);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (!player.func_70093_af()) {
            int[] pos = this.findCore(world, x, y, z);
            if (pos == null) {
                return false;
            }
            TileEntitySawmill sawmill = (TileEntitySawmill)world.func_147438_o(pos[0], pos[1], pos[2]);
            if (!sawmill.hasBlade && player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() == ModItems.sawblade) {
                --player.func_70694_bm().field_77994_a;
                sawmill.hasBlade = true;
                sawmill.func_70296_d();
                world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "hbm:item.upgradePlug", 1.5f, 0.75f);
                return true;
            }
            if (sawmill.slots[1] != null || sawmill.slots[2] != null) {
                for (int i = 1; i < 3; ++i) {
                    if (sawmill.slots[i] == null) continue;
                    if (!player.field_71071_by.func_70441_a(sawmill.slots[i].func_77946_l())) {
                        player.func_71019_a(sawmill.slots[i].func_77946_l(), false);
                    }
                    sawmill.slots[i] = null;
                }
                player.field_71069_bz.func_75142_b();
                sawmill.func_70296_d();
                return true;
            }
            if (sawmill.slots[0] == null && player.func_70694_bm() != null && sawmill.getOutput(player.func_70694_bm()) != null) {
                sawmill.slots[0] = player.func_70694_bm().func_77946_l();
                sawmill.slots[0].field_77994_a = 1;
                --player.func_70694_bm().field_77994_a;
                sawmill.func_70296_d();
                player.field_71069_bz.func_75142_b();
                return true;
            }
        }
        return false;
    }

    @Override
    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack itemStack) {
        super.func_149689_a(world, x, y, z, player, itemStack);
        if (itemStack.func_77960_j() == 1) {
            int i = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            int o = -this.getOffset();
            ForgeDirection dir = ForgeDirection.NORTH;
            if (i == 0) {
                dir = ForgeDirection.getOrientation((int)2);
            }
            if (i == 1) {
                dir = ForgeDirection.getOrientation((int)5);
            }
            if (i == 2) {
                dir = ForgeDirection.getOrientation((int)3);
            }
            if (i == 3) {
                dir = ForgeDirection.getOrientation((int)4);
            }
            dir = this.getDirModified(dir);
            TileEntity te = world.func_147438_o(x + dir.offsetX * o, y + dir.offsetY * o, z + dir.offsetZ * o);
            if (te instanceof TileEntitySawmill) {
                ((TileEntitySawmill)te).hasBlade = false;
            }
        }
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        int count = this.quantityDropped(metadata, fortune, world.field_73012_v);
        int dmg = 0;
        int[] pos = this.findCore(world, x, y, z);
        if (pos != null) {
            TileEntitySawmill stirling = (TileEntitySawmill)world.func_147438_o(pos[0], pos[1], pos[2]);
            if (!stirling.hasBlade) {
                dmg = 1;
            }
        }
        for (int i = 0; i < count; ++i) {
            Item item = this.func_149650_a(metadata, world.field_73012_v, fortune);
            if (item == null) continue;
            ret.add(new ItemStack(item, 1, dmg));
        }
        return ret;
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean ext) {
        this.addStandardInfo(stack, player, list, ext);
    }

    @Override
    public void printHook(RenderGameOverlayEvent.Pre event, World world, int x, int y, int z) {
        int i;
        int[] pos = this.findCore(world, x, y, z);
        if (pos == null) {
            return;
        }
        TileEntity te = world.func_147438_o(pos[0], pos[1], pos[2]);
        if (!(te instanceof TileEntitySawmill)) {
            return;
        }
        TileEntitySawmill stirling = (TileEntitySawmill)te;
        ArrayList<String> text = new ArrayList<String>();
        text.add(stirling.heat + "TU/t");
        double percent = (double)stirling.heat / 300.0;
        int color = (int)(255.0 - 255.0 * percent) << 16 | (int)(255.0 * percent) << 8;
        if (percent > 1.0) {
            color = 0xFF0000;
        }
        text.add("&[" + color + "&]" + (double)(stirling.heat * 1000 / 300) / 10.0 + "%");
        int limiter = stirling.progress * 26 / 600;
        String bar = EnumChatFormatting.GREEN + "[ ";
        for (i = 0; i < 25; ++i) {
            if (i == limiter) {
                bar = bar + EnumChatFormatting.RESET;
            }
            bar = bar + "\u258f";
        }
        bar = bar + EnumChatFormatting.GREEN + " ]";
        text.add(bar);
        for (i = 0; i < 3; ++i) {
            if (stirling.slots[i] == null) continue;
            text.add((i == 0 ? EnumChatFormatting.GREEN + "-> " : EnumChatFormatting.RED + "<- ") + EnumChatFormatting.RESET + stirling.slots[i].func_82833_r() + (stirling.slots[i].field_77994_a > 1 ? " x" + stirling.slots[i].field_77994_a : ""));
        }
        if (stirling.heat > 300) {
            text.add("&[" + (BobMathUtil.getBlink() ? 0xFF0000 : 0xFFFF00) + "&]! ! ! OVERSPEED ! ! !");
        }
        if (!stirling.hasBlade) {
            text.add("&[16711680&]Blade missing!");
        }
        ILookOverlay.printGeneric(event, I18nUtil.resolveKey(this.func_149739_a() + ".name", new Object[0]), 0xFFFF00, 0x404000, text);
    }
}

