/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.machine;

import com.hbm.blocks.BlockDummyable;
import com.hbm.blocks.IBlockMulti;
import com.hbm.blocks.ILookOverlay;
import com.hbm.blocks.ITooltipProvider;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.trait.FT_Heatable;
import com.hbm.items.ModItems;
import com.hbm.items.machine.IItemFluidIdentifier;
import com.hbm.tileentity.TileEntityProxyCombo;
import com.hbm.tileentity.machine.TileEntityHeatBoiler;
import com.hbm.util.I18nUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.util.ForgeDirection;

public class MachineHeatBoiler
extends BlockDummyable
implements ILookOverlay,
ITooltipProvider,
IBlockMulti {
    public MachineHeatBoiler() {
        super(Material.field_151573_f);
    }

    public TileEntity func_149915_a(World world, int meta) {
        if (meta >= 12) {
            return new TileEntityHeatBoiler();
        }
        if (meta >= 6) {
            return new TileEntityProxyCombo().fluid();
        }
        return null;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K && !player.func_70093_af()) {
            if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() instanceof IItemFluidIdentifier) {
                int[] pos = this.findCore(world, x, y, z);
                if (pos == null) {
                    return false;
                }
                TileEntity te = world.func_147438_o(pos[0], pos[1], pos[2]);
                if (!(te instanceof TileEntityHeatBoiler)) {
                    return false;
                }
                TileEntityHeatBoiler boiler = (TileEntityHeatBoiler)te;
                FluidType type = ((IItemFluidIdentifier)player.func_70694_bm().func_77973_b()).getType(world, pos[0], pos[1], pos[2], player.func_70694_bm());
                if (type.hasTrait(FT_Heatable.class) && type.getTrait(FT_Heatable.class).getEfficiency(FT_Heatable.HeatingType.BOILER) > 0.0) {
                    boiler.tanks[0].setTankType(type);
                    boiler.func_70296_d();
                    player.func_146105_b(new ChatComponentText("Changed type to ").func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.YELLOW)).func_150257_a((IChatComponent)new ChatComponentTranslation("hbmfluid." + type.getName().toLowerCase(Locale.US), new Object[0])).func_150257_a((IChatComponent)new ChatComponentText("!")));
                }
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack itemStack) {
        super.func_149689_a(world, x, y, z, player, itemStack);
        if (itemStack.func_77960_j() == 1) {
            int i = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            int o = -this.getOffset();
            ForgeDirection dir = ForgeDirection.NORTH;
            if (i == 0) {
                dir = ForgeDirection.getOrientation((int)2);
            }
            if (i == 1) {
                dir = ForgeDirection.getOrientation((int)5);
            }
            if (i == 2) {
                dir = ForgeDirection.getOrientation((int)3);
            }
            if (i == 3) {
                dir = ForgeDirection.getOrientation((int)4);
            }
            dir = this.getDirModified(dir);
            TileEntity te = world.func_147438_o(x + dir.offsetX * o, y + dir.offsetY * o, z + dir.offsetZ * o);
            if (te instanceof TileEntityHeatBoiler) {
                ((TileEntityHeatBoiler)te).hasExploded = true;
            }
        }
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        int count = this.quantityDropped(metadata, fortune, world.field_73012_v);
        int dmg = 0;
        int[] pos = this.findCore(world, x, y, z);
        if (pos != null) {
            TileEntityHeatBoiler boiler = (TileEntityHeatBoiler)world.func_147438_o(pos[0], pos[1], pos[2]);
            if (boiler.hasExploded) {
                ret.add(new ItemStack(ModItems.ingot_steel, 4));
                ret.add(new ItemStack(ModItems.plate_copper, 8));
                return ret;
            }
        }
        for (int i = 0; i < count; ++i) {
            Item item = this.func_149650_a(metadata, world.field_73012_v, fortune);
            if (item == null) continue;
            ret.add(new ItemStack(item, 1, dmg));
        }
        return ret;
    }

    @Override
    public int[] getDimensions() {
        return new int[]{3, 0, 1, 1, 1, 1};
    }

    @Override
    public int getOffset() {
        return 1;
    }

    @Override
    public void fillSpace(World world, int x, int y, int z, ForgeDirection dir, int o) {
        super.fillSpace(world, x, y, z, dir, o);
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        this.makeExtra(world, (x += dir.offsetX * o) + rot.offsetX, y, (z += dir.offsetZ * o) + rot.offsetZ);
        this.makeExtra(world, x - rot.offsetX, y, z - rot.offsetZ);
        this.makeExtra(world, x, y + 3, z);
    }

    @Override
    public void printHook(RenderGameOverlayEvent.Pre event, World world, int x, int y, int z) {
        int[] pos = this.findCore(world, x, y, z);
        if (pos == null) {
            return;
        }
        TileEntity te = world.func_147438_o(pos[0], pos[1], pos[2]);
        if (!(te instanceof TileEntityHeatBoiler)) {
            return;
        }
        TileEntityHeatBoiler boiler = (TileEntityHeatBoiler)te;
        if (boiler.hasExploded) {
            return;
        }
        ArrayList<String> text = new ArrayList<String>();
        text.add(String.format("%,d", boiler.heat) + "TU");
        text.add(EnumChatFormatting.GREEN + "-> " + EnumChatFormatting.RESET + I18nUtil.resolveKey(boiler.tanks[0].getTankType().getUnlocalizedName(), new Object[0]) + ": " + String.format("%,d", boiler.tanks[0].getFill()) + " / " + String.format("%,d", boiler.tanks[0].getMaxFill()) + "mB");
        text.add(EnumChatFormatting.RED + "<- " + EnumChatFormatting.RESET + I18nUtil.resolveKey(boiler.tanks[1].getTankType().getUnlocalizedName(), new Object[0]) + ": " + String.format("%,d", boiler.tanks[1].getFill()) + " / " + String.format("%,d", boiler.tanks[1].getMaxFill()) + "mB");
        ILookOverlay.printGeneric(event, I18nUtil.resolveKey(this.func_149739_a() + ".name", new Object[0]), 0xFFFF00, 0x404000, text);
    }

    @Override
    public int getSubCount() {
        return 0;
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean ext) {
        this.addStandardInfo(stack, player, list, ext);
    }
}

