/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.machine;

import com.hbm.blocks.ILookOverlay;
import com.hbm.tileentity.machine.TileEntityDeuteriumExtractor;
import com.hbm.util.BobMathUtil;
import com.hbm.util.I18nUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Locale;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;

public class MachineDeuteriumExtractor
extends BlockContainer
implements ILookOverlay {
    @SideOnly(value=Side.CLIENT)
    private IIcon iconTopH2O;

    public MachineDeuteriumExtractor(Material mat) {
        super(mat);
    }

    public TileEntity func_149915_a(World world, int meta) {
        meta = 0;
        return new TileEntityDeuteriumExtractor();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.field_149761_L = iconRegister.func_94245_a("hbm:deuterium_extractor_side");
        this.iconTopH2O = iconRegister.func_94245_a("hbm:deuterium_extractor_top_water");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        if (side == 0 || side == 1) {
            return this.iconTopH2O;
        }
        return this.field_149761_L;
    }

    @Override
    public void printHook(RenderGameOverlayEvent.Pre event, World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof TileEntityDeuteriumExtractor)) {
            return;
        }
        TileEntityDeuteriumExtractor extractor = (TileEntityDeuteriumExtractor)te;
        ArrayList<String> text = new ArrayList<String>();
        text.add((extractor.power < extractor.getMaxPower() / 20L ? EnumChatFormatting.RED : EnumChatFormatting.GREEN) + "Power: " + BobMathUtil.getShortNumber(extractor.power) + "HE");
        for (int i = 0; i < extractor.tanks.length; ++i) {
            text.add((i < 1 ? EnumChatFormatting.GREEN + "-> " : EnumChatFormatting.RED + "<- ") + EnumChatFormatting.RESET + I18nUtil.resolveKey("hbmfluid." + extractor.tanks[i].getTankType().getName().toLowerCase(Locale.US), new Object[0]) + ": " + extractor.tanks[i].getFill() + "/" + extractor.tanks[i].getMaxFill() + "mB");
        }
        ILookOverlay.printGeneric(event, I18nUtil.resolveKey(this.func_149739_a() + ".name", new Object[0]), 0xFFFF00, 0x404000, text);
    }
}

