/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.machine;

import api.hbm.energy.IEnergyConnector;
import api.hbm.energy.IEnergyUser;
import com.hbm.blocks.ILookOverlay;
import com.hbm.blocks.IPersistentInfoProvider;
import com.hbm.blocks.ITooltipProvider;
import com.hbm.blocks.ModBlocks;
import com.hbm.tileentity.INBTPacketReceiver;
import com.hbm.tileentity.IPersistentNBT;
import com.hbm.tileentity.TileEntityLoadedBase;
import com.hbm.util.BobMathUtil;
import com.hbm.util.I18nUtil;
import com.hbm.util.fauxpointtwelve.BlockPos;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.input.Keyboard;

public class MachineCapacitor
extends BlockContainer
implements ILookOverlay,
IPersistentInfoProvider,
ITooltipProvider {
    @SideOnly(value=Side.CLIENT)
    public IIcon iconTop;
    @SideOnly(value=Side.CLIENT)
    public IIcon iconSide;
    @SideOnly(value=Side.CLIENT)
    public IIcon iconBottom;
    @SideOnly(value=Side.CLIENT)
    public IIcon iconInnerTop;
    @SideOnly(value=Side.CLIENT)
    public IIcon iconInnerSide;
    protected long power;
    String name;
    public static int renderID = RenderingRegistry.getNextAvailableRenderId();

    public MachineCapacitor(Material mat, long power, String name) {
        super(mat);
        this.power = power;
        this.name = name;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        super.func_149651_a(iconRegister);
        this.iconTop = iconRegister.func_94245_a("hbm:capacitor_" + this.name + "_top");
        this.iconSide = iconRegister.func_94245_a("hbm:capacitor_" + this.name + "_side");
        this.iconBottom = iconRegister.func_94245_a("hbm:capacitor_" + this.name + "_bottom");
        this.iconInnerTop = iconRegister.func_94245_a("hbm:capacitor_" + this.name + "_inner_top");
        this.iconInnerSide = iconRegister.func_94245_a("hbm:capacitor_" + this.name + "_inner_side");
    }

    public int func_149645_b() {
        return renderID;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149660_a(World world, int x, int y, int z, int side, float fX, float fY, float fZ, int meta) {
        return side;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityCapacitor(this.power);
    }

    @Override
    public void printHook(RenderGameOverlayEvent.Pre event, World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof TileEntityCapacitor)) {
            return;
        }
        TileEntityCapacitor battery = (TileEntityCapacitor)te;
        ArrayList<String> text = new ArrayList<String>();
        text.add(BobMathUtil.getShortNumber(battery.getPower()) + " / " + BobMathUtil.getShortNumber(battery.getMaxPower()) + "HE");
        double percent = (double)battery.getPower() / (double)battery.getMaxPower();
        int charge = (int)Math.floor(percent * 10000.0);
        int color = (int)(255.0 - 255.0 * percent) << 16 | (int)(255.0 * percent) << 8;
        text.add("&[" + color + "&]" + (double)charge / 100.0 + "%");
        text.add(EnumChatFormatting.GREEN + "-> " + EnumChatFormatting.RESET + "+" + BobMathUtil.getShortNumber(battery.powerReceived) + "HE/t");
        text.add(EnumChatFormatting.RED + "<- " + EnumChatFormatting.RESET + "-" + BobMathUtil.getShortNumber(battery.powerSent) + "HE/t");
        ILookOverlay.printGeneric(event, I18nUtil.resolveKey(this.func_149739_a() + ".name", new Object[0]), 0xFFFF00, 0x404000, text);
    }

    @Override
    public void addInformation(ItemStack stack, NBTTagCompound persistentTag, EntityPlayer player, List list, boolean ext) {
        list.add(EnumChatFormatting.YELLOW + "" + BobMathUtil.getShortNumber(persistentTag.func_74763_f("power")) + "/" + BobMathUtil.getShortNumber(persistentTag.func_74763_f("maxPower")) + "HE");
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean ext) {
        if (Keyboard.isKeyDown((int)42)) {
            for (String s : I18nUtil.resolveKeyArray("tile.capacitor.desc", new Object[0])) {
                list.add(EnumChatFormatting.YELLOW + s);
            }
        } else {
            list.add(EnumChatFormatting.DARK_GRAY + "" + EnumChatFormatting.ITALIC + "Hold <" + EnumChatFormatting.YELLOW + "" + EnumChatFormatting.ITALIC + "LSHIFT" + EnumChatFormatting.DARK_GRAY + "" + EnumChatFormatting.ITALIC + "> to display more info");
        }
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        return IPersistentNBT.getDrops(world, x, y, z, (Block)this);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack itemStack) {
        IPersistentNBT.restoreData(world, x, y, z, itemStack);
    }

    public void func_149681_a(World world, int x, int y, int z, int meta, EntityPlayer player) {
        if (!player.field_71075_bZ.field_75098_d) {
            this.harvesters.set(player);
            this.func_149697_b(world, x, y, z, meta, 0);
            this.harvesters.set(null);
        }
    }

    public void func_149636_a(World world, EntityPlayer player, int x, int y, int z, int meta) {
        player.func_71064_a(StatList.field_75934_C[MachineCapacitor.func_149682_b((Block)this)], 1);
        player.func_71020_j(0.025f);
    }

    public static class TileEntityCapacitor
    extends TileEntityLoadedBase
    implements IEnergyUser,
    INBTPacketReceiver,
    IPersistentNBT {
        public long power;
        protected long maxPower;
        public long prevPower;
        public long powerReceived;
        public long powerSent;

        public TileEntityCapacitor() {
        }

        public TileEntityCapacitor(long maxPower) {
            this.maxPower = maxPower;
        }

        public void func_145845_h() {
            if (!this.field_145850_b.field_72995_K) {
                long gain = this.power - this.prevPower;
                ForgeDirection opp = ForgeDirection.getOrientation((int)this.func_145832_p());
                ForgeDirection dir = opp.getOpposite();
                BlockPos pos = new BlockPos(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
                boolean didStep = false;
                ForgeDirection last = null;
                while (this.field_145850_b.func_147439_a(pos.getX(), pos.getY(), pos.getZ()) == ModBlocks.capacitor_bus) {
                    ForgeDirection current = ForgeDirection.getOrientation((int)this.field_145850_b.func_72805_g(pos.getX(), pos.getY(), pos.getZ()));
                    if (!didStep) {
                        last = current;
                    }
                    didStep = true;
                    if (last != current) {
                        pos = null;
                        break;
                    }
                    pos = pos.offset(current);
                }
                long preSend = this.power;
                if (pos != null && last != null) {
                    this.tryUnsubscribe(this.field_145850_b, pos.getX(), pos.getY(), pos.getZ());
                    this.sendPower(this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), last);
                }
                long sent = preSend - this.power;
                this.trySubscribe(this.field_145850_b, this.field_145851_c + opp.offsetX, this.field_145848_d + opp.offsetY, this.field_145849_e + opp.offsetZ, opp);
                NBTTagCompound data = new NBTTagCompound();
                data.func_74772_a("power", this.power);
                data.func_74772_a("maxPower", this.maxPower);
                data.func_74772_a("rec", gain);
                data.func_74772_a("sent", sent);
                INBTPacketReceiver.networkPack(this, data, 15);
                this.prevPower = this.power;
            }
        }

        @Override
        public void networkUnpack(NBTTagCompound nbt) {
            this.power = nbt.func_74763_f("power");
            this.maxPower = nbt.func_74763_f("maxPower");
            this.powerReceived = nbt.func_74763_f("rec");
            this.powerSent = nbt.func_74763_f("sent");
        }

        @Override
        public long getPower() {
            return this.power;
        }

        @Override
        public long getMaxPower() {
            return this.maxPower;
        }

        @Override
        public IEnergyConnector.ConnectionPriority getPriority() {
            return IEnergyConnector.ConnectionPriority.LOW;
        }

        @Override
        public void setPower(long power) {
            this.power = power;
        }

        @Override
        public boolean canConnect(ForgeDirection dir) {
            return dir == ForgeDirection.getOrientation((int)this.func_145832_p());
        }

        @Override
        public void writeNBT(NBTTagCompound nbt) {
            NBTTagCompound data = new NBTTagCompound();
            data.func_74772_a("power", this.power);
            data.func_74772_a("maxPower", this.maxPower);
            nbt.func_74782_a("persistent", (NBTBase)data);
        }

        @Override
        public void readNBT(NBTTagCompound nbt) {
            NBTTagCompound data = nbt.func_74775_l("persistent");
            this.power = data.func_74763_f("power");
            this.maxPower = data.func_74763_f("maxPower");
        }

        public void func_145839_a(NBTTagCompound nbt) {
            super.func_145839_a(nbt);
            this.power = nbt.func_74763_f("power");
            this.maxPower = nbt.func_74763_f("maxPower");
        }

        public void func_145841_b(NBTTagCompound nbt) {
            super.func_145841_b(nbt);
            nbt.func_74772_a("power", this.power);
            nbt.func_74772_a("maxPower", this.maxPower);
        }
    }
}

