/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.generic;

import api.hbm.block.IToolable;
import com.hbm.blocks.BlockMulti;
import com.hbm.blocks.ILookOverlay;
import com.hbm.blocks.ModBlocks;
import com.hbm.inventory.OreDictManager;
import com.hbm.inventory.RecipesCommon;
import com.hbm.items.ModItems;
import com.hbm.util.I18nUtil;
import com.hbm.util.InventoryUtil;
import com.hbm.util.Tuple;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;

public class BlockToolConversion
extends BlockMulti
implements IToolable,
ILookOverlay {
    public IIcon[] icons;
    public String[] names;
    public static HashMap<Tuple.Pair<IToolable.ToolType, RecipesCommon.MetaBlock>, Tuple.Pair<RecipesCommon.AStack[], RecipesCommon.MetaBlock>> conversions = new HashMap();
    public static HashMap<Object[], Object> bufferedRecipes = new HashMap();
    public static HashMap<Object[], Object> bufferedTools = new HashMap();

    public BlockToolConversion(Material mat) {
        super(mat);
    }

    public BlockToolConversion addVariant(String ... name) {
        this.names = name;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        super.func_149651_a(iconRegister);
        if (this.names != null) {
            this.icons = new IIcon[this.names.length];
            for (int i = 0; i < this.names.length; ++i) {
                this.icons[i] = iconRegister.func_94245_a(this.func_149641_N() + this.names[i]);
            }
        }
    }

    @Override
    public String getUnlocalizedName(ItemStack stack) {
        int meta = stack.func_77960_j() - 1;
        if (meta == -1 || this.names == null || meta >= this.names.length) {
            return this.func_149739_a();
        }
        return this.func_149739_a() + this.names[meta];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        if (--metadata == -1 || this.icons == null || metadata >= this.icons.length) {
            return super.func_149691_a(side, metadata);
        }
        return this.icons[metadata];
    }

    @Override
    public boolean onScrew(World world, EntityPlayer player, int x, int y, int z, int side, float fX, float fY, float fZ, IToolable.ToolType tool) {
        if (world.field_72995_K) {
            return false;
        }
        Tuple.Pair<RecipesCommon.AStack[], RecipesCommon.MetaBlock> result = conversions.get(new Tuple.Pair<IToolable.ToolType, RecipesCommon.MetaBlock>(tool, new RecipesCommon.MetaBlock(this, world.func_72805_g(x, y, z))));
        if (result == null) {
            return false;
        }
        ArrayList<RecipesCommon.AStack> list = new ArrayList<RecipesCommon.AStack>();
        for (RecipesCommon.AStack stack : (RecipesCommon.AStack[])result.key) {
            list.add(stack);
        }
        if (list == null || list.isEmpty() || InventoryUtil.doesPlayerHaveAStacks(player, list, true)) {
            world.func_147465_d(x, y, z, ((RecipesCommon.MetaBlock)result.value).block, ((RecipesCommon.MetaBlock)result.value).meta, 3);
            return true;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void printHook(RenderGameOverlayEvent.Pre event, World world, int x, int y, int z) {
        ItemStack held = Minecraft.func_71410_x().field_71439_g.func_70694_bm();
        if (held == null) {
            return;
        }
        IToolable.ToolType tool = BlockToolConversion.quickLookup(held);
        if (tool == null) {
            return;
        }
        Tuple.Pair<RecipesCommon.AStack[], RecipesCommon.MetaBlock> result = conversions.get(new Tuple.Pair<IToolable.ToolType, RecipesCommon.MetaBlock>(tool, new RecipesCommon.MetaBlock(this, world.func_72805_g(x, y, z))));
        if (result == null) {
            return;
        }
        ArrayList<String> text = new ArrayList<String>();
        text.add(EnumChatFormatting.GOLD + "Requires:");
        ArrayList<RecipesCommon.AStack> materials = new ArrayList<RecipesCommon.AStack>();
        for (RecipesCommon.AStack stack : (RecipesCommon.AStack[])result.key) {
            materials.add(stack);
        }
        List<ItemStack> tools = tool.stacksForDisplay;
        ItemStack displayTool = tools.get((int)(Math.abs(System.currentTimeMillis() / 1000L) % (long)tools.size()));
        text.add(EnumChatFormatting.BLUE + "- " + displayTool.func_82833_r());
        for (RecipesCommon.AStack stack : materials) {
            try {
                ItemStack display = stack.extractForCyclingDisplay(20);
                text.add("- " + display.func_82833_r() + " x" + display.field_77994_a);
            }
            catch (Exception ex) {
                text.add(EnumChatFormatting.RED + "- ERROR");
            }
        }
        if (!materials.isEmpty()) {
            ILookOverlay.printGeneric(event, I18nUtil.resolveKey(this.func_149739_a() + ".name", new Object[0]), 0xFFFF00, 0x404000, text);
        }
    }

    @Override
    public int getSubCount() {
        return this.names != null ? this.names.length + 1 : 1;
    }

    public static IToolable.ToolType quickLookup(ItemStack stack) {
        return IToolable.ToolType.getType(stack);
    }

    public static void registerRecipes() {
        conversions.put(new Tuple.Pair<IToolable.ToolType, RecipesCommon.MetaBlock>(IToolable.ToolType.BOLT, new RecipesCommon.MetaBlock(ModBlocks.watz_end, 0)), new Tuple.Pair<RecipesCommon.AStack[], RecipesCommon.MetaBlock>(new RecipesCommon.AStack[]{new RecipesCommon.ComparableStack(ModItems.bolt_dura_steel, 4)}, new RecipesCommon.MetaBlock(ModBlocks.watz_end, 1)));
        conversions.put(new Tuple.Pair<IToolable.ToolType, RecipesCommon.MetaBlock>(IToolable.ToolType.TORCH, new RecipesCommon.MetaBlock(ModBlocks.fusion_conductor, 0)), new Tuple.Pair<RecipesCommon.AStack[], RecipesCommon.MetaBlock>(new RecipesCommon.AStack[]{new RecipesCommon.OreDictStack(OreDictManager.STEEL.plateCast())}, new RecipesCommon.MetaBlock(ModBlocks.fusion_conductor, 1)));
    }

    public static HashMap<Object[], Object> getRecipes(boolean recipes) {
        if (!bufferedRecipes.isEmpty()) {
            return recipes ? bufferedRecipes : bufferedTools;
        }
        for (Map.Entry<Tuple.Pair<IToolable.ToolType, RecipesCommon.MetaBlock>, Tuple.Pair<RecipesCommon.AStack[], RecipesCommon.MetaBlock>> entry : conversions.entrySet()) {
            ArrayList<RecipesCommon.AStack> list = new ArrayList<RecipesCommon.AStack>();
            for (RecipesCommon.AStack stack : entry.getValue().getKey()) {
                list.add(stack);
            }
            list.add(new RecipesCommon.ComparableStack(entry.getKey().getValue().block, 1, entry.getKey().getValue().meta));
            RecipesCommon.AStack[] inputInstance = list.toArray(new RecipesCommon.AStack[0]);
            bufferedRecipes.put(inputInstance, new ItemStack(entry.getValue().getValue().block, 1, entry.getValue().getValue().meta));
            bufferedTools.put(inputInstance, entry.getKey().getKey().stacksForDisplay.toArray(new ItemStack[0]));
        }
        return recipes ? bufferedRecipes : bufferedTools;
    }
}

