/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.generic;

import com.google.common.collect.HashBiMap;
import com.hbm.blocks.IBlockMultiPass;
import com.hbm.config.WorldConfig;
import com.hbm.inventory.RecipesCommon;
import com.hbm.items.ModItems;
import com.hbm.render.block.RenderBlockMultipass;
import com.hbm.util.ColorUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class BlockMotherOfAllOres
extends BlockContainer
implements IBlockMultiPass {
    public static int override = -1;
    private IIcon[] overlays = new IIcon[10];
    public static HashSet<RecipesCommon.ComparableStack> uniqueItems = new HashSet();
    public static HashBiMap<Integer, RecipesCommon.ComparableStack> itemMap = HashBiMap.create();

    public static void shuffleOverride(Random rand) {
        override = rand.nextInt(uniqueItems.size());
    }

    public static void resetOverride() {
        override = -1;
    }

    public BlockMotherOfAllOres() {
        super(Material.field_151576_e);
        this.func_149658_d("stone");
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityRandomOre();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < uniqueItems.size(); ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityRandomOre) {
            TileEntityRandomOre ore = (TileEntityRandomOre)te;
            return new ItemStack((Block)this, 1, ore.getStackId());
        }
        return new ItemStack(ModItems.nothing);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        TileEntity te;
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (fortune == 16698880 && (te = world.func_147438_o(x, y, z)) instanceof TileEntityRandomOre) {
            TileEntityRandomOre ore = (TileEntityRandomOre)te;
            RecipesCommon.ComparableStack item = ore.getCompStack();
            ret.add(item.toStack());
        }
        return ret;
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        this.func_149690_a(world, x, y, z, meta, 1.0f, 16698880);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        ((TileEntityRandomOre)world.func_147438_o(x, y, z)).setItem(stack.func_77960_j());
        world.func_147471_g(x, y, z);
    }

    public int func_149645_b() {
        return IBlockMultiPass.getRenderType();
    }

    @Override
    public int getPasses() {
        return 2;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        this.field_149761_L = reg.func_94245_a("stone");
        for (int i = 0; i < this.overlays.length; ++i) {
            this.overlays[i] = reg.func_94245_a("hbm:ore_random_" + (i + 1));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        if (RenderBlockMultipass.currentPass == 0) {
            return Blocks.field_150348_b.func_149691_a(0, 0);
        }
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityRandomOre) {
            TileEntityRandomOre ore = (TileEntityRandomOre)te;
            int index = ore.getStackId() % this.overlays.length;
            return this.overlays[index];
        }
        return Blocks.field_150348_b.func_149691_a(0, 0);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (RenderBlockMultipass.currentPass == 0) {
            return Blocks.field_150348_b.func_149691_a(0, 0);
        }
        int index = meta % this.overlays.length;
        return this.overlays[index];
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess world, int x, int y, int z) {
        if (RenderBlockMultipass.currentPass == 0) {
            return 0xFFFFFF;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityRandomOre) {
            TileEntityRandomOre ore = (TileEntityRandomOre)te;
            ItemStack stack = ore.getStack();
            int color = ColorUtil.getAverageColorFromStack(stack);
            color = ColorUtil.amplifyColor(color);
            Color col = new Color(color);
            int r = col.getRed();
            int g = col.getGreen();
            int b = col.getBlue();
            new Color(color);
            float[] hsb = Color.RGBtoHSB(r, g, b, new float[3]);
            if (hsb[1] > 0.0f && hsb[1] < 0.75f) {
                hsb[1] = 0.75f;
            }
            color = Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]);
            return color;
        }
        return super.func_149720_d(world, x, y, z);
    }

    public static void init() {
        if (WorldConfig.enableRandom) {
            for (Object b : Block.field_149771_c.func_148742_b()) {
                Block block = Block.func_149684_b((String)((String)b));
                if (block == null || Item.func_150898_a((Block)block) == null) continue;
                uniqueItems.add(new RecipesCommon.ComparableStack(block));
            }
            for (Object i : Item.field_150901_e.func_148742_b()) {
                Item item = (Item)Item.field_150901_e.func_82594_a((String)i);
                uniqueItems.add(new RecipesCommon.ComparableStack(item));
            }
            for (String i : OreDictionary.getOreNames()) {
                for (ItemStack stack : OreDictionary.getOres((String)i)) {
                    uniqueItems.add(new RecipesCommon.ComparableStack(stack));
                }
            }
        } else {
            uniqueItems.add(new RecipesCommon.ComparableStack(ModItems.nothing));
        }
        int i = 0;
        for (RecipesCommon.ComparableStack stack : uniqueItems) {
            itemMap.put((Object)i++, (Object)stack);
        }
    }

    public static class ItemRandomOreBlock
    extends ItemBlock {
        public ItemRandomOreBlock(Block block) {
            super(block);
            this.func_77627_a(true);
            this.func_77656_e(0);
        }

        public String func_77653_i(ItemStack stack) {
            ItemStack name;
            RecipesCommon.ComparableStack comp = (RecipesCommon.ComparableStack)itemMap.get((Object)stack.func_77960_j());
            ItemStack itemStack = name = comp != null ? comp.toStack() : new ItemStack(ModItems.nothing);
            if (name.func_77960_j() == Short.MAX_VALUE) {
                name.func_77964_b(0);
            }
            return StatCollector.func_74837_a((String)(this.func_77658_a() + ".name"), (Object[])new Object[]{name.func_77973_b().func_77653_i(name)});
        }
    }

    public static class TileEntityRandomOre
    extends TileEntity {
        private RecipesCommon.ComparableStack stack;

        public TileEntityRandomOre() {
            if (override != -1) {
                this.setItem(override);
            }
        }

        public void setItem(int id) {
            RecipesCommon.ComparableStack comp = (RecipesCommon.ComparableStack)itemMap.get((Object)id);
            RecipesCommon.ComparableStack comparableStack = this.stack = comp != null ? (RecipesCommon.ComparableStack)comp.copy() : null;
            if (this.field_145850_b != null) {
                this.field_145850_b.func_147476_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, (TileEntity)this);
            }
        }

        public int getStackId() {
            return (Integer)itemMap.inverse().get((Object)this.getCompStack());
        }

        public ItemStack getStack() {
            return this.getCompStack().toStack();
        }

        public RecipesCommon.ComparableStack getCompStack() {
            if (this.stack == null) {
                int rand = this.field_145850_b.field_73012_v.nextInt(uniqueItems.size());
                this.stack = (RecipesCommon.ComparableStack)((RecipesCommon.ComparableStack)itemMap.get((Object)rand)).copy();
                this.field_145850_b.func_147476_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, (TileEntity)this);
            }
            return this.stack != null ? this.stack : new RecipesCommon.ComparableStack(ModItems.nothing);
        }

        public boolean canUpdate() {
            return false;
        }

        public void func_145839_a(NBTTagCompound nbt) {
            super.func_145839_a(nbt);
            int key = nbt.func_74762_e("item");
            this.setItem(key);
        }

        public void func_145841_b(NBTTagCompound nbt) {
            super.func_145841_b(nbt);
            try {
                Integer key = (Integer)itemMap.inverse().get((Object)this.getCompStack());
                nbt.func_74768_a("item", key != null ? key : 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public Packet func_145844_m() {
            NBTTagCompound nbt = new NBTTagCompound();
            this.func_145841_b(nbt);
            return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbt);
        }

        public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
            this.func_145839_a(pkt.func_148857_g());
        }
    }
}

