/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks;

import com.hbm.blocks.ICustomBlockHighlight;
import com.hbm.handler.MultiblockHandlerXR;
import com.hbm.handler.ThreeInts;
import com.hbm.main.MainRegistry;
import com.hbm.tileentity.IPersistentNBT;
import cpw.mods.fml.common.network.internal.FMLNetworkHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class BlockDummyable
extends BlockContainer
implements ICustomBlockHighlight {
    public static final int offset = 10;
    public static final int extra = 6;
    public static int overrideTileMeta = 0;
    public static boolean safeRem = false;
    List<ThreeInts> positions = new ArrayList<ThreeInts>();
    public List<AxisAlignedBB> bounding = new ArrayList<AxisAlignedBB>();

    public BlockDummyable(Material mat) {
        super(mat);
        this.field_149756_F = 0.999;
        this.func_149675_a(true);
    }

    public static void setOverride(int i) {
        overrideTileMeta = i;
    }

    public static void resetOverride() {
        overrideTileMeta = 0;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        super.func_149695_a(world, x, y, z, block);
        if (world.field_72995_K || safeRem) {
            return;
        }
        int metadata = world.func_72805_g(x, y, z);
        if (metadata >= 6) {
            metadata -= 6;
        }
        ForgeDirection dir = ForgeDirection.getOrientation((int)metadata).getOpposite();
        Block b = world.func_147439_a(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ);
        if (b != this) {
            world.func_147468_f(x, y, z);
        }
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        super.func_149674_a(world, x, y, z, rand);
        if (world.field_72995_K) {
            return;
        }
        int metadata = world.func_72805_g(x, y, z);
        if (metadata >= 6) {
            metadata -= 6;
        }
        ForgeDirection dir = ForgeDirection.getOrientation((int)metadata).getOpposite();
        Block b = world.func_147439_a(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ);
        if (b != this) {
            world.func_147468_f(x, y, z);
        }
    }

    public int[] findCore(World world, int x, int y, int z) {
        this.positions.clear();
        return this.findCoreRec(world, x, y, z);
    }

    public int[] findCoreRec(World world, int x, int y, int z) {
        ThreeInts pos = new ThreeInts(x, y, z);
        int metadata = world.func_72805_g(x, y, z);
        if (metadata >= 6) {
            metadata -= 6;
        }
        if (world.func_147439_a(x, y, z) == this && ForgeDirection.getOrientation((int)metadata) == ForgeDirection.UNKNOWN) {
            return new int[]{x, y, z};
        }
        if (this.positions.contains(pos)) {
            return null;
        }
        ForgeDirection dir = ForgeDirection.getOrientation((int)metadata).getOpposite();
        Block b = world.func_147439_a(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ);
        if (b != this) {
            return null;
        }
        this.positions.add(pos);
        return this.findCoreRec(world, x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack itemStack) {
        if (!(player instanceof EntityPlayer)) {
            return;
        }
        safeRem = true;
        world.func_147468_f(x, y, z);
        safeRem = false;
        EntityPlayer pl = (EntityPlayer)player;
        int i = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        int o = -this.getOffset();
        y += this.getHeightOffset();
        ForgeDirection dir = ForgeDirection.NORTH;
        if (i == 0) {
            dir = ForgeDirection.getOrientation((int)2);
        }
        if (i == 1) {
            dir = ForgeDirection.getOrientation((int)5);
        }
        if (i == 2) {
            dir = ForgeDirection.getOrientation((int)3);
        }
        if (i == 3) {
            dir = ForgeDirection.getOrientation((int)4);
        }
        if (!this.checkRequirement(world, x, y, z, dir = this.getDirModified(dir), o)) {
            if (!pl.field_71075_bZ.field_75098_d) {
                ItemStack stack = pl.field_71071_by.field_70462_a[pl.field_71071_by.field_70461_c];
                Item item = Item.func_150898_a((Block)this);
                if (stack == null) {
                    pl.field_71071_by.field_70462_a[pl.field_71071_by.field_70461_c] = new ItemStack((Block)this);
                } else if (stack.func_77973_b() != item || stack.field_77994_a == stack.func_77976_d()) {
                    pl.field_71071_by.func_70441_a(new ItemStack((Block)this));
                } else {
                    ++pl.func_70694_bm().field_77994_a;
                }
            }
            return;
        }
        if (!world.field_72995_K) {
            int meta = this.getMetaForCore(world, x + dir.offsetX * o, y + dir.offsetY * o, z + dir.offsetZ * o, (EntityPlayer)player, dir.ordinal() + 10);
            world.func_147465_d(x + dir.offsetX * o, y + dir.offsetY * o, z + dir.offsetZ * o, (Block)this, meta, 3);
            IPersistentNBT.restoreData(world, x + dir.offsetX * o, y + dir.offsetY * o, z + dir.offsetZ * o, itemStack);
            this.fillSpace(world, x, y, z, dir, o);
        }
        world.func_147464_a(x, y -= this.getHeightOffset(), z, (Block)this, 1);
        world.func_147464_a(x, y, z, (Block)this, 2);
        super.func_149689_a(world, x, y, z, player, itemStack);
    }

    protected int getMetaForCore(World world, int x, int y, int z, EntityPlayer player, int original) {
        return original;
    }

    protected ForgeDirection getDirModified(ForgeDirection dir) {
        return dir;
    }

    protected boolean checkRequirement(World world, int x, int y, int z, ForgeDirection dir, int o) {
        return MultiblockHandlerXR.checkSpace(world, x + dir.offsetX * o, y + dir.offsetY * o, z + dir.offsetZ * o, this.getDimensions(), x, y, z, dir);
    }

    protected void fillSpace(World world, int x, int y, int z, ForgeDirection dir, int o) {
        MultiblockHandlerXR.fillSpace(world, x + dir.offsetX * o, y + dir.offsetY * o, z + dir.offsetZ * o, this.getDimensions(), (Block)this, dir);
    }

    public void makeExtra(World world, int x, int y, int z) {
        if (world.func_147439_a(x, y, z) != this) {
            return;
        }
        int meta = world.func_72805_g(x, y, z);
        if (meta > 5) {
            return;
        }
        safeRem = true;
        world.func_147465_d(x, y, z, (Block)this, meta + 6, 3);
        safeRem = false;
    }

    public void removeExtra(World world, int x, int y, int z) {
        if (world.func_147439_a(x, y, z) != this) {
            return;
        }
        int meta = world.func_72805_g(x, y, z);
        if (meta <= 5 || meta >= 12) {
            return;
        }
        safeRem = true;
        world.func_147465_d(x, y, z, (Block)this, meta - 6, 3);
        safeRem = false;
    }

    public boolean hasExtra(int meta) {
        return meta > 5 && meta < 12;
    }

    public void func_149749_a(World world, int x, int y, int z, Block b, int i) {
        ISidedInventory sidedinv;
        TileEntity te;
        if (i < 12 && !safeRem) {
            if (i >= 6) {
                i -= 6;
            }
            ForgeDirection d = ForgeDirection.getOrientation((int)i);
            if (world.func_147439_a(x - d.offsetX, y - d.offsetY, z - d.offsetZ) == this) {
                world.func_147468_f(x - d.offsetX, y - d.offsetY, z - d.offsetZ);
            }
        }
        if ((te = world.func_147438_o(x, y, z)) instanceof ISidedInventory && (sidedinv = (ISidedInventory)te) != null) {
            for (int i1 = 0; i1 < sidedinv.func_70302_i_(); ++i1) {
                ItemStack itemstack = sidedinv.func_70301_a(i1);
                if (itemstack == null) continue;
                float f = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                float f1 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                float f2 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                while (itemstack.field_77994_a > 0) {
                    int j1 = world.field_73012_v.nextInt(21) + 10;
                    if (j1 > itemstack.field_77994_a) {
                        j1 = itemstack.field_77994_a;
                    }
                    itemstack.field_77994_a -= j1;
                    EntityItem entityitem = new EntityItem(world, (double)((float)x + f), (double)((float)y + f1), (double)((float)z + f2), new ItemStack(itemstack.func_77973_b(), j1, itemstack.func_77960_j()));
                    if (itemstack.func_77942_o()) {
                        entityitem.func_92059_d().func_77982_d((NBTTagCompound)itemstack.func_77978_p().func_74737_b());
                    }
                    float f3 = 0.05f;
                    entityitem.field_70159_w = (float)world.field_73012_v.nextGaussian() * f3;
                    entityitem.field_70181_x = (float)world.field_73012_v.nextGaussian() * f3 + 0.2f;
                    entityitem.field_70179_y = (float)world.field_73012_v.nextGaussian() * f3;
                    world.func_72838_d((Entity)entityitem);
                }
            }
            world.func_147453_f(x, y, z, b);
        }
        super.func_149749_a(world, x, y, z, b, i);
    }

    public int func_149645_b() {
        return -1;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public abstract int[] getDimensions();

    public abstract int getOffset();

    public int getHeightOffset() {
        return 0;
    }

    protected boolean standardOpenBehavior(World world, int x, int y, int z, EntityPlayer player, int id) {
        if (world.field_72995_K) {
            return true;
        }
        if (!player.func_70093_af()) {
            int[] pos = this.findCore(world, x, y, z);
            if (pos == null) {
                return false;
            }
            FMLNetworkHandler.openGui((EntityPlayer)player, (Object)MainRegistry.instance, (int)id, (World)world, (int)pos[0], (int)pos[1], (int)pos[2]);
            return true;
        }
        return true;
    }

    public void func_149681_a(World world, int x, int y, int z, int meta, EntityPlayer player) {
        if (!player.field_71075_bZ.field_75098_d) {
            this.harvesters.set(player);
            this.func_149697_b(world, x, y, z, meta, 0);
            this.harvesters.set(null);
        }
    }

    public void func_149636_a(World world, EntityPlayer player, int x, int y, int z, int meta) {
        player.func_71064_a(StatList.field_75934_C[BlockDummyable.func_149682_b((Block)this)], 1);
        player.func_71020_j(0.025f);
    }

    public boolean useDetailedHitbox() {
        return !this.bounding.isEmpty();
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB entityBounding, List list, Entity entity) {
        if (!this.useDetailedHitbox()) {
            super.func_149743_a(world, x, y, z, entityBounding, list, entity);
            return;
        }
        int[] pos = this.findCore(world, x, y, z);
        if (pos == null) {
            return;
        }
        x = pos[0];
        y = pos[1];
        z = pos[2];
        for (AxisAlignedBB aabb : this.bounding) {
            AxisAlignedBB boxlet = BlockDummyable.getAABBRotationOffset(aabb, (double)x + 0.5, y, (double)z + 0.5, ForgeDirection.getOrientation((int)(world.func_72805_g(x, y, z) - 10)).getRotation(ForgeDirection.UP));
            if (!entityBounding.func_72326_a(boxlet)) continue;
            list.add(boxlet);
        }
    }

    public static AxisAlignedBB getAABBRotationOffset(AxisAlignedBB aabb, double x, double y, double z, ForgeDirection dir) {
        AxisAlignedBB newBox = null;
        if (dir == ForgeDirection.NORTH) {
            newBox = AxisAlignedBB.func_72330_a((double)aabb.field_72340_a, (double)aabb.field_72338_b, (double)aabb.field_72339_c, (double)aabb.field_72336_d, (double)aabb.field_72337_e, (double)aabb.field_72334_f);
        }
        if (dir == ForgeDirection.EAST) {
            newBox = AxisAlignedBB.func_72330_a((double)(-aabb.field_72334_f), (double)aabb.field_72338_b, (double)aabb.field_72340_a, (double)(-aabb.field_72339_c), (double)aabb.field_72337_e, (double)aabb.field_72336_d);
        }
        if (dir == ForgeDirection.SOUTH) {
            newBox = AxisAlignedBB.func_72330_a((double)(-aabb.field_72336_d), (double)aabb.field_72338_b, (double)(-aabb.field_72334_f), (double)(-aabb.field_72340_a), (double)aabb.field_72337_e, (double)(-aabb.field_72339_c));
        }
        if (dir == ForgeDirection.WEST) {
            newBox = AxisAlignedBB.func_72330_a((double)aabb.field_72339_c, (double)aabb.field_72338_b, (double)(-aabb.field_72336_d), (double)aabb.field_72334_f, (double)aabb.field_72337_e, (double)(-aabb.field_72340_a));
        }
        if (newBox != null) {
            newBox.func_72317_d(x, y, z);
            return newBox;
        }
        return AxisAlignedBB.func_72330_a((double)aabb.field_72340_a, (double)aabb.field_72338_b, (double)aabb.field_72339_c, (double)aabb.field_72336_d, (double)aabb.field_72337_e, (double)aabb.field_72334_f).func_72317_d(x + 0.5, y + 0.5, z + 0.5);
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        if (!this.useDetailedHitbox()) {
            super.func_149719_a(world, x, y, z);
        } else {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.999f, 1.0f);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldDrawHighlight(World world, int x, int y, int z) {
        return !this.bounding.isEmpty();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawHighlight(DrawBlockHighlightEvent event, World world, int x, int y, int z) {
        int[] pos = this.findCore(world, x, y, z);
        if (pos == null) {
            return;
        }
        x = pos[0];
        y = pos[1];
        z = pos[2];
        EntityPlayer player = event.player;
        float interp = event.partialTicks;
        double dX = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)interp;
        double dY = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)interp;
        double dZ = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)interp;
        float exp = 0.002f;
        int meta = world.func_72805_g(x, y, z);
        ICustomBlockHighlight.setup();
        for (AxisAlignedBB aabb : this.bounding) {
            RenderGlobal cfr_ignored_0 = event.context;
            RenderGlobal.func_147590_a((AxisAlignedBB)BlockDummyable.getAABBRotationOffset(aabb.func_72314_b((double)exp, (double)exp, (double)exp), 0.0, 0.0, 0.0, ForgeDirection.getOrientation((int)(meta - 10)).getRotation(ForgeDirection.UP)).func_72325_c((double)x - dX + 0.5, (double)y - dY, (double)z - dZ + 0.5), (int)-1);
        }
        ICustomBlockHighlight.cleanup();
    }
}

