/*
 * Decompiled with CFR 0.152.
 */
package api.hbm.fluid;

import api.hbm.fluid.IFluidConductor;
import api.hbm.fluid.IFluidConnector;
import api.hbm.fluid.IPipeNet;
import com.hbm.inventory.fluid.FluidType;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.TimeZone;
import net.minecraft.tileentity.TileEntity;

public class PipeNet
implements IPipeNet {
    private boolean valid = true;
    private FluidType type;
    private List<IFluidConductor> links = new ArrayList<IFluidConductor>();
    private HashSet<IFluidConnector> subscribers = new HashSet();
    public static List<PipeNet> trackingInstances = null;
    protected BigInteger totalTransfer = BigInteger.ZERO;
    public List<String> debug = new ArrayList<String>();

    public PipeNet(FluidType type) {
        this.type = type;
    }

    @Override
    public void joinNetworks(IPipeNet network) {
        if (network == this) {
            return;
        }
        for (IFluidConductor conductor : network.getLinks()) {
            conductor.setPipeNet(this.type, this);
            this.getLinks().add(conductor);
        }
        network.getLinks().clear();
        for (IFluidConnector connector : network.getSubscribers()) {
            this.subscribe(connector);
        }
        network.destroy();
    }

    @Override
    public List<IFluidConductor> getLinks() {
        return this.links;
    }

    @Override
    public HashSet<IFluidConnector> getSubscribers() {
        return this.subscribers;
    }

    @Override
    public IPipeNet joinLink(IFluidConductor conductor) {
        if (conductor.getPipeNet(this.type) != null) {
            conductor.getPipeNet(this.type).leaveLink(conductor);
        }
        conductor.setPipeNet(this.type, this);
        this.links.add(conductor);
        return this;
    }

    @Override
    public void leaveLink(IFluidConductor conductor) {
        conductor.setPipeNet(this.type, null);
        this.links.remove(conductor);
    }

    @Override
    public void subscribe(IFluidConnector connector) {
        this.subscribers.add(connector);
    }

    @Override
    public void unsubscribe(IFluidConnector connector) {
        this.subscribers.remove(connector);
    }

    @Override
    public boolean isSubscribed(IFluidConnector connector) {
        return this.subscribers.contains(connector);
    }

    @Override
    public long transferFluid(long fill, int pressure) {
        this.subscribers.removeIf(x -> x == null || !(x instanceof TileEntity) || ((TileEntity)x).func_145837_r());
        if (this.subscribers.isEmpty()) {
            return fill;
        }
        trackingInstances = new ArrayList<PipeNet>();
        trackingInstances.add(this);
        ArrayList<IFluidConnector> subList = new ArrayList<IFluidConnector>(this.subscribers);
        return PipeNet.fairTransfer(subList, this.type, pressure, fill);
    }

    public static long fairTransfer(List<IFluidConnector> subList, FluidType type, int pressure, long fill) {
        int i;
        ArrayList<Long> weight = new ArrayList<Long>();
        long totalReq = 0L;
        for (IFluidConnector con : subList) {
            long req = con.getDemand(type, pressure);
            weight.add(req);
            totalReq += req;
        }
        if (totalReq == 0L) {
            return fill;
        }
        long totalGiven = 0L;
        for (i = 0; i < subList.size(); ++i) {
            IFluidConnector con = subList.get(i);
            long req = (Long)weight.get(i);
            double fraction = (double)req / (double)totalReq;
            long given = (long)Math.floor(fraction * (double)fill);
            totalGiven += given - con.transferFluid(type, pressure, given);
            if (trackingInstances == null) continue;
            for (int j = 0; j < trackingInstances.size(); ++j) {
                PipeNet net = trackingInstances.get(j);
                SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss:SSS");
                sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
                PipeNet.log(net, sdf.format(new Date(System.currentTimeMillis())) + " Sending " + given + "mB to " + PipeNet.conToString(con));
            }
        }
        if (trackingInstances != null) {
            for (i = 0; i < trackingInstances.size(); ++i) {
                PipeNet net = trackingInstances.get(i);
                net.totalTransfer = net.totalTransfer.add(BigInteger.valueOf(totalGiven));
            }
        }
        return fill - totalGiven;
    }

    @Override
    public FluidType getType() {
        return this.type;
    }

    @Override
    public void destroy() {
        this.valid = false;
        this.subscribers.clear();
        for (IFluidConductor con : this.links) {
            con.setPipeNet(this.type, null);
        }
        this.links.clear();
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public BigInteger getTotalTransfer() {
        return this.totalTransfer;
    }

    public static void log(PipeNet net, String msg) {
        net.debug.add(msg);
        while (net.debug.size() > 50) {
            net.debug.remove(0);
        }
    }

    public static String conToString(IFluidConnector con) {
        if (con instanceof TileEntity) {
            TileEntity tile = (TileEntity)con;
            return tile.getClass().getSimpleName() + " @ " + tile.field_145851_c + "/" + tile.field_145848_d + "/" + tile.field_145849_e;
        }
        return "" + con;
    }
}

