/*
 * Decompiled with CFR 0.152.
 */
package api.hbm.fluid;

import api.hbm.fluid.IFluidConductor;
import api.hbm.fluid.IFluidConnector;
import api.hbm.fluid.IPipeNet;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.tank.FluidTank;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public interface IFluidUser
extends IFluidConnector {
    default public void sendFluid(FluidTank tank, World world, int x, int y, int z, ForgeDirection dir) {
        this.sendFluid(tank.getTankType(), tank.getPressure(), world, x, y, z, dir);
    }

    default public void sendFluid(FluidType type, int pressure, World world, int x, int y, int z, ForgeDirection dir) {
        IFluidConnector con;
        TileEntity te = world.func_147438_o(x, y, z);
        boolean wasSubscribed = false;
        boolean red = false;
        if (te instanceof IFluidConductor && (con = (IFluidConductor)te).getPipeNet(type) != null && con.getPipeNet(type).isSubscribed(this)) {
            con.getPipeNet(type).unsubscribe(this);
            wasSubscribed = true;
        }
        if (te instanceof IFluidConnector && (con = (IFluidConnector)te).canConnect(type, dir.getOpposite())) {
            long toSend = this.getTotalFluidForSend(type, pressure);
            long transfer = toSend - con.transferFluid(type, pressure, toSend);
            this.removeFluidForTransfer(type, pressure, transfer);
            red = true;
        }
        if (wasSubscribed && te instanceof IFluidConductor && (con = (IFluidConductor)te).getPipeNet(type) != null && !con.getPipeNet(type).isSubscribed(this)) {
            con.getPipeNet(type).subscribe(this);
        }
    }

    public static IPipeNet getPipeNet(World world, int x, int y, int z, FluidType type) {
        IFluidConductor con;
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof IFluidConductor && (con = (IFluidConductor)te).getPipeNet(type) != null) {
            return con.getPipeNet(type);
        }
        return null;
    }

    @Deprecated
    default public void sendFluidToAll(FluidTank tank, TileEntity te) {
        this.sendFluidToAll(tank.getTankType(), tank.getPressure(), te);
    }

    @Deprecated
    default public void sendFluidToAll(FluidType type, int pressure, TileEntity te) {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            this.sendFluid(type, pressure, te.func_145831_w(), te.field_145851_c + dir.offsetX, te.field_145848_d + dir.offsetY, te.field_145849_e + dir.offsetZ, dir);
        }
    }

    default public long getTotalFluidForSend(FluidType type, int pressure) {
        return 0L;
    }

    default public void removeFluidForTransfer(FluidType type, int pressure, long amount) {
    }

    default public void subscribeToAllAround(FluidType type, TileEntity te) {
        this.subscribeToAllAround(type, te.func_145831_w(), te.field_145851_c, te.field_145848_d, te.field_145849_e);
    }

    default public void subscribeToAllAround(FluidType type, World world, int x, int y, int z) {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            this.trySubscribe(type, world, x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ, dir);
        }
    }

    default public void unsubscribeToAllAround(FluidType type, TileEntity te) {
        this.unsubscribeToAllAround(type, te.func_145831_w(), te.field_145851_c, te.field_145848_d, te.field_145849_e);
    }

    default public void unsubscribeToAllAround(FluidType type, World world, int x, int y, int z) {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            this.tryUnsubscribe(type, world, x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ);
        }
    }

    public FluidTank[] getAllTanks();
}

