/*
 * Decompiled with CFR 0.152.
 */
package api.hbm.fluid;

import api.hbm.fluid.IFluidUser;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.tank.FluidTank;

public interface IFluidStandardSender
extends IFluidUser {
    public FluidTank[] getSendingTanks();

    @Override
    default public long getTotalFluidForSend(FluidType type, int pressure) {
        for (FluidTank tank : this.getSendingTanks()) {
            if (tank.getTankType() != type || tank.getPressure() != pressure) continue;
            return tank.getFill();
        }
        return 0L;
    }

    @Override
    default public void removeFluidForTransfer(FluidType type, int pressure, long amount) {
        for (FluidTank tank : this.getSendingTanks()) {
            if (tank.getTankType() != type || tank.getPressure() != pressure) continue;
            tank.setFill(tank.getFill() - (int)amount);
            return;
        }
    }

    @Override
    default public long transferFluid(FluidType type, int pressure, long fluid) {
        return fluid;
    }

    @Override
    default public long getDemand(FluidType type, int pressure) {
        return 0L;
    }
}

