/*
 * Decompiled with CFR 0.152.
 */
package api.hbm.fluid;

import api.hbm.fluid.IFluidUser;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.tank.FluidTank;

public interface IFluidStandardReceiver
extends IFluidUser {
    @Override
    default public long transferFluid(FluidType type, int pressure, long amount) {
        for (FluidTank tank : this.getReceivingTanks()) {
            if (tank.getTankType() != type || tank.getPressure() != pressure) continue;
            tank.setFill(tank.getFill() + (int)amount);
            if (tank.getFill() > tank.getMaxFill()) {
                long overshoot = tank.getFill() - tank.getMaxFill();
                tank.setFill(tank.getMaxFill());
                return overshoot;
            }
            return 0L;
        }
        return amount;
    }

    public FluidTank[] getReceivingTanks();

    @Override
    default public long getDemand(FluidType type, int pressure) {
        for (FluidTank tank : this.getReceivingTanks()) {
            if (tank.getTankType() != type || tank.getPressure() != pressure) continue;
            return tank.getMaxFill() - tank.getFill();
        }
        return 0L;
    }
}

