/*
 * Decompiled with CFR 0.152.
 */
package api.hbm.fluid;

import api.hbm.fluid.IFluidConductor;
import com.hbm.inventory.fluid.FluidType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public interface IFluidConnector {
    public static final boolean particleDebug = false;

    public long transferFluid(FluidType var1, int var2, long var3);

    default public boolean canConnect(FluidType type, ForgeDirection dir) {
        return dir != ForgeDirection.UNKNOWN;
    }

    public long getDemand(FluidType var1, int var2);

    default public void trySubscribe(FluidType type, World world, int x, int y, int z, ForgeDirection dir) {
        TileEntity te = world.func_147438_o(x, y, z);
        boolean red = false;
        if (te instanceof IFluidConductor) {
            IFluidConductor con = (IFluidConductor)te;
            if (!con.canConnect(type, dir)) {
                return;
            }
            if (con.getPipeNet(type) != null && !con.getPipeNet(type).isSubscribed(this)) {
                con.getPipeNet(type).subscribe(this);
            }
            if (con.getPipeNet(type) != null) {
                red = true;
            }
        }
    }

    default public void tryUnsubscribe(FluidType type, World world, int x, int y, int z) {
        IFluidConductor con;
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof IFluidConductor && (con = (IFluidConductor)te).getPipeNet(type) != null && con.getPipeNet(type).isSubscribed(this)) {
            con.getPipeNet(type).unsubscribe(this);
        }
    }
}

