/*
 * Decompiled with CFR 0.152.
 */
package api.hbm.energy;

import api.hbm.energy.IEnergyConductor;
import api.hbm.energy.IEnergyConnector;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public interface IEnergyUser
extends IEnergyConnector {
    public void setPower(long var1);

    @Override
    default public long transferPower(long power) {
        this.setPower(this.getPower() + power);
        if (this.getPower() > this.getMaxPower()) {
            long overshoot = this.getPower() - this.getMaxPower();
            this.setPower(this.getMaxPower());
            return overshoot;
        }
        return 0L;
    }

    default public void sendPower(World world, int x, int y, int z, ForgeDirection dir) {
        IEnergyConnector con;
        TileEntity te = world.func_147438_o(x, y, z);
        boolean wasSubscribed = false;
        boolean red = false;
        if (te instanceof IEnergyConductor && (con = (IEnergyConductor)te).canConnect(dir.getOpposite()) && con.getPowerNet() != null && con.getPowerNet().isSubscribed(this)) {
            con.getPowerNet().unsubscribe(this);
            wasSubscribed = true;
        }
        if (te instanceof IEnergyConnector && (con = (IEnergyConnector)te).canConnect(dir.getOpposite())) {
            long oldPower = this.getPower();
            long transfer = oldPower - con.transferPower(oldPower);
            this.setPower(oldPower - transfer);
            red = true;
        }
        if (wasSubscribed && te instanceof IEnergyConductor && (con = (IEnergyConductor)te).getPowerNet() != null && !con.getPowerNet().isSubscribed(this)) {
            con.getPowerNet().subscribe(this);
        }
    }

    default public void updateStandardConnections(World world, TileEntity te) {
        this.updateStandardConnections(world, te.field_145851_c, te.field_145848_d, te.field_145849_e);
    }

    default public void updateStandardConnections(World world, int x, int y, int z) {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            this.trySubscribe(world, x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ, dir);
        }
    }
}

