/*
 * Decompiled with CFR 0.152.
 */
package api.hbm.energy;

import api.hbm.energy.IEnergyConductor;
import api.hbm.energy.ILoadedTile;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public interface IEnergyConnector
extends ILoadedTile {
    public static final boolean particleDebug = false;

    public long transferPower(long var1);

    default public boolean canConnect(ForgeDirection dir) {
        return dir != ForgeDirection.UNKNOWN;
    }

    public long getPower();

    public long getMaxPower();

    default public long getTransferWeight() {
        return Math.max(this.getMaxPower() - this.getPower(), 0L);
    }

    default public void trySubscribe(World world, int x, int y, int z, ForgeDirection dir) {
        TileEntity te = world.func_147438_o(x, y, z);
        boolean red = false;
        if (te instanceof IEnergyConductor) {
            IEnergyConductor con = (IEnergyConductor)te;
            if (!con.canConnect(dir.getOpposite())) {
                return;
            }
            if (con.getPowerNet() != null && !con.getPowerNet().isSubscribed(this)) {
                con.getPowerNet().subscribe(this);
            }
            if (con.getPowerNet() != null) {
                red = true;
            }
        }
    }

    default public void tryUnsubscribe(World world, int x, int y, int z) {
        IEnergyConductor con;
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof IEnergyConductor && (con = (IEnergyConductor)te).getPowerNet() != null && con.getPowerNet().isSubscribed(this)) {
            con.getPowerNet().unsubscribe(this);
        }
    }

    default public Vec3 getDebugParticlePos() {
        TileEntity te = (TileEntity)this;
        Vec3 vec = Vec3.func_72443_a((double)((double)te.field_145851_c + 0.5), (double)(te.field_145848_d + 1), (double)((double)te.field_145849_e + 0.5));
        return vec;
    }

    default public ConnectionPriority getPriority() {
        return ConnectionPriority.NORMAL;
    }

    public static enum ConnectionPriority {
        LOW,
        NORMAL,
        HIGH;

    }
}

