/*
 * Decompiled with CFR 0.152.
 */
package api.hbm.energy;

import api.hbm.energy.IEnergyConnector;
import api.hbm.energy.IPowerNet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public interface IEnergyConductor
extends IEnergyConnector {
    public IPowerNet getPowerNet();

    public void setPowerNet(IPowerNet var1);

    default public int getIdentity() {
        return IEnergyConductor.getIdentityFromTile((TileEntity)this);
    }

    public static int getIdentityFromTile(TileEntity te) {
        return IEnergyConductor.getIdentityFromPos(te.field_145851_c, te.field_145848_d, te.field_145849_e);
    }

    public static int getIdentityFromPos(int x, int y, int z) {
        int prime = 27644437;
        int result = 1;
        result = 27644437 * result + x;
        result = 27644437 * result + y;
        result = 27644437 * result + z;
        return result;
    }

    default public boolean canReevaluate() {
        return !((TileEntity)this).func_145837_r();
    }

    default public void reevaluate(HashMap<Integer, IEnergyConductor> copy, HashMap<Integer, Integer> proxies) {
        for (int[] pos : this.getConnectionPoints()) {
            Integer newId;
            int newZ;
            int newY;
            int newX = pos[0];
            int id = IEnergyConductor.getIdentityFromPos(newX, newY = pos[1], newZ = pos[2]);
            IEnergyConductor neighbor = copy.get(id);
            if (neighbor == null && (newId = proxies.get(id)) != null) {
                neighbor = copy.get(newId);
            }
            if (neighbor == null || !this.canReevaluate() || !neighbor.canReevaluate() || neighbor.getPowerNet() == null) continue;
            if (this.getPowerNet() == null) {
                neighbor.getPowerNet().joinLink(this);
                continue;
            }
            this.getPowerNet().joinNetworks(neighbor.getPowerNet());
        }
    }

    default public List<int[]> getConnectionPoints() {
        ArrayList<int[]> pos = new ArrayList<int[]>();
        TileEntity tile = (TileEntity)this;
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            int newX = tile.field_145851_c + dir.offsetX;
            int newY = tile.field_145848_d + dir.offsetY;
            int newZ = tile.field_145849_e + dir.offsetZ;
            pos.add(new int[]{newX, newY, newZ});
        }
        return pos;
    }

    @Override
    default public boolean isLoaded() {
        return true;
    }

    @Override
    default public long transferPower(long power) {
        if (this.getPowerNet() == null) {
            return power;
        }
        return this.getPowerNet().transferPower(power);
    }

    default public boolean hasProxies() {
        return false;
    }

    default public List<Integer> getProxies() {
        return new ArrayList<Integer>();
    }
}

