/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.util;

import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.registry.state.DirectionalProperty;
import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.world.block.BlockState;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.OptionalInt;
import javax.annotation.Nullable;

public enum Direction {
    NORTH(Vector3.at(0.0, 0.0, -1.0), Flag.CARDINAL, 3, 1),
    EAST(Vector3.at(1.0, 0.0, 0.0), Flag.CARDINAL, 0, 2),
    SOUTH(Vector3.at(0.0, 0.0, 1.0), Flag.CARDINAL, 1, 3),
    WEST(Vector3.at(-1.0, 0.0, 0.0), Flag.CARDINAL, 2, 0),
    UP(Vector3.at(0.0, 1.0, 0.0), Flag.UPRIGHT, -1, -1),
    DOWN(Vector3.at(0.0, -1.0, 0.0), Flag.UPRIGHT, -1, -1),
    NORTHEAST(Vector3.at(1.0, 0.0, -1.0), Flag.ORDINAL, 7, 8),
    NORTHWEST(Vector3.at(-1.0, 0.0, -1.0), Flag.ORDINAL, 9, 6),
    SOUTHEAST(Vector3.at(1.0, 0.0, 1.0), Flag.ORDINAL, 6, 9),
    SOUTHWEST(Vector3.at(-1.0, 0.0, 1.0), Flag.ORDINAL, 8, 7),
    WEST_NORTHWEST(Vector3.at(-Math.cos(0.39269908169872414), 0.0, -Math.sin(0.39269908169872414)), Flag.SECONDARY_ORDINAL, 18, 14),
    WEST_SOUTHWEST(Vector3.at(-Math.cos(0.39269908169872414), 0.0, Math.sin(0.39269908169872414)), Flag.SECONDARY_ORDINAL, 17, 13),
    NORTH_NORTHWEST(Vector3.at(-Math.sin(0.39269908169872414), 0.0, -Math.cos(0.39269908169872414)), Flag.SECONDARY_ORDINAL, 12, 15),
    NORTH_NORTHEAST(Vector3.at(Math.sin(0.39269908169872414), 0.0, -Math.cos(0.39269908169872414)), Flag.SECONDARY_ORDINAL, 11, 16),
    EAST_NORTHEAST(Vector3.at(Math.cos(0.39269908169872414), 0.0, -Math.sin(0.39269908169872414)), Flag.SECONDARY_ORDINAL, 13, 17),
    EAST_SOUTHEAST(Vector3.at(Math.cos(0.39269908169872414), 0.0, Math.sin(0.39269908169872414)), Flag.SECONDARY_ORDINAL, 14, 18),
    SOUTH_SOUTHEAST(Vector3.at(Math.sin(0.39269908169872414), 0.0, Math.cos(0.39269908169872414)), Flag.SECONDARY_ORDINAL, 15, 12),
    SOUTH_SOUTHWEST(Vector3.at(-Math.sin(0.39269908169872414), 0.0, Math.cos(0.39269908169872414)), Flag.SECONDARY_ORDINAL, 16, 11),
    ASCENDING_NORTH(Vector3.at(0.0, 1.0, -1.0), Flag.ASCENDING_CARDINAL, 21, 19),
    ASCENDING_EAST(Vector3.at(1.0, 1.0, 0.0), Flag.ASCENDING_CARDINAL, 18, 20),
    ASCENDING_SOUTH(Vector3.at(0.0, 1.0, 1.0), Flag.ASCENDING_CARDINAL, 19, 21),
    ASCENDING_WEST(Vector3.at(-1.0, 1.0, 0.0), Flag.ASCENDING_CARDINAL, 20, 18);

    private final Vector3 direction;
    private final int flags;
    private final int left;
    private final int right;
    private final BlockVector3 blockPoint;
    private static final HashMap<String, Direction> map;

    private Direction(Vector3 vector, int flags, int left, int right) {
        this.blockPoint = BlockVector3.at(Math.signum(vector.x()), Math.signum(vector.y()), Math.signum(vector.z()));
        this.direction = vector.normalize();
        this.flags = flags;
        this.left = left;
        this.right = right;
    }

    public static Direction get(CharSequence sequence) {
        return map.get(sequence);
    }

    public Direction getLeft() {
        return this.left != -1 ? Direction.values()[this.left] : this;
    }

    public Direction getRight() {
        return this.right != -1 ? Direction.values()[this.right] : this;
    }

    public double getX() {
        return this.direction.x();
    }

    public double getY() {
        return this.direction.y();
    }

    public double getZ() {
        return this.direction.z();
    }

    public int getBlockX() {
        return this.blockPoint.x();
    }

    public int getBlockY() {
        return this.blockPoint.y();
    }

    public int getBlockZ() {
        return this.blockPoint.z();
    }

    public boolean isCardinal() {
        return (this.flags & Flag.CARDINAL) > 0;
    }

    public boolean isOrdinal() {
        return (this.flags & Flag.ORDINAL) > 0;
    }

    public boolean isSecondaryOrdinal() {
        return (this.flags & Flag.SECONDARY_ORDINAL) > 0;
    }

    public boolean isUpright() {
        return (this.flags & Flag.UPRIGHT) > 0;
    }

    public Vector3 toVector() {
        return this.direction;
    }

    public BlockVector3 toBlockVector() {
        return this.blockPoint;
    }

    @Nullable
    public static Direction findClosest(Vector3 vector, int flags) {
        if ((flags & Flag.UPRIGHT) == 0) {
            vector = vector.withY(0.0);
        }
        vector = vector.normalize();
        Direction closest = null;
        double closestDot = -2.0;
        for (Direction direction : Direction.values()) {
            double dot;
            if ((~flags & direction.flags) > 0 || !((dot = direction.toVector().dot(vector)) >= closestDot)) continue;
            closest = direction;
            closestDot = dot;
        }
        return closest;
    }

    public static List<Direction> valuesOf(int flags) {
        ArrayList<Direction> directions = new ArrayList<Direction>();
        for (Direction direction : Direction.values()) {
            if ((~flags & direction.flags) != 0) continue;
            directions.add(direction);
        }
        return directions;
    }

    public static Optional<Direction> fromRotationIndex(int rotation) {
        switch (rotation) {
            case 0: {
                return Optional.of(SOUTH);
            }
            case 1: {
                return Optional.of(SOUTH_SOUTHWEST);
            }
            case 2: {
                return Optional.of(SOUTHWEST);
            }
            case 3: {
                return Optional.of(WEST_SOUTHWEST);
            }
            case 4: {
                return Optional.of(WEST);
            }
            case 5: {
                return Optional.of(WEST_NORTHWEST);
            }
            case 6: {
                return Optional.of(NORTHWEST);
            }
            case 7: {
                return Optional.of(NORTH_NORTHWEST);
            }
            case 8: {
                return Optional.of(NORTH);
            }
            case 9: {
                return Optional.of(NORTH_NORTHEAST);
            }
            case 10: {
                return Optional.of(NORTHEAST);
            }
            case 11: {
                return Optional.of(EAST_NORTHEAST);
            }
            case 12: {
                return Optional.of(EAST);
            }
            case 13: {
                return Optional.of(EAST_SOUTHEAST);
            }
            case 14: {
                return Optional.of(SOUTHEAST);
            }
            case 15: {
                return Optional.of(SOUTH_SOUTHEAST);
            }
        }
        return Optional.empty();
    }

    public OptionalInt toRotationIndex() {
        switch (this.ordinal()) {
            case 2: {
                return OptionalInt.of(0);
            }
            case 17: {
                return OptionalInt.of(1);
            }
            case 9: {
                return OptionalInt.of(2);
            }
            case 11: {
                return OptionalInt.of(3);
            }
            case 3: {
                return OptionalInt.of(4);
            }
            case 10: {
                return OptionalInt.of(5);
            }
            case 7: {
                return OptionalInt.of(6);
            }
            case 12: {
                return OptionalInt.of(7);
            }
            case 0: {
                return OptionalInt.of(8);
            }
            case 13: {
                return OptionalInt.of(9);
            }
            case 6: {
                return OptionalInt.of(10);
            }
            case 14: {
                return OptionalInt.of(11);
            }
            case 1: {
                return OptionalInt.of(12);
            }
            case 15: {
                return OptionalInt.of(13);
            }
            case 8: {
                return OptionalInt.of(14);
            }
            case 16: {
                return OptionalInt.of(15);
            }
        }
        return OptionalInt.empty();
    }

    public static EnumSet<Direction> getDirections(BlockState state) {
        EnumSet<Direction> directions = EnumSet.noneOf(Direction.class);
        for (Property<?> property : state.getBlockType().getProperties()) {
            if (property instanceof DirectionalProperty) {
                DirectionalProperty dirProp = (DirectionalProperty)property;
                directions.add(state.getState(dirProp));
                continue;
            }
            Object value = state.getState(property);
            if (!(value instanceof String)) {
                Boolean b;
                if (value instanceof Integer) {
                    Integer i = (Integer)value;
                    Direction.fromRotationIndex(i).ifPresent(directions::add);
                    continue;
                }
                if (!(value instanceof Boolean) || !(b = (Boolean)value).booleanValue()) continue;
                try {
                    directions.add(Direction.valueOf(property.getName().toUpperCase(Locale.ROOT)));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                continue;
            }
            String str = (String)value;
            switch (str.toLowerCase(Locale.ROOT)) {
                case "upper": 
                case "ceiling": 
                case "up": 
                case "top": {
                    directions.add(UP);
                    break;
                }
                case "lower": 
                case "floor": 
                case "down": 
                case "bottom": 
                case "y": {
                    directions.add(DOWN);
                    break;
                }
                case "double": 
                case "wall": {
                    break;
                }
                case "south": {
                    directions.add(SOUTH);
                    break;
                }
                case "x": 
                case "east": {
                    directions.add(EAST);
                    break;
                }
                case "z": 
                case "north": {
                    directions.add(NORTH);
                    break;
                }
                case "west": {
                    directions.add(WEST);
                    break;
                }
                case "hinge": {
                    break;
                }
            }
        }
        return directions;
    }

    static {
        map = new HashMap();
        for (Direction dir : Direction.values()) {
            map.put(dir.name(), dir);
            map.put(dir.name().toLowerCase(Locale.ROOT), dir);
        }
    }

    public static final class Flag {
        public static int CARDINAL = 1;
        public static int ORDINAL = 2;
        public static int SECONDARY_ORDINAL = 4;
        public static int UPRIGHT = 8;
        public static int ASCENDING_CARDINAL = 15;
        public static int ALL = CARDINAL | ORDINAL | SECONDARY_ORDINAL | UPRIGHT | ASCENDING_CARDINAL;

        private Flag() {
        }
    }
}

