/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command.tool.brush;

import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.command.tool.brush.Brush;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockTypes;

public class GravityBrush
implements Brush {
    private final boolean fullHeight;

    public GravityBrush(boolean fullHeight) {
        this.fullHeight = fullHeight;
    }

    @Override
    public void build(EditSession editSession, BlockVector3 position, Pattern pattern, double size) throws MaxChangedBlocksException {
        double endY = (double)position.y() + size;
        double startPerformY = Math.max((double)editSession.getMinY(), (double)position.y() - size);
        double startCheckY = this.fullHeight ? (double)editSession.getMinY() : startPerformY;
        for (double x = (double)position.x() + size; x > (double)position.x() - size; x -= 1.0) {
            for (double z = (double)position.z() + size; z > (double)position.z() - size; z -= 1.0) {
                double freeSpot = startCheckY;
                for (double y = startCheckY; y <= endY; y += 1.0) {
                    BlockState block = editSession.getBlock((int)x, (int)y, (int)z);
                    if (block.getBlockType().getMaterial().isAir()) continue;
                    if (y != freeSpot) {
                        editSession.setBlock((int)x, (int)y, (int)z, BlockTypes.AIR.getDefaultState());
                        editSession.setBlock((int)x, (int)freeSpot, (int)z, block);
                    }
                    freeSpot = y + 1.0;
                }
            }
        }
    }
}

