/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_21_5;

import com.fastasyncworldedit.core.util.ReflectionUtils;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_21_5.PaperweightFaweAdapter;
import com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_21_5.PaperweightPlacementStateProcessor;
import com.sk89q.worldedit.world.block.BlockState;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.enginehub.linbus.tree.LinCompoundTag;
import org.enginehub.linbus.tree.LinTag;
import sun.misc.Unsafe;

public class PaperweightLevelProxy
extends ServerLevel {
    protected ServerLevel serverLevel;
    private PaperweightPlacementStateProcessor processor;
    private PaperweightFaweAdapter adapter;

    private PaperweightLevelProxy() {
        super(null, null, null, null, null, null, null, true, 0L, null, true, null, null, null, null);
        throw new IllegalStateException("Cannot be instantiated");
    }

    public static PaperweightLevelProxy getInstance(ServerLevel serverLevel, PaperweightPlacementStateProcessor processor) {
        PaperweightLevelProxy newLevel;
        Unsafe unsafe = ReflectionUtils.getUnsafe();
        try {
            newLevel = (PaperweightLevelProxy)((Object)unsafe.allocateInstance(PaperweightLevelProxy.class));
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        newLevel.processor = processor;
        newLevel.adapter = (PaperweightFaweAdapter)WorldEditPlugin.getInstance().getBukkitImplAdapter();
        newLevel.serverLevel = serverLevel;
        return newLevel;
    }

    @Nullable
    public BlockEntity getBlockEntity(@Nonnull BlockPos blockPos) {
        if (blockPos.getX() == Integer.MAX_VALUE) {
            return null;
        }
        LinCompoundTag tag = this.processor.getTileAt(blockPos.getX(), blockPos.getY(), blockPos.getZ());
        if (tag == null) {
            return null;
        }
        net.minecraft.world.level.block.state.BlockState state = this.adapter.adapt(this.processor.getBlockStateAt(blockPos.getX(), blockPos.getY(), blockPos.getZ()));
        Block block = state.getBlock();
        if (!(block instanceof EntityBlock)) {
            return null;
        }
        EntityBlock entityBlock = (EntityBlock)block;
        BlockEntity tileEntity = entityBlock.newBlockEntity(blockPos, state);
        tileEntity.loadWithComponents((CompoundTag)this.adapter.fromNativeLin((LinTag)tag), (HolderLookup.Provider)this.serverLevel.registryAccess());
        return tileEntity;
    }

    @Nonnull
    public net.minecraft.world.level.block.state.BlockState getBlockState(@Nonnull BlockPos blockPos) {
        if (blockPos.getX() == Integer.MAX_VALUE) {
            return Blocks.AIR.defaultBlockState();
        }
        BlockState state = this.processor.getBlockStateAt(blockPos.getX(), blockPos.getY(), blockPos.getZ());
        return this.adapter.adapt(state);
    }

    @Nonnull
    public FluidState getFluidState(@Nonnull BlockPos pos) {
        if (pos.getX() == Integer.MAX_VALUE) {
            return Fluids.EMPTY.defaultFluidState();
        }
        return this.getBlockState(pos).getFluidState();
    }

    public boolean isWaterAt(@Nonnull BlockPos pos) {
        if (pos.getX() == Integer.MAX_VALUE) {
            return false;
        }
        return this.getBlockState(pos).getFluidState().is(FluidTags.WATER);
    }

    public int getHeight() {
        return this.serverLevel.getHeight();
    }

    public int getMinY() {
        return this.serverLevel.getMinY();
    }

    public int getMaxY() {
        return this.serverLevel.getMaxY();
    }

    public boolean isInsideBuildHeight(int blockY) {
        return this.serverLevel.isInsideBuildHeight(blockY);
    }

    public boolean isOutsideBuildHeight(BlockPos pos) {
        return this.serverLevel.isOutsideBuildHeight(pos);
    }

    public boolean isOutsideBuildHeight(int blockY) {
        return this.serverLevel.isOutsideBuildHeight(blockY);
    }

    public WorldBorder getWorldBorder() {
        return this.serverLevel.getWorldBorder();
    }
}

