/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_21_5;

import com.fastasyncworldedit.bukkit.adapter.FaweAdapter;
import com.fastasyncworldedit.bukkit.adapter.NMSRelighterFactory;
import com.fastasyncworldedit.core.FaweCache;
import com.fastasyncworldedit.core.entity.LazyBaseEntity;
import com.fastasyncworldedit.core.extent.processor.PlacementStateProcessor;
import com.fastasyncworldedit.core.extent.processor.lighting.RelighterFactory;
import com.fastasyncworldedit.core.nbt.FaweCompoundTag;
import com.fastasyncworldedit.core.queue.IBatchProcessor;
import com.fastasyncworldedit.core.queue.IChunkGet;
import com.fastasyncworldedit.core.queue.implementation.packet.ChunkPacket;
import com.fastasyncworldedit.core.util.NbtUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.adapter.BukkitImplAdapter;
import com.sk89q.worldedit.bukkit.adapter.ext.fawe.v1_21_5.PaperweightAdapter;
import com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_21_5.PaperweightBlockMaterial;
import com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_21_5.PaperweightFaweWorldNativeAccess;
import com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_21_5.PaperweightGetBlocks;
import com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_21_5.PaperweightMapChunkUtil;
import com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_21_5.PaperweightPlacementStateProcessor;
import com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_21_5.PaperweightPlatformAdapter;
import com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_21_5.PaperweightPostProcessor;
import com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_21_5.PaperweightStarlightRelighterFactory;
import com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_21_5.regen.PaperweightRegen;
import com.sk89q.worldedit.bukkit.paperlib.PaperLib;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.mask.BlockTypeMask;
import com.sk89q.worldedit.internal.block.BlockStateIdAccess;
import com.sk89q.worldedit.internal.util.LogManagerCompat;
import com.sk89q.worldedit.internal.wna.WorldNativeAccess;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.registry.state.DirectionalProperty;
import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.util.SideEffect;
import com.sk89q.worldedit.util.concurrency.LazyReference;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.world.RegenOptions;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypesCache;
import com.sk89q.worldedit.world.entity.EntityTypes;
import com.sk89q.worldedit.world.item.ItemType;
import com.sk89q.worldedit.world.registry.BlockMaterial;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.WritableRegistry;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.chunk.LevelChunk;
import org.apache.logging.log4j.Logger;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.block.data.CraftBlockData;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.craftbukkit.util.CraftNamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.enginehub.linbus.tree.LinCompoundTag;
import org.enginehub.linbus.tree.LinStringTag;
import org.enginehub.linbus.tree.LinTag;

public final class PaperweightFaweAdapter
extends FaweAdapter<net.minecraft.nbt.Tag, ServerLevel> {
    private static final Logger LOGGER = LogManagerCompat.getLogger();
    private static Method CHUNK_HOLDER_WAS_ACCESSIBLE_SINCE_LAST_SAVE;
    private static final Codec<DataComponentPatch> COMPONENTS_CODEC;
    private final PaperweightMapChunkUtil mapUtil = new PaperweightMapChunkUtil();
    private static final Set<SideEffect> SUPPORTED_SIDE_EFFECTS;

    public PaperweightFaweAdapter() throws NoSuchFieldException, NoSuchMethodException {
        super(new PaperweightAdapter());
    }

    public Function<BlockEntity, FaweCompoundTag> blockEntityToCompoundTag() {
        return blockEntity -> FaweCompoundTag.of((com.google.common.base.Supplier<? extends LinCompoundTag>)((com.google.common.base.Supplier)() -> (LinCompoundTag)this.toNativeLin(blockEntity.saveWithId((HolderLookup.Provider)DedicatedServer.getServer().registryAccess()))));
    }

    public static Property<?> adaptProperty(net.minecraft.world.level.block.state.properties.Property<?> property) {
        net.minecraft.world.level.block.state.properties.Property<?> property2 = property;
        Objects.requireNonNull(property2);
        net.minecraft.world.level.block.state.properties.Property<?> property3 = property2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BooleanProperty.class, IntegerProperty.class, EnumProperty.class}, property3, n)) {
            case 0 -> {
                BooleanProperty booleanProperty = (BooleanProperty)property3;
                yield new com.sk89q.worldedit.registry.state.BooleanProperty(booleanProperty.getName(), (List<Boolean>)ImmutableList.copyOf((Collection)booleanProperty.getPossibleValues()));
            }
            case 1 -> {
                IntegerProperty integerProperty = (IntegerProperty)property3;
                yield new com.sk89q.worldedit.registry.state.IntegerProperty(integerProperty.getName(), (List<Integer>)ImmutableList.copyOf((Collection)integerProperty.getPossibleValues()));
            }
            case 2 -> {
                EnumProperty enumProperty = (EnumProperty)property3;
                if (enumProperty.getValueClass() == Direction.class) {
                    yield new DirectionalProperty(enumProperty.getName(), enumProperty.getPossibleValues().stream().map(rec$ -> ((StringRepresentable)rec$).getSerializedName()).map(s -> s.toUpperCase(Locale.ROOT)).map(com.sk89q.worldedit.util.Direction::valueOf).toList());
                }
                yield new com.sk89q.worldedit.registry.state.EnumProperty(enumProperty.getName(), enumProperty.getPossibleValues().stream().map(rec$ -> ((StringRepresentable)rec$).getSerializedName()).collect(Collectors.toCollection(ArrayList::new)));
            }
            default -> throw new IllegalArgumentException("FastAsyncWorldEdit needs an update to support " + property.getClass().getSimpleName());
        };
    }

    private static String getEntityId(net.minecraft.world.entity.Entity entity) {
        return EntityType.getKey((EntityType)entity.getType()).toString();
    }

    private static boolean readEntityIntoTag(net.minecraft.world.entity.Entity entity, CompoundTag compoundTag) {
        return entity.save(compoundTag);
    }

    @Override
    public BukkitImplAdapter<net.minecraft.nbt.Tag> getParent() {
        return this.parent;
    }

    @Override
    protected void ensureInit() {
        if (!this.initialised) {
            this.init();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean init() {
        if (this.ibdToOrdinal != null && this.ibdToOrdinal[1] != 0) {
            return false;
        }
        this.ibdToOrdinal = new int[BlockTypesCache.states.length];
        this.ordinalToIbdID = new int[this.ibdToOrdinal.length];
        for (int i = 0; i < this.ibdToOrdinal.length; ++i) {
            Field[] blockState = BlockTypesCache.states[i];
            PaperweightBlockMaterial material = (PaperweightBlockMaterial)blockState.getMaterial();
            int id = Block.BLOCK_STATE_REGISTRY.getId((Object)((net.minecraft.world.level.block.state.BlockState)material.getState()));
            char ordinal = blockState.getOrdinalChar();
            this.ibdToOrdinal[id] = ordinal;
            this.ordinalToIbdID[ordinal] = id;
        }
        HashMap<String, List> properties = new HashMap<String, List>();
        try {
            for (Field field : BlockStateProperties.class.getDeclaredFields()) {
                Object obj = field.get(null);
                if (!(obj instanceof net.minecraft.world.level.block.state.properties.Property)) continue;
                net.minecraft.world.level.block.state.properties.Property state = (net.minecraft.world.level.block.state.properties.Property)obj;
                Property<?> property = PaperweightFaweAdapter.adaptProperty(state);
                properties.compute(property.getName().toLowerCase(Locale.ROOT), (k, v) -> {
                    if (v == null) {
                        v = new ArrayList<Property>(Collections.singletonList(property));
                    } else {
                        v.add(property);
                    }
                    return v;
                });
            }
        }
        catch (IllegalAccessException e) {
            LOGGER.error("failed to initialize block states", (Throwable)e);
        }
        finally {
            this.allBlockProperties = ImmutableMap.copyOf(properties);
        }
        this.initialised = true;
        return true;
    }

    @Override
    public Collection<String> getRegisteredDefaultBlockStates() {
        ArrayList<String> states = new ArrayList<String>();
        for (Block block : BuiltInRegistries.BLOCK) {
            states.add(CraftBlockData.fromData((net.minecraft.world.level.block.state.BlockState)block.defaultBlockState()).getAsString());
        }
        return states;
    }

    @Override
    public BlockMaterial getMaterial(BlockType blockType) {
        Block block = this.getBlock(blockType);
        return new PaperweightBlockMaterial(block);
    }

    @Override
    public synchronized BlockMaterial getMaterial(BlockState state) {
        net.minecraft.world.level.block.state.BlockState blockState = ((CraftBlockData)Bukkit.createBlockData((String)state.getAsString())).getState();
        return new PaperweightBlockMaterial(blockState.getBlock(), blockState);
    }

    public Block getBlock(BlockType blockType) {
        return (Block)DedicatedServer.getServer().registryAccess().lookupOrThrow(Registries.BLOCK).getValue(ResourceLocation.fromNamespaceAndPath((String)blockType.getNamespace(), (String)blockType.getResource()));
    }

    @Override
    @Deprecated
    public BlockState getBlock(Location location) {
        Preconditions.checkNotNull((Object)location);
        int x = location.getBlockX();
        int y = location.getBlockY();
        int z = location.getBlockZ();
        ServerLevel handle = this.getServerLevel(location.getWorld());
        LevelChunk chunk = handle.getChunk(x >> 4, z >> 4);
        BlockPos blockPos = new BlockPos(x, y, z);
        net.minecraft.world.level.block.state.BlockState blockData = chunk.getBlockState(blockPos);
        BlockState state = this.adapt(blockData);
        if (state == null) {
            org.bukkit.block.Block bukkitBlock = location.getBlock();
            state = BukkitAdapter.adapt(bukkitBlock.getBlockData());
        }
        return state;
    }

    @Override
    public BaseBlock getFullBlock(Location location) {
        BlockEntity blockEntity;
        Preconditions.checkNotNull((Object)location);
        int x = location.getBlockX();
        int y = location.getBlockY();
        int z = location.getBlockZ();
        ServerLevel handle = this.getServerLevel(location.getWorld());
        LevelChunk chunk = handle.getChunk(x >> 4, z >> 4);
        BlockPos blockPos = new BlockPos(x, y, z);
        net.minecraft.world.level.block.state.BlockState blockData = chunk.getBlockState(blockPos);
        BlockState state = this.adapt(blockData);
        if (state == null) {
            org.bukkit.block.Block bukkitBlock = location.getBlock();
            state = BukkitAdapter.adapt(bukkitBlock.getBlockData());
        }
        if (state.getBlockType().getMaterial().hasContainer() && (blockEntity = chunk.getBlockEntity(blockPos, LevelChunk.EntityCreationType.CHECK)) != null) {
            CompoundTag tag = blockEntity.saveWithId((HolderLookup.Provider)DedicatedServer.getServer().registryAccess());
            return state.toBaseBlock((LinCompoundTag)this.toNativeLin(tag));
        }
        return state.toBaseBlock();
    }

    @Override
    public Set<SideEffect> getSupportedSideEffects() {
        return SUPPORTED_SIDE_EFFECTS;
    }

    @Override
    public WorldNativeAccess<?, ?, ?> createWorldNativeAccess(World world) {
        return new PaperweightFaweWorldNativeAccess(this, new WeakReference<ServerLevel>(this.getServerLevel(world)));
    }

    @Override
    public BaseEntity getEntity(Entity entity) {
        Preconditions.checkNotNull((Object)entity);
        CraftEntity craftEntity = (CraftEntity)entity;
        net.minecraft.world.entity.Entity mcEntity = craftEntity.getHandle();
        String id = PaperweightFaweAdapter.getEntityId(mcEntity);
        com.sk89q.worldedit.world.entity.EntityType type = EntityTypes.get(id);
        Supplier<LinCompoundTag> saveTag = () -> {
            CompoundTag minecraftTag = new CompoundTag();
            if (!PaperweightFaweAdapter.readEntityIntoTag(mcEntity, minecraftTag)) {
                return null;
            }
            LinCompoundTag tag = (LinCompoundTag)this.toNativeLin(minecraftTag);
            Map<String, LinTag<?>> tags = NbtUtils.getLinCompoundTagValues(tag);
            tags.put("Id", LinStringTag.of(id));
            return LinCompoundTag.of(tags);
        };
        return new LazyBaseEntity(type, saveTag);
    }

    @Override
    public Component getRichBlockName(BlockType blockType) {
        return this.parent.getRichBlockName(blockType);
    }

    @Override
    public Component getRichItemName(ItemType itemType) {
        return this.parent.getRichItemName(itemType);
    }

    @Override
    public Component getRichItemName(BaseItemStack itemStack) {
        return this.parent.getRichItemName(itemStack);
    }

    @Override
    public OptionalInt getInternalBlockStateId(BlockState state) {
        PaperweightBlockMaterial material = (PaperweightBlockMaterial)state.getMaterial();
        net.minecraft.world.level.block.state.BlockState mcState = (net.minecraft.world.level.block.state.BlockState)material.getState();
        return OptionalInt.of(Block.BLOCK_STATE_REGISTRY.getId((Object)mcState));
    }

    @Override
    public BlockState adapt(BlockData blockData) {
        CraftBlockData cbd = (CraftBlockData)blockData;
        net.minecraft.world.level.block.state.BlockState ibd = cbd.getState();
        return this.adapt(ibd);
    }

    public BlockState adapt(net.minecraft.world.level.block.state.BlockState blockState) {
        return BlockTypesCache.states[this.adaptToChar(blockState)];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char adaptToChar(net.minecraft.world.level.block.state.BlockState blockState) {
        int id = Block.BLOCK_STATE_REGISTRY.getId((Object)blockState);
        if (this.initialised) {
            return (char)this.ibdToOrdinal[id];
        }
        PaperweightFaweAdapter paperweightFaweAdapter = this;
        synchronized (paperweightFaweAdapter) {
            if (this.initialised) {
                return (char)this.ibdToOrdinal[id];
            }
            try {
                this.init();
                return (char)this.ibdToOrdinal[id];
            }
            catch (ArrayIndexOutOfBoundsException e1) {
                LOGGER.error("Attempted to convert {} with ID {} to char. ibdToOrdinal length: {}. Defaulting to air!", (Object)blockState.getBlock(), (Object)Block.BLOCK_STATE_REGISTRY.getId((Object)blockState), (Object)this.ibdToOrdinal.length, (Object)e1);
                return '\u0001';
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char ibdIDToOrdinal(int id) {
        if (this.initialised) {
            return (char)this.ibdToOrdinal[id];
        }
        PaperweightFaweAdapter paperweightFaweAdapter = this;
        synchronized (paperweightFaweAdapter) {
            if (this.initialised) {
                return (char)this.ibdToOrdinal[id];
            }
            this.init();
            return (char)this.ibdToOrdinal[id];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getIbdToOrdinal() {
        if (this.initialised) {
            return this.ibdToOrdinal;
        }
        PaperweightFaweAdapter paperweightFaweAdapter = this;
        synchronized (paperweightFaweAdapter) {
            if (this.initialised) {
                return this.ibdToOrdinal;
            }
            this.init();
            return this.ibdToOrdinal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int ordinalToIbdID(char ordinal) {
        if (this.initialised) {
            return this.ordinalToIbdID[ordinal];
        }
        PaperweightFaweAdapter paperweightFaweAdapter = this;
        synchronized (paperweightFaweAdapter) {
            if (this.initialised) {
                return this.ordinalToIbdID[ordinal];
            }
            this.init();
            return this.ordinalToIbdID[ordinal];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getOrdinalToIbdID() {
        if (this.initialised) {
            return this.ordinalToIbdID;
        }
        PaperweightFaweAdapter paperweightFaweAdapter = this;
        synchronized (paperweightFaweAdapter) {
            if (this.initialised) {
                return this.ordinalToIbdID;
            }
            this.init();
            return this.ordinalToIbdID;
        }
    }

    @Override
    public <B extends BlockStateHolder<B>> BlockData adapt(B state) {
        PaperweightBlockMaterial material = (PaperweightBlockMaterial)state.getMaterial();
        return material.getBlockData();
    }

    public net.minecraft.world.level.block.state.BlockState adapt(BlockState blockState) {
        return Block.stateById((int)this.getOrdinalToIbdID()[blockState.getOrdinal()]);
    }

    @Override
    public void sendFakeChunk(World world, Player player, ChunkPacket chunkPacket) {
        ServerLevel nmsWorld = this.getServerLevel(world);
        ChunkHolder map = PaperweightPlatformAdapter.getPlayerChunk(nmsWorld, chunkPacket.getChunkX(), chunkPacket.getChunkZ());
        if (map != null && this.wasAccessibleSinceLastSave(map)) {
            boolean flag = false;
            Stream<ServerPlayer> stream = Stream.empty();
            ServerPlayer checkPlayer = player == null ? null : ((CraftPlayer)player).getHandle();
            stream.filter(entityPlayer -> checkPlayer == null || entityPlayer == checkPlayer).forEach(entityPlayer -> {
                ChunkPacket chunkPacket2 = chunkPacket;
                synchronized (chunkPacket2) {
                    ClientboundLevelChunkWithLightPacket nmsPacket = (ClientboundLevelChunkWithLightPacket)chunkPacket.getNativePacket();
                    if (nmsPacket == null) {
                        nmsPacket = (ClientboundLevelChunkWithLightPacket)this.mapUtil.create(this, chunkPacket);
                        chunkPacket.setNativePacket(nmsPacket);
                    }
                    try {
                        ((AtomicBoolean)FaweCache.INSTANCE.CHUNK_FLAG.get()).set(true);
                        entityPlayer.connection.send((Packet)nmsPacket);
                    }
                    finally {
                        ((AtomicBoolean)FaweCache.INSTANCE.CHUNK_FLAG.get()).set(false);
                    }
                }
            });
        }
    }

    @Override
    public Map<String, ? extends Property<?>> getProperties(BlockType blockType) {
        return this.getParent().getProperties(blockType);
    }

    @Override
    public boolean canPlaceAt(World world, BlockVector3 blockVector3, BlockState blockState) {
        int internalId = BlockStateIdAccess.getBlockStateId(blockState);
        net.minecraft.world.level.block.state.BlockState blockState1 = Block.stateById((int)internalId);
        return blockState1.hasPostProcess((BlockGetter)this.getServerLevel(world), new BlockPos(blockVector3.x(), blockVector3.y(), blockVector3.z()));
    }

    @Override
    public ItemStack adapt(BaseItemStack baseItemStack) {
        RegistryAccess.Frozen registryAccess = DedicatedServer.getServer().registryAccess();
        net.minecraft.world.item.ItemStack stack = new net.minecraft.world.item.ItemStack((ItemLike)registryAccess.lookupOrThrow(Registries.ITEM).getValueOrThrow(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)baseItemStack.getType().id()))), baseItemStack.getAmount());
        CompoundTag nbt = (CompoundTag)this.fromNativeLin((LinTag)baseItemStack.getNbt());
        if (nbt != null) {
            DataComponentPatch patch = (DataComponentPatch)COMPONENTS_CODEC.parse((DynamicOps)registryAccess.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)nbt).getOrThrow();
            stack.applyComponents(patch);
        }
        return CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)stack);
    }

    @Override
    protected void preCaptureStates(ServerLevel serverLevel) {
        serverLevel.captureTreeGeneration = true;
        serverLevel.captureBlockStates = true;
    }

    @Override
    protected List<org.bukkit.block.BlockState> getCapturedBlockStatesCopy(ServerLevel serverLevel) {
        return new ArrayList<org.bukkit.block.BlockState>(serverLevel.capturedBlockStates.values());
    }

    @Override
    protected void postCaptureBlockStates(ServerLevel serverLevel) {
        serverLevel.captureBlockStates = false;
        serverLevel.captureTreeGeneration = false;
        serverLevel.capturedBlockStates.clear();
    }

    @Override
    protected ServerLevel getServerLevel(World world) {
        return ((CraftWorld)world).getHandle();
    }

    @Override
    public BaseItemStack adapt(ItemStack itemStack) {
        RegistryAccess.Frozen registryAccess = DedicatedServer.getServer().registryAccess();
        net.minecraft.world.item.ItemStack nmsStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        Supplier<net.minecraft.nbt.Tag> tag = () -> (net.minecraft.nbt.Tag)COMPONENTS_CODEC.encodeStart((DynamicOps)registryAccess.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)nmsStack.getComponentsPatch()).getOrThrow();
        return new BaseItemStack(BukkitAdapter.asItemType(itemStack.getType()), LazyReference.from(() -> (LinCompoundTag)this.toNativeLin((net.minecraft.nbt.Tag)tag.get())), itemStack.getAmount());
    }

    @Override
    public Tag toNative(net.minecraft.nbt.Tag foreign) {
        return this.parent.toNative(foreign);
    }

    @Override
    public net.minecraft.nbt.Tag fromNative(Tag foreign) {
        return (net.minecraft.nbt.Tag)this.parent.fromNative(foreign);
    }

    @Override
    public boolean regenerate(World bukkitWorld, Region region, Extent target, RegenOptions options) throws Exception {
        return new PaperweightRegen(bukkitWorld, region, target, options).regenerate();
    }

    @Override
    public IChunkGet get(World world, int chunkX, int chunkZ) {
        return new PaperweightGetBlocks(world, chunkX, chunkZ);
    }

    @Override
    public int getInternalBiomeId(BiomeType biomeType) {
        Registry registry = MinecraftServer.getServer().registryAccess().lookupOrThrow(Registries.BIOME);
        ResourceLocation resourceLocation = ResourceLocation.tryParse((String)biomeType.id());
        Biome biome = (Biome)registry.getValue(resourceLocation);
        return registry.getId((Object)biome);
    }

    @Override
    public Iterable<NamespacedKey> getRegisteredBiomes() {
        WritableRegistry biomeRegistry = (WritableRegistry)((CraftServer)Bukkit.getServer()).getServer().registryAccess().lookupOrThrow(Registries.BIOME);
        List<ResourceLocation> keys = biomeRegistry.stream().map(arg_0 -> ((WritableRegistry)biomeRegistry).getKey(arg_0)).filter(Objects::nonNull).toList();
        ArrayList<NamespacedKey> namespacedKeys = new ArrayList<NamespacedKey>();
        for (ResourceLocation key : keys) {
            try {
                namespacedKeys.add(CraftNamespacedKey.fromMinecraft((ResourceLocation)key));
            }
            catch (IllegalArgumentException e) {
                LOGGER.error("Error converting biome key {}", (Object)key.toString(), (Object)e);
            }
        }
        return namespacedKeys;
    }

    @Override
    public RelighterFactory getRelighterFactory() {
        if (PaperLib.isPaper()) {
            return new PaperweightStarlightRelighterFactory();
        }
        return new NMSRelighterFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, List<Property<?>>> getAllProperties() {
        if (this.initialised) {
            return this.allBlockProperties;
        }
        PaperweightFaweAdapter paperweightFaweAdapter = this;
        synchronized (paperweightFaweAdapter) {
            if (this.initialised) {
                return this.allBlockProperties;
            }
            this.init();
            return this.allBlockProperties;
        }
    }

    @Override
    public IBatchProcessor getTickingPostProcessor() {
        return new PaperweightPostProcessor();
    }

    @Override
    public PlacementStateProcessor getPlatformPlacementProcessor(Extent extent, BlockTypeMask mask, Region region) {
        return new PaperweightPlacementStateProcessor(extent, mask, region);
    }

    private boolean wasAccessibleSinceLastSave(ChunkHolder holder) {
        if (PaperLib.isPaper()) {
            return true;
        }
        try {
            return (Boolean)CHUNK_HOLDER_WAS_ACCESSIBLE_SINCE_LAST_SAVE.invoke((Object)holder, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException ignored) {
            return false;
        }
    }

    static {
        COMPONENTS_CODEC = DataComponentPatch.CODEC.optionalFieldOf("components", (Object)DataComponentPatch.EMPTY).codec();
        try {
            CHUNK_HOLDER_WAS_ACCESSIBLE_SINCE_LAST_SAVE = ChunkHolder.class.getDeclaredMethod("wasAccessibleSinceLastSave", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        SUPPORTED_SIDE_EFFECTS = Sets.immutableEnumSet((Enum)SideEffect.HISTORY, (Enum[])new SideEffect[]{SideEffect.HEIGHTMAPS, SideEffect.LIGHTING, SideEffect.NEIGHBORS});
    }
}

