/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_20_R4;

import com.fastasyncworldedit.core.configuration.Settings;
import com.fastasyncworldedit.core.extent.processor.ProcessorScope;
import com.fastasyncworldedit.core.queue.IBatchProcessor;
import com.fastasyncworldedit.core.queue.IChunk;
import com.fastasyncworldedit.core.queue.IChunkGet;
import com.fastasyncworldedit.core.queue.IChunkSet;
import com.fastasyncworldedit.core.registry.state.PropertyKey;
import com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_20_R4.PaperweightGetBlocks_Copy;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockTypes;
import com.sk89q.worldedit.world.block.BlockTypesCache;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class PaperweightPostProcessor
implements IBatchProcessor {
    @Override
    public IChunkSet processSet(IChunk chunk, IChunkGet get, IChunkSet set) {
        return set;
    }

    @Override
    public void postProcess(IChunk chunk, IChunkGet iChunkGet, IChunkSet iChunkSet) {
        boolean tickFluid = Settings.settings().EXPERIMENTAL.ALLOW_TICK_FLUIDS;
        if (!tickFluid) {
            return;
        }
        PaperweightGetBlocks_Copy getBlocks = (PaperweightGetBlocks_Copy)iChunkGet;
        block0: for (int layer = iChunkSet.getMinSectionPosition(); layer <= iChunkSet.getMaxSectionPosition(); ++layer) {
            char[] set = iChunkSet.loadIfPresent(layer);
            if (set == null) continue;
            char[] get = null;
            for (int i = 0; i < 4096; ++i) {
                char ordinal = set[i];
                char replacedOrdinal = '\u0000';
                boolean fromGet = false;
                if (ordinal == '\u0000') {
                    if (get == null) {
                        get = getBlocks.load(layer);
                    }
                    if (get == null) continue block0;
                    fromGet = true;
                    ordinal = replacedOrdinal = get[i];
                }
                if (ordinal == '\u0000') continue;
                if (!fromGet) {
                    if (get == null) {
                        get = getBlocks.load(layer);
                    }
                    replacedOrdinal = get[i];
                }
                boolean ticking = BlockTypesCache.ticking[ordinal];
                boolean replacedWasTicking = BlockTypesCache.ticking[replacedOrdinal];
                boolean replacedWasLiquid = false;
                BlockState replacedState = null;
                if (!ticking && (!replacedWasTicking || !(replacedWasLiquid = (replacedState = BlockState.getFromOrdinal(replacedOrdinal)).getMaterial().isLiquid()))) continue;
                BlockState state = BlockState.getFromOrdinal(ordinal);
                boolean liquid = state.getMaterial().isLiquid();
                int x = i & 0xF;
                int y = i >> 8 & 0xF;
                int z = i >> 4 & 0xF;
                BlockPos position = new BlockPos((chunk.getX() << 4) + x, (layer << 4) + y, (chunk.getZ() << 4) + z);
                if (!liquid && !replacedWasLiquid) continue;
                if (liquid) {
                    this.addFluid(getBlocks.serverLevel, state, position);
                    continue;
                }
                if (!this.wasAdjacentToWater(get, set, i, x, y, z)) continue;
                this.addFluid(getBlocks.serverLevel, replacedState, position);
            }
        }
    }

    @Override
    @Nullable
    public Extent construct(Extent child) {
        throw new UnsupportedOperationException("Processing only");
    }

    @Override
    public ProcessorScope getScope() {
        return ProcessorScope.READING_BLOCKS;
    }

    private boolean wasAdjacentToWater(char[] get, char[] set, int i, int x, int y, int z) {
        char ordinal;
        if (set == null || get == null) {
            return false;
        }
        char reserved = '\u0000';
        if (x > 0 && set[i - 1] != reserved && BlockTypesCache.ticking[ordinal = get[i - 1]] && this.isFluid(ordinal)) {
            return true;
        }
        if (x < 15 && set[i + 1] != reserved && BlockTypesCache.ticking[ordinal = get[i + 1]] && this.isFluid(ordinal)) {
            return true;
        }
        if (z > 0 && set[i - 16] != reserved && BlockTypesCache.ticking[ordinal = get[i - 16]] && this.isFluid(ordinal)) {
            return true;
        }
        if (z < 15 && set[i + 16] != reserved && BlockTypesCache.ticking[ordinal = get[i + 16]] && this.isFluid(ordinal)) {
            return true;
        }
        if (y > 0 && set[i - 256] != reserved && BlockTypesCache.ticking[ordinal = get[i - 256]] && this.isFluid(ordinal)) {
            return true;
        }
        if (y < 15 && set[i + 256] != reserved) {
            ordinal = get[i + 256];
            return BlockTypesCache.ticking[ordinal] && this.isFluid(ordinal);
        }
        return false;
    }

    private boolean isFluid(char ordinal) {
        return BlockState.getFromOrdinal(ordinal).getMaterial().isLiquid();
    }

    private void addFluid(ServerLevel serverLevel, BlockState replacedState, BlockPos position) {
        FlowingFluid type = replacedState.getBlockType() == BlockTypes.LAVA ? ((Integer)replacedState.getState(PropertyKey.LEVEL) == 0 ? Fluids.LAVA : Fluids.FLOWING_LAVA) : ((Integer)replacedState.getState(PropertyKey.LEVEL) == 0 ? Fluids.WATER : Fluids.FLOWING_WATER);
        serverLevel.scheduleTick(position, (Fluid)type, type.getTickDelay((LevelReader)serverLevel));
    }
}

