/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_20_R4;

import com.fastasyncworldedit.bukkit.adapter.AbstractBukkitGetBlocks;
import com.fastasyncworldedit.bukkit.adapter.DelegateSemaphore;
import com.fastasyncworldedit.bukkit.adapter.NativeEntityFunctionSet;
import com.fastasyncworldedit.core.FaweCache;
import com.fastasyncworldedit.core.configuration.Settings;
import com.fastasyncworldedit.core.extent.processor.heightmap.HeightMapType;
import com.fastasyncworldedit.core.internal.exception.FaweException;
import com.fastasyncworldedit.core.math.BitArrayUnstretched;
import com.fastasyncworldedit.core.math.IntPair;
import com.fastasyncworldedit.core.nbt.FaweCompoundTag;
import com.fastasyncworldedit.core.queue.IChunkSet;
import com.fastasyncworldedit.core.util.MathMan;
import com.fastasyncworldedit.core.util.NbtUtils;
import com.fastasyncworldedit.core.util.collection.AdaptedMap;
import com.google.common.base.Supplier;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.BukkitEntity;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_20_R4.PaperweightFaweAdapter;
import com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_20_R4.PaperweightGetBlocks_Copy;
import com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_20_R4.PaperweightPlatformAdapter;
import com.sk89q.worldedit.bukkit.paperlib.PaperLib;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.internal.Constants;
import com.sk89q.worldedit.internal.util.LogManagerCompat;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.util.SideEffect;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.biome.BiomeTypes;
import io.papermc.paper.event.block.BeaconDeactivatedEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IdMap;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.BitStorage;
import net.minecraft.util.ZeroBitStorage;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BeaconBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.HashMapPalette;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.LinearPalette;
import net.minecraft.world.level.chunk.Palette;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.levelgen.Heightmap;
import org.apache.logging.log4j.Logger;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.enginehub.linbus.tree.LinCompoundTag;
import org.enginehub.linbus.tree.LinDoubleTag;
import org.enginehub.linbus.tree.LinFloatTag;
import org.enginehub.linbus.tree.LinListTag;
import org.enginehub.linbus.tree.LinStringTag;
import org.enginehub.linbus.tree.LinTag;
import org.enginehub.linbus.tree.LinTagType;

public class PaperweightGetBlocks
extends AbstractBukkitGetBlocks<ServerLevel, LevelChunk> {
    private static final Logger LOGGER = LogManagerCompat.getLogger();
    private static final Function<BlockPos, BlockVector3> posNms2We = v -> BlockVector3.at(v.getX(), v.getY(), v.getZ());
    public static final Function<BlockEntity, FaweCompoundTag> NMS_TO_TILE = ((PaperweightFaweAdapter)WorldEditPlugin.getInstance().getBukkitImplAdapter()).blockEntityToCompoundTag();
    private final PaperweightFaweAdapter adapter = (PaperweightFaweAdapter)WorldEditPlugin.getInstance().getBukkitImplAdapter();
    private final ReadWriteLock sectionLock = new ReentrantReadWriteLock();
    private final Registry<Biome> biomeRegistry;
    private final IdMap<Holder<Biome>> biomeHolderIdMap;
    private final Object sendLock = new Object();
    private LevelChunk levelChunk;
    private LevelChunkSection[] sections;
    private DataLayer[] blockLight;
    private DataLayer[] skyLight = new DataLayer[this.getSectionCount()];
    private boolean lightUpdate = false;

    public PaperweightGetBlocks(World world, int chunkX, int chunkZ) {
        this(((CraftWorld)world).getHandle(), chunkX, chunkZ);
    }

    public PaperweightGetBlocks(ServerLevel serverLevel, int chunkX, int chunkZ) {
        super(serverLevel, chunkX, chunkZ, serverLevel.getMinBuildHeight(), serverLevel.getMaxBuildHeight() - 1);
        this.blockLight = new DataLayer[this.getSectionCount()];
        this.biomeRegistry = serverLevel.registryAccess().registryOrThrow(Registries.BIOME);
        this.biomeHolderIdMap = this.biomeRegistry.asHolderIdMap();
    }

    @Override
    public void setLightingToGet(char[][] light, int minSectionPosition, int maxSectionPosition) {
        if (light != null) {
            this.lightUpdate = true;
            try {
                this.fillLightNibble(light, LightLayer.BLOCK, minSectionPosition, maxSectionPosition);
            }
            catch (Throwable e) {
                LOGGER.error("Error setting lighting to get", e);
            }
        }
    }

    @Override
    public void setSkyLightingToGet(char[][] light, int minSectionPosition, int maxSectionPosition) {
        if (light != null) {
            this.lightUpdate = true;
            try {
                this.fillLightNibble(light, LightLayer.SKY, minSectionPosition, maxSectionPosition);
            }
            catch (Throwable e) {
                LOGGER.error("Error setting sky lighting to get", e);
            }
        }
    }

    @Override
    public void setHeightmapToGet(HeightMapType type, int[] data) {
        BitArrayUnstretched bitArray = new BitArrayUnstretched(MathMan.log2nlz(this.getChunk().getHeight() + 1), 256);
        bitArray.fromRaw(data);
        Heightmap.Types nativeType = Heightmap.Types.valueOf((String)type.name());
        Heightmap heightMap = (Heightmap)this.getChunk().heightmaps.get(nativeType);
        heightMap.setRawData((ChunkAccess)this.getChunk(), nativeType, bitArray.getData());
    }

    @Override
    public BiomeType getBiomeType(int x, int y, int z) {
        LevelChunkSection section = this.getSections(false)[(y >> 4) - this.getMinSectionPosition()];
        Holder biomes = section.getNoiseBiome(x >> 2, (y & 0xF) >> 2, z >> 2);
        return PaperweightPlatformAdapter.adapt((Holder<Biome>)biomes, (LevelAccessor)this.serverLevel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSectionLighting(int layer, boolean sky) {
        SectionPos sectionPos = SectionPos.of((ChunkPos)this.getChunk().getPos(), (int)layer);
        DataLayer dataLayer = ((ServerLevel)this.serverLevel).getChunkSource().getLightEngine().getLayerListener(LightLayer.BLOCK).getDataLayerData(sectionPos);
        if (dataLayer != null) {
            this.lightUpdate = true;
            DataLayer dataLayer2 = dataLayer;
            synchronized (dataLayer2) {
                byte[] bytes = dataLayer.getData();
                Arrays.fill(bytes, (byte)0);
            }
        }
        if (sky) {
            SectionPos sectionPos1 = SectionPos.of((ChunkPos)this.getChunk().getPos(), (int)layer);
            DataLayer dataLayer1 = ((ServerLevel)this.serverLevel).getChunkSource().getLightEngine().getLayerListener(LightLayer.SKY).getDataLayerData(sectionPos1);
            if (dataLayer1 != null) {
                this.lightUpdate = true;
                DataLayer dataLayer3 = dataLayer1;
                synchronized (dataLayer3) {
                    byte[] bytes = dataLayer1.getData();
                    Arrays.fill(bytes, (byte)0);
                }
            }
        }
    }

    @Override
    public FaweCompoundTag tile(int x, int y, int z) {
        BlockEntity blockEntity = this.getChunk().getBlockEntity(new BlockPos((x & 0xF) + (this.chunkX << 4), y, (z & 0xF) + (this.chunkZ << 4)));
        if (blockEntity == null) {
            return null;
        }
        return NMS_TO_TILE.apply(blockEntity);
    }

    @Override
    public Map<BlockVector3, FaweCompoundTag> tiles() {
        Map nmsTiles = this.getChunk().getBlockEntities();
        if (nmsTiles.isEmpty()) {
            return Collections.emptyMap();
        }
        return AdaptedMap.immutable(nmsTiles, posNms2We, NMS_TO_TILE);
    }

    @Override
    public int getSkyLight(int x, int y, int z) {
        int layer = y >> 4;
        int alayer = layer - this.getMinSectionPosition();
        if (this.skyLight[alayer] == null) {
            SectionPos sectionPos = SectionPos.of((ChunkPos)this.getChunk().getPos(), (int)layer);
            DataLayer dataLayer = ((ServerLevel)this.serverLevel).getChunkSource().getLightEngine().getLayerListener(LightLayer.SKY).getDataLayerData(sectionPos);
            if (dataLayer == null) {
                byte[] LAYER_COUNT = new byte[2048];
                Arrays.fill(LAYER_COUNT, (byte)15);
                dataLayer = new DataLayer(LAYER_COUNT);
                ((ServerLevel)this.serverLevel).getChunkSource().getLightEngine().queueSectionData(LightLayer.BLOCK, sectionPos, dataLayer);
            }
            this.skyLight[alayer] = dataLayer;
        }
        return this.skyLight[alayer].get(x & 0xF, y & 0xF, z & 0xF);
    }

    @Override
    public int getEmittedLight(int x, int y, int z) {
        int layer = y >> 4;
        int alayer = layer - this.getMinSectionPosition();
        if (this.blockLight[alayer] == null) {
            ((ServerLevel)this.serverLevel).getRawBrightness(new BlockPos(1, 1, 1), 5);
            SectionPos sectionPos = SectionPos.of((ChunkPos)this.getChunk().getPos(), (int)layer);
            DataLayer dataLayer = ((ServerLevel)this.serverLevel).getChunkSource().getLightEngine().getLayerListener(LightLayer.BLOCK).getDataLayerData(sectionPos);
            if (dataLayer == null) {
                byte[] LAYER_COUNT = new byte[2048];
                Arrays.fill(LAYER_COUNT, (byte)15);
                dataLayer = new DataLayer(LAYER_COUNT);
                ((ServerLevel)this.serverLevel).getChunkSource().getLightEngine().queueSectionData(LightLayer.BLOCK, sectionPos, dataLayer);
            }
            this.blockLight[alayer] = dataLayer;
        }
        return this.blockLight[alayer].get(x & 0xF, y & 0xF, z & 0xF);
    }

    @Override
    public int[] getHeightMap(HeightMapType type) {
        long[] longArray = ((Heightmap)this.getChunk().heightmaps.get(Heightmap.Types.valueOf((String)type.name()))).getRawData();
        BitArrayUnstretched bitArray = new BitArrayUnstretched(9, 256, longArray);
        return bitArray.toRaw(new int[256]);
    }

    @Override
    @Nullable
    public FaweCompoundTag entity(UUID uuid) {
        List<net.minecraft.world.entity.Entity> entities = PaperweightPlatformAdapter.getEntities(this.getChunk());
        net.minecraft.world.entity.Entity entity = null;
        for (net.minecraft.world.entity.Entity e : entities) {
            if (!e.getUUID().equals(uuid)) continue;
            entity = e;
            break;
        }
        if (entity != null) {
            CraftEntity bukkitEnt = entity.getBukkitEntity();
            return FaweCompoundTag.of(BukkitAdapter.adapt((org.bukkit.entity.Entity)bukkitEnt).getState().getNbt());
        }
        for (FaweCompoundTag tag : this.entities()) {
            if (!uuid.equals(NbtUtils.uuid(tag))) continue;
            return tag;
        }
        return null;
    }

    @Override
    public Collection<FaweCompoundTag> entities() {
        List<net.minecraft.world.entity.Entity> entities = PaperweightPlatformAdapter.getEntities(this.getChunk());
        if (entities.isEmpty()) {
            return Collections.emptyList();
        }
        return new NativeEntityFunctionSet<net.minecraft.world.entity.Entity, FaweCompoundTag>(entities, net.minecraft.world.entity.Entity::getUUID, e -> {
            CompoundTag tag = new CompoundTag();
            e.save(tag);
            return FaweCompoundTag.of((Supplier<? extends LinCompoundTag>)((Supplier)() -> (LinCompoundTag)this.adapter.toNativeLin(tag)));
        });
    }

    @Override
    public Set<Entity> getFullEntities() {
        List<net.minecraft.world.entity.Entity> entities = PaperweightPlatformAdapter.getEntities(this.getChunk());
        if (entities.isEmpty()) {
            return Collections.emptySet();
        }
        return new NativeEntityFunctionSet<net.minecraft.world.entity.Entity, Entity>(entities, net.minecraft.world.entity.Entity::getUUID, e -> new BukkitEntity((org.bukkit.entity.Entity)e.getBukkitEntity()));
    }

    private void removeEntity(net.minecraft.world.entity.Entity entity) {
        entity.discard();
    }

    @Override
    public CompletableFuture<LevelChunk> ensureLoaded(ServerLevel nmsWorld) {
        return PaperweightPlatformAdapter.ensureLoaded(nmsWorld, this.chunkX, this.chunkZ);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected <T extends Future<T>> T internalCall(IChunkSet set, Runnable finalizer, int copyKey, LevelChunk nmsChunk, ServerLevel nmsWorld) throws Exception {
        PaperweightGetBlocks_Copy copy;
        PaperweightGetBlocks_Copy paperweightGetBlocks_Copy = copy = this.createCopy ? new PaperweightGetBlocks_Copy(nmsChunk) : null;
        if (this.createCopy) {
            if (this.copies.containsKey(copyKey)) {
                throw new IllegalStateException("Copy key already used.");
            }
            this.copies.put(copyKey, copy);
        }
        HashMap chunkTiles = new HashMap(nmsChunk.getBlockEntities());
        ArrayList<BlockEntity> beacons = null;
        if (!chunkTiles.isEmpty()) {
            for (Map.Entry entry : chunkTiles.entrySet()) {
                int ordinal;
                BlockPos pos = (BlockPos)entry.getKey();
                int lx = pos.getX() & 0xF;
                int ly = pos.getY();
                int lz = pos.getZ() & 0xF;
                int layer = ly >> 4;
                if (!set.hasSection(layer) || (ordinal = set.getBlock(lx, ly, lz).getOrdinal()) == 0) continue;
                BlockEntity tile = (BlockEntity)entry.getValue();
                if (PaperLib.isPaper() && tile instanceof BeaconBlockEntity) {
                    if (beacons == null) {
                        beacons = new ArrayList<BlockEntity>();
                    }
                    beacons.add(tile);
                    PaperweightPlatformAdapter.removeBeacon(tile, nmsChunk);
                    continue;
                }
                nmsChunk.removeBlockEntity(tile.getBlockPos());
                if (!this.createCopy) continue;
                copy.storeTile(tile);
            }
        }
        BiomeType[][] biomes = set.getBiomes();
        int bitMask = 0;
        LevelChunk levelChunk = nmsChunk;
        synchronized (levelChunk) {
            Runnable callback;
            Map<BlockVector3, FaweCompoundTag> tiles;
            Collection<FaweCompoundTag> entities;
            Set<UUID> entityRemoves;
            LevelChunkSection[] levelChunkSections = nmsChunk.getSections();
            for (int layerNo = this.getMinSectionPosition(); layerNo <= this.getMaxSectionPosition(); ++layerNo) {
                PalettedContainer<Holder<Biome>> paletteBiomes;
                LevelChunkSection newSection;
                int getSectionIndex = layerNo - this.getMinSectionPosition();
                int setSectionIndex = layerNo - set.getMinSectionPosition();
                if (!set.hasSection(layerNo)) {
                    if (biomes == null || layerNo < set.getMinSectionPosition() || layerNo > set.getMaxSectionPosition() || biomes[setSectionIndex] == null) continue;
                    Object ordinal = this.sectionLocks[getSectionIndex];
                    synchronized (ordinal) {
                        LevelChunkSection existingSection = levelChunkSections[getSectionIndex];
                        if (this.createCopy && existingSection != null) {
                            copy.storeBiomes(getSectionIndex, (PalettedContainerRO<Holder<Biome>>)existingSection.getBiomes());
                        }
                        if (existingSection == null) {
                            PalettedContainer<Holder<Biome>> biomeData = PaperweightPlatformAdapter.getBiomePalettedContainer(biomes[setSectionIndex], this.biomeHolderIdMap);
                            newSection = PaperweightPlatformAdapter.newChunkSection(layerNo, new char[4096], this.adapter, this.biomeRegistry, biomeData);
                            if (PaperweightPlatformAdapter.setSectionAtomic(nmsWorld.getWorld().getName(), this.chunkPos, levelChunkSections, null, newSection, getSectionIndex)) {
                                this.updateGet(nmsChunk, levelChunkSections, newSection, new char[4096], getSectionIndex);
                                continue;
                            }
                            existingSection = levelChunkSections[getSectionIndex];
                            if (existingSection == null) {
                                LOGGER.error("Skipping invalid null section. chunk: {}, {} layer: {}", (Object)this.chunkX, (Object)this.chunkZ, (Object)getSectionIndex);
                            }
                        } else {
                            paletteBiomes = this.setBiomesToPalettedContainer(biomes, setSectionIndex, (PalettedContainerRO<Holder<Biome>>)existingSection.getBiomes());
                            if (paletteBiomes != null) {
                                PaperweightPlatformAdapter.setBiomesToChunkSection(existingSection, paletteBiomes);
                            }
                        }
                        continue;
                    }
                }
                bitMask |= 1 << getSectionIndex;
                char[] tmp = set.load(layerNo);
                char[] setArr = new char[tmp.length];
                System.arraycopy(tmp, 0, setArr, 0, tmp.length);
                paletteBiomes = this.sectionLocks[getSectionIndex];
                synchronized (paletteBiomes) {
                    DelegateSemaphore lock;
                    LevelChunkSection existingSection = levelChunkSections[getSectionIndex];
                    if (existingSection != null) {
                        PaperweightPlatformAdapter.clearCounts(existingSection);
                        if (PaperLib.isPaper()) {
                            existingSection.tickingList.clear();
                        }
                    }
                    if (this.createCopy) {
                        char[] tmpLoad = this.load(layerNo);
                        char[] copyArr = new char[4096];
                        System.arraycopy(tmpLoad, 0, copyArr, 0, 4096);
                        copy.storeSection(getSectionIndex, copyArr);
                        if (biomes != null && existingSection != null) {
                            copy.storeBiomes(getSectionIndex, (PalettedContainerRO<Holder<Biome>>)existingSection.getBiomes());
                        }
                    }
                    if (existingSection == null) {
                        PalettedContainer biomeData = biomes == null ? new PalettedContainer(this.biomeHolderIdMap, (Object)((Holder)this.biomeHolderIdMap.byIdOrThrow(this.adapter.getInternalBiomeId(BiomeTypes.PLAINS))), PalettedContainer.Strategy.SECTION_BIOMES) : PaperweightPlatformAdapter.getBiomePalettedContainer(biomes[setSectionIndex], this.biomeHolderIdMap);
                        newSection = PaperweightPlatformAdapter.newChunkSection(layerNo, setArr, this.adapter, this.biomeRegistry, (PalettedContainer<Holder<Biome>>)biomeData);
                        if (PaperweightPlatformAdapter.setSectionAtomic(nmsWorld.getWorld().getName(), this.chunkPos, levelChunkSections, null, newSection, getSectionIndex)) {
                            this.updateGet(nmsChunk, levelChunkSections, newSection, setArr, getSectionIndex);
                            continue;
                        }
                        existingSection = levelChunkSections[getSectionIndex];
                        if (existingSection == null) {
                            LOGGER.error("Skipping invalid null section. chunk: {}, {} layer: {}", (Object)this.chunkX, (Object)this.chunkZ, (Object)getSectionIndex);
                            continue;
                        }
                    }
                    PaperweightPlatformAdapter.clearCounts(existingSection);
                    if (PaperLib.isPaper()) {
                        existingSection.tickingList.clear();
                    }
                    DelegateSemaphore delegateSemaphore = lock = PaperweightPlatformAdapter.applyLock(existingSection);
                    synchronized (delegateSemaphore) {
                        lock.acquire();
                        lock.release();
                        try {
                            this.sectionLock.writeLock().lock();
                            if (this.getChunk() != nmsChunk) {
                                this.levelChunk = nmsChunk;
                                this.sections = null;
                                this.reset();
                            } else if (existingSection != this.getSections(false)[getSectionIndex]) {
                                this.sections[getSectionIndex] = existingSection;
                                this.reset();
                            } else if (!Arrays.equals(this.update(getSectionIndex, new char[4096], true), this.load(layerNo))) {
                                this.reset(layerNo);
                            }
                        }
                        finally {
                            this.sectionLock.writeLock().unlock();
                        }
                        PalettedContainer biomeData = this.setBiomesToPalettedContainer(biomes, setSectionIndex, (PalettedContainerRO<Holder<Biome>>)existingSection.getBiomes());
                        newSection = PaperweightPlatformAdapter.newChunkSection(layerNo, this::load, setArr, this.adapter, this.biomeRegistry, biomeData != null ? biomeData : (PalettedContainer)existingSection.getBiomes());
                        if (!PaperweightPlatformAdapter.setSectionAtomic(nmsWorld.getWorld().getName(), this.chunkPos, levelChunkSections, existingSection, newSection, getSectionIndex)) {
                            LOGGER.error("Skipping invalid null section. chunk: {}, {} layer: {}", (Object)this.chunkX, (Object)this.chunkZ, (Object)getSectionIndex);
                        } else {
                            this.updateGet(nmsChunk, levelChunkSections, newSection, setArr, getSectionIndex);
                        }
                    }
                }
            }
            Map<HeightMapType, int[]> heightMaps = set.getHeightMaps();
            for (Map.Entry<HeightMapType, int[]> entry : heightMaps.entrySet()) {
                this.setHeightmapToGet(entry.getKey(), entry.getValue());
            }
            this.setLightingToGet(set.getLight(), set.getMinSectionPosition(), set.getMaxSectionPosition());
            this.setSkyLightingToGet(set.getSkyLight(), set.getMinSectionPosition(), set.getMaxSectionPosition());
            Runnable[] syncTasks = null;
            int bx = this.chunkX << 4;
            int bz = this.chunkZ << 4;
            if (beacons != null && !beacons.isEmpty()) {
                ArrayList<BlockEntity> finalBeacons = beacons;
                syncTasks = new Runnable[4];
                syncTasks[3] = () -> {
                    for (BlockEntity beacon : finalBeacons) {
                        BeaconBlockEntity.playSound((Level)beacon.getLevel(), (BlockPos)beacon.getBlockPos(), (SoundEvent)SoundEvents.BEACON_DEACTIVATE);
                        new BeaconDeactivatedEvent((Block)CraftBlock.at((LevelAccessor)beacon.getLevel(), (BlockPos)beacon.getBlockPos())).callEvent();
                    }
                };
            }
            if ((entityRemoves = set.getEntityRemoves()) != null && !entityRemoves.isEmpty()) {
                if (syncTasks == null) {
                    syncTasks = new Runnable[3];
                }
                syncTasks[2] = () -> {
                    HashSet<UUID> entitiesRemoved = new HashSet<UUID>();
                    List<net.minecraft.world.entity.Entity> entities = PaperweightPlatformAdapter.getEntities(nmsChunk);
                    for (net.minecraft.world.entity.Entity entity : entities) {
                        UUID uuid = entity.getUUID();
                        if (!entityRemoves.contains(uuid)) continue;
                        if (this.createCopy) {
                            copy.storeEntity(entity);
                        }
                        this.removeEntity(entity);
                        entitiesRemoved.add(uuid);
                        entityRemoves.remove(uuid);
                    }
                    if (Settings.settings().EXPERIMENTAL.REMOVE_ENTITY_FROM_WORLD_ON_CHUNK_FAIL) {
                        for (UUID uuid : entityRemoves) {
                            net.minecraft.world.entity.Entity entity = (net.minecraft.world.entity.Entity)nmsWorld.getEntities().get(uuid);
                            if (entity == null) continue;
                            this.removeEntity(entity);
                        }
                    }
                    set.getEntityRemoves().clear();
                    set.getEntityRemoves().addAll(entitiesRemoved);
                };
            }
            if ((entities = set.entities()) != null && !entities.isEmpty()) {
                if (syncTasks == null) {
                    syncTasks = new Runnable[2];
                }
                syncTasks[1] = () -> {
                    Iterator iterator = entities.iterator();
                    while (iterator.hasNext()) {
                        net.minecraft.world.entity.Entity entity;
                        FaweCompoundTag nativeTag = (FaweCompoundTag)iterator.next();
                        LinCompoundTag linTag = nativeTag.linTag();
                        LinStringTag idTag = linTag.findTag("Id", LinTagType.stringTag());
                        LinListTag<LinDoubleTag> posTag = linTag.findListTag("Pos", LinTagType.doubleTag());
                        LinListTag<LinFloatTag> rotTag = linTag.findListTag("Rotation", LinTagType.floatTag());
                        if (idTag == null || posTag == null || rotTag == null) {
                            LOGGER.error("Unknown entity tag: {}", (Object)nativeTag);
                            continue;
                        }
                        double x = posTag.get(0).valueAsDouble();
                        double y = posTag.get(1).valueAsDouble();
                        double z = posTag.get(2).valueAsDouble();
                        float yaw = rotTag.get(0).valueAsFloat();
                        float pitch = rotTag.get(1).valueAsFloat();
                        String id = idTag.value();
                        EntityType type = EntityType.byString((String)id).orElse(null);
                        if (type == null || (entity = type.create((Level)nmsWorld)) == null) continue;
                        CompoundTag tag = (CompoundTag)this.adapter.fromNativeLin((LinTag)linTag);
                        for (String name : Constants.NO_COPY_ENTITY_NBT_FIELDS) {
                            tag.remove(name);
                        }
                        entity.load(tag);
                        entity.absMoveTo(x, y, z, yaw, pitch);
                        entity.setUUID(NbtUtils.uuid(nativeTag));
                        if (nmsWorld.addFreshEntity(entity, CreatureSpawnEvent.SpawnReason.CUSTOM)) continue;
                        LOGGER.warn("Error creating entity of type `{}` in world `{}` at location `{},{},{}`", (Object)id, (Object)nmsWorld.getWorld().getName(), (Object)x, (Object)y, (Object)z);
                        iterator.remove();
                    }
                };
            }
            if ((tiles = set.tiles()) != null && !tiles.isEmpty() && syncTasks == null) {
                syncTasks = new Runnable[]{() -> {
                    for (Map.Entry entry : tiles.entrySet()) {
                        FaweCompoundTag nativeTag = (FaweCompoundTag)entry.getValue();
                        BlockVector3 blockHash = (BlockVector3)entry.getKey();
                        int x = blockHash.x() + bx;
                        int y = blockHash.y();
                        int z = blockHash.z() + bz;
                        BlockPos pos = new BlockPos(x, y, z);
                        ServerLevel serverLevel = nmsWorld;
                        synchronized (serverLevel) {
                            BlockEntity tileEntity = nmsWorld.getBlockEntity(pos);
                            if (tileEntity == null || tileEntity.isRemoved()) {
                                nmsWorld.removeBlockEntity(pos);
                                tileEntity = nmsWorld.getBlockEntity(pos);
                            }
                            if (tileEntity != null) {
                                CompoundTag tag = (CompoundTag)this.adapter.fromNativeLin((LinTag)nativeTag.linTag());
                                tag.put("x", (Tag)IntTag.valueOf((int)x));
                                tag.put("y", (Tag)IntTag.valueOf((int)y));
                                tag.put("z", (Tag)IntTag.valueOf((int)z));
                                tileEntity.loadWithComponents(tag, (HolderLookup.Provider)DedicatedServer.getServer().registryAccess());
                            }
                        }
                    }
                }};
            }
            if (bitMask == 0 && biomes == null && !this.lightUpdate) {
                callback = null;
            } else {
                int finalMask = bitMask != 0 ? bitMask : (this.lightUpdate ? set.getBitMask() : 0);
                callback = () -> {
                    nmsChunk.setLightCorrect(true);
                    nmsChunk.mustNotSave = false;
                    nmsChunk.setUnsaved(true);
                    if (!set.getSideEffectSet().shouldApply(SideEffect.LIGHTING) || !Settings.settings().LIGHTING.DELAY_PACKET_SENDING || finalMask == 0 && biomes != null) {
                        this.send();
                    }
                    if (finalizer != null) {
                        finalizer.run();
                    }
                };
            }
            return this.handleCallFinalizer(syncTasks, callback, finalizer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateGet(LevelChunk nmsChunk, LevelChunkSection[] chunkSections, LevelChunkSection section, char[] arr, int layer) {
        try {
            this.sectionLock.writeLock().lock();
            if (this.getChunk() != nmsChunk) {
                this.levelChunk = nmsChunk;
                this.sections = new LevelChunkSection[chunkSections.length];
                System.arraycopy(chunkSections, 0, this.sections, 0, chunkSections.length);
                this.reset();
            }
            if (this.sections == null) {
                this.sections = new LevelChunkSection[chunkSections.length];
                System.arraycopy(chunkSections, 0, this.sections, 0, chunkSections.length);
            }
            if (this.sections[layer] != section) {
                this.sections[layer] = ((LevelChunkSection[])new LevelChunkSection[]{section}.clone())[0];
            }
        }
        finally {
            this.sectionLock.writeLock().unlock();
        }
        this.blocks[layer] = arr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send() {
        Object object = this.sendLock;
        synchronized (object) {
            PaperweightPlatformAdapter.sendChunk(new IntPair(this.chunkX, this.chunkZ), (ServerLevel)this.serverLevel, this.chunkX, this.chunkZ);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public char[] update(int layer, char[] data, boolean aggressive) {
        DelegateSemaphore lock;
        LevelChunkSection section = this.getSections(aggressive)[layer];
        if (section == null) {
            data = new char[4096];
            Arrays.fill(data, '\u0001');
            return data;
        }
        if (data == null || data == FaweCache.INSTANCE.EMPTY_CHAR_4096 || data.length != 4096) {
            data = new char[4096];
        }
        DelegateSemaphore delegateSemaphore = lock = PaperweightPlatformAdapter.applyLock(section);
        // MONITORENTER : delegateSemaphore
        try {
            ((Semaphore)lock).acquire();
            PalettedContainer blocks = section.getStates();
            Object dataObject = PaperweightPlatformAdapter.fieldData.get(blocks);
            BitStorage bits = (BitStorage)PaperweightPlatformAdapter.fieldStorage.get(dataObject);
            if (bits instanceof ZeroBitStorage) {
                Arrays.fill(data, this.adapter.adaptToChar((BlockState)blocks.get(0, 0, 0)));
                char[] cArray = data;
                return cArray;
            }
            Palette palette = (Palette)PaperweightPlatformAdapter.fieldPalette.get(dataObject);
            int bitsPerEntry = bits.getBits();
            long[] blockStates = bits.getRaw();
            new BitArrayUnstretched(bitsPerEntry, 4096, blockStates).toRaw(data);
            if (!(palette instanceof LinearPalette) && !(palette instanceof HashMapPalette)) {
                this.adapter.mapFromGlobalPalette(data);
                char[] cArray = data;
                return cArray;
            }
            int num_palette = palette.getSize();
            char[] paletteToOrdinal = (char[])FaweCache.INSTANCE.PALETTE_TO_BLOCK_CHAR.get();
            try {
                if (num_palette == 1) {
                    char ordinal = this.ordinal((BlockState)palette.valueFor(0), this.adapter);
                    Arrays.fill(data, ordinal);
                } else {
                    for (int i = 0; i < num_palette; ++i) {
                        char ordinal;
                        paletteToOrdinal[i] = ordinal = this.ordinal((BlockState)palette.valueFor(i), this.adapter);
                    }
                    this.adapter.mapWithPalette(data, paletteToOrdinal);
                }
            }
            finally {
                Arrays.fill(paletteToOrdinal, 0, num_palette, '\uffff');
            }
            char[] cArray = data;
            return cArray;
        }
        catch (IllegalAccessException | InterruptedException e) {
            LOGGER.error("Could not read block data from palette", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            ((Semaphore)lock).release();
        }
    }

    private char ordinal(BlockState ibd, PaperweightFaweAdapter adapter) {
        if (ibd == null) {
            return '\u0001';
        }
        return adapter.adaptToChar(ibd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LevelChunkSection[] getSections(boolean force) {
        LevelChunkSection[] tmp = this.sections;
        if (tmp == null || (force &= this.forceLoadSections)) {
            try {
                this.sectionLock.writeLock().lock();
                tmp = this.sections;
                if (tmp == null || force) {
                    LevelChunkSection[] chunkSections = this.getChunk().getSections();
                    tmp = new LevelChunkSection[chunkSections.length];
                    System.arraycopy(chunkSections, 0, tmp, 0, chunkSections.length);
                    this.sections = tmp;
                }
            }
            finally {
                this.sectionLock.writeLock().unlock();
            }
        }
        return tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LevelChunk getChunk() {
        LevelChunk levelChunk = this.levelChunk;
        if (levelChunk == null) {
            PaperweightGetBlocks paperweightGetBlocks = this;
            synchronized (paperweightGetBlocks) {
                levelChunk = this.levelChunk;
                if (levelChunk == null) {
                    try {
                        this.levelChunk = levelChunk = this.ensureLoaded((ServerLevel)this.serverLevel).get();
                    }
                    catch (InterruptedException | ExecutionException e) {
                        LOGGER.error("Could not get chunk at {},{}", (Object)this.chunkX, (Object)this.chunkZ, (Object)e);
                        throw new FaweException(TextComponent.of("Could not get chunk at " + this.chunkX + "," + this.chunkZ + ": " + e.getMessage()), FaweException.Type.OTHER, false);
                    }
                }
            }
        }
        return levelChunk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillLightNibble(char[][] light, LightLayer lightLayer, int minSectionPosition, int maxSectionPosition) {
        for (int Y = 0; Y <= maxSectionPosition - minSectionPosition; ++Y) {
            if (light[Y] == null) continue;
            SectionPos sectionPos = SectionPos.of((ChunkPos)this.levelChunk.getPos(), (int)(Y + minSectionPosition));
            DataLayer dataLayer = ((ServerLevel)this.serverLevel).getChunkSource().getLightEngine().getLayerListener(lightLayer).getDataLayerData(sectionPos);
            if (dataLayer == null) {
                byte[] LAYER_COUNT = new byte[2048];
                Arrays.fill(LAYER_COUNT, lightLayer == LightLayer.SKY ? (byte)15 : 0);
                dataLayer = new DataLayer(LAYER_COUNT);
                ((ServerLevel)this.serverLevel).getChunkSource().getLightEngine().queueSectionData(lightLayer, sectionPos, dataLayer);
            }
            DataLayer dataLayer2 = dataLayer;
            synchronized (dataLayer2) {
                for (int x = 0; x < 16; ++x) {
                    for (int y = 0; y < 16; ++y) {
                        for (int z = 0; z < 16; ++z) {
                            int i = y << 8 | z << 4 | x;
                            if (light[Y][i] >= '\u0010') continue;
                            dataLayer.set(x, y, z, (int)light[Y][i]);
                        }
                    }
                }
                continue;
            }
        }
    }

    private PalettedContainer<Holder<Biome>> setBiomesToPalettedContainer(BiomeType[][] biomes, int sectionIndex, PalettedContainerRO<Holder<Biome>> data) {
        BiomeType[] sectionBiomes;
        if (biomes == null || (sectionBiomes = biomes[sectionIndex]) == null) {
            return null;
        }
        PalettedContainer biomeData = data.recreate();
        int index = 0;
        for (int y = 0; y < 4; ++y) {
            for (int z = 0; z < 4; ++z) {
                int x = 0;
                while (x < 4) {
                    BiomeType biomeType = sectionBiomes[index];
                    if (biomeType == null) {
                        biomeData.set(x, y, z, (Object)((Holder)data.get(x, y, z)));
                    } else {
                        biomeData.set(x, y, z, (Object)((Holder)this.biomeHolderIdMap.byIdOrThrow(this.adapter.getInternalBiomeId(biomeType))));
                    }
                    ++x;
                    ++index;
                }
            }
        }
        return biomeData;
    }

    @Override
    public boolean hasSection(int layer) {
        return this.getSections(false)[layer -= this.getMinSectionPosition()] != null;
    }

    @Override
    public boolean hasNonEmptySection(int layer) {
        LevelChunkSection section = this.getSections(false)[layer -= this.getMinSectionPosition()];
        return section != null && !section.hasOnlyAir();
    }

    @Override
    public synchronized boolean trim(boolean aggressive) {
        this.skyLight = new DataLayer[this.getSectionCount()];
        this.blockLight = new DataLayer[this.getSectionCount()];
        if (aggressive) {
            this.sectionLock.writeLock().lock();
            this.sections = null;
            this.levelChunk = null;
            this.sectionLock.writeLock().unlock();
            return super.trim(true);
        }
        if (this.sections == null) {
            return true;
        }
        for (int i = this.getMinSectionPosition(); i <= this.getMaxSectionPosition(); ++i) {
            int layer = i - this.getMinSectionPosition();
            if (!this.hasSection(i) || this.blocks[layer] == null) continue;
            LevelChunkSection existing = this.getSections(true)[layer];
            try {
                PalettedContainer blocksExisting = existing.getStates();
                Object dataObject = PaperweightPlatformAdapter.fieldData.get(blocksExisting);
                Palette palette = (Palette)PaperweightPlatformAdapter.fieldPalette.get(dataObject);
                if (!(palette instanceof LinearPalette) && !(palette instanceof HashMapPalette)) {
                    super.trim(false, i);
                    continue;
                }
                int paletteSize = palette.getSize();
                if (paletteSize == 1) continue;
                super.trim(false, i);
                continue;
            }
            catch (IllegalAccessException ignored) {
                super.trim(false, i);
            }
        }
        return true;
    }
}

