/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit.adapter.ext.fawe.v1_21_R1;

import com.fastasyncworldedit.core.internal.exception.FaweException;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.bukkit.adapter.Refraction;
import com.sk89q.worldedit.bukkit.adapter.ext.fawe.v1_21_R1.PaperweightAdapter;
import com.sk89q.worldedit.bukkit.adapter.impl.fawe.v1_21_R1.PaperweightFaweAdapter;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.internal.util.LogManagerCompat;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import org.apache.logging.log4j.Logger;
import org.enginehub.linbus.tree.LinTag;
import org.jetbrains.annotations.Nullable;

public class PaperweightServerLevelDelegateProxy
implements InvocationHandler {
    private static final Logger LOGGER = LogManagerCompat.getLogger();
    private final Extent editSession;
    private final ServerLevel serverLevel;
    private final PaperweightFaweAdapter adapter = (PaperweightFaweAdapter)WorldEditPlugin.getInstance().getBukkitImplAdapter();
    private final boolean errorOnPassthrough;

    private PaperweightServerLevelDelegateProxy(EditSession editSession, ServerLevel serverLevel, PaperweightAdapter adapter) {
        this.editSession = editSession;
        this.serverLevel = serverLevel;
        this.errorOnPassthrough = false;
    }

    public static WorldGenLevel newInstance(EditSession editSession, ServerLevel serverLevel, PaperweightAdapter adapter) {
        return (WorldGenLevel)Proxy.newProxyInstance(serverLevel.getClass().getClassLoader(), serverLevel.getClass().getInterfaces(), (InvocationHandler)new PaperweightServerLevelDelegateProxy(editSession, serverLevel, adapter));
    }

    private PaperweightServerLevelDelegateProxy(Extent extent, ServerLevel serverLevel, boolean errorOnPassthrough) {
        this.editSession = extent;
        this.serverLevel = serverLevel;
        this.errorOnPassthrough = errorOnPassthrough;
    }

    public static WorldGenLevel newInstance(Extent extent, ServerLevel serverLevel, boolean errorOnPassthrough) {
        return (WorldGenLevel)Proxy.newProxyInstance(serverLevel.getClass().getClassLoader(), serverLevel.getClass().getInterfaces(), (InvocationHandler)new PaperweightServerLevelDelegateProxy(extent, serverLevel, errorOnPassthrough));
    }

    @Nullable
    private BlockEntity getBlockEntity(BlockPos blockPos) {
        BlockEntity tileEntity = this.serverLevel.getChunkAt(blockPos).getBlockEntity(blockPos);
        if (tileEntity == null) {
            return null;
        }
        tileEntity.loadWithComponents((CompoundTag)this.adapter.fromNativeLin((LinTag)this.editSession.getFullBlock(blockPos.getX(), blockPos.getY(), blockPos.getZ()).getNbtReference().getValue()), (HolderLookup.Provider)this.serverLevel.registryAccess());
        return tileEntity;
    }

    private BlockState getBlockState(BlockPos blockPos) {
        return this.adapter.adapt(this.editSession.getBlock(blockPos.getX(), blockPos.getY(), blockPos.getZ()));
    }

    private boolean setBlock(BlockPos blockPos, BlockState blockState) {
        try {
            return this.editSession.setBlock(blockPos.getX(), blockPos.getY(), blockPos.getZ(), this.adapter.adapt(blockState));
        }
        catch (MaxChangedBlocksException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean removeBlock(BlockPos blockPos, boolean bl) {
        try {
            return this.editSession.setBlock(blockPos.getX(), blockPos.getY(), blockPos.getZ(), BlockTypes.AIR.getDefaultState());
        }
        catch (MaxChangedBlocksException e) {
            throw new RuntimeException(e);
        }
    }

    private FluidState getFluidState(BlockPos pos) {
        return this.getBlockState(pos).getFluidState();
    }

    private boolean isWaterAt(BlockPos pos) {
        return this.getBlockState(pos).getFluidState().is(FluidTags.WATER);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        BlockPos blockPos;
        Object object;
        String methodName = method.getName();
        if (Refraction.pickName("getBlockState", "a_").equals(methodName) && args.length == 1 && (object = args[0]) instanceof BlockPos) {
            BlockPos blockPos2 = (BlockPos)object;
            return this.getBlockState(blockPos2);
        }
        if (Refraction.pickName("getBlockEntity", "c_").equals(methodName) && args.length == 1 && (object = args[0]) instanceof BlockPos) {
            BlockPos blockPos3 = (BlockPos)object;
            return this.getBlockEntity(blockPos3);
        }
        if ("a".equals(methodName) || "setBlock".equals(methodName) || "removeBlock".equals(methodName) || "destroyBlock".equals(methodName)) {
            Object object2;
            if (args.length >= 2 && (object2 = args[0]) instanceof BlockPos) {
                blockPos = (BlockPos)object2;
                object2 = args[1];
                if (object2 instanceof BlockState) {
                    BlockState blockState = (BlockState)object2;
                    return this.setBlock(blockPos, blockState);
                }
            }
            if (args.length >= 2 && (object2 = args[0]) instanceof BlockPos) {
                BlockPos blockPos4 = (BlockPos)object2;
                object2 = args[1];
                if (object2 instanceof Boolean) {
                    Boolean bl = (Boolean)object2;
                    return this.removeBlock(blockPos4, bl);
                }
            }
        }
        if (Refraction.pickName("getFluidState", "b_").equals(methodName) && args.length == 1 && (object = args[0]) instanceof BlockPos) {
            blockPos = (BlockPos)object;
            return this.getFluidState(blockPos);
        }
        if (Refraction.pickName("isWaterAt", "z").equals(methodName) && args.length == 1 && (object = args[0]) instanceof BlockPos) {
            blockPos = (BlockPos)object;
            return this.isWaterAt(blockPos);
        }
        if (Refraction.pickName("getEntities", "a_").equals(methodName) && args.length == 2 && args[0] instanceof Entity && args[1] instanceof AABB) {
            return new ArrayList();
        }
        if (Refraction.pickName("getRawBrightness", "b").equals(methodName)) {
            return method.invoke((Object)this.serverLevel, args);
        }
        if (Refraction.pickName("getMaxBuildHeight", "al").equals(methodName) && args.length == 0) {
            return method.invoke((Object)this.serverLevel, args);
        }
        if (Refraction.pickName("hasNeighborSignal", "C").equals(methodName) && args.length == 1 && args[0] instanceof BlockPos) {
            return method.invoke((Object)this.serverLevel, args);
        }
        if (Refraction.pickName("getSignal", "c").equals(methodName) && args.length == 2 && args[0] instanceof BlockPos && args[1] instanceof Direction) {
            return method.invoke((Object)this.serverLevel, args);
        }
        if (Refraction.pickName("getControlInputSignal", "a").equals(methodName) && args.length == 3 && args[0] instanceof BlockPos && args[1] instanceof Direction && args[2] instanceof Boolean) {
            return method.invoke((Object)this.serverLevel, args);
        }
        if (Refraction.pickName("getDirectSignal", "a").equals(methodName) && args.length == 2 && args[0] instanceof BlockPos && args[1] instanceof Direction) {
            return method.invoke((Object)this.serverLevel, args);
        }
        if (this.errorOnPassthrough) {
            LOGGER.error("Attempted passthough of method {}.\nMethod argument types: {}\nMethod argument values: {}\n", (Object)method.getName(), Arrays.stream(args).map(a -> a.getClass().getName()).toList(), Arrays.stream(args).map(Object::toString).toList());
            throw new FaweException("Method required passthrough.");
        }
        return method.invoke((Object)this.serverLevel, args);
    }
}

