/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.util;

import com.fastasyncworldedit.core.Fawe;
import com.fastasyncworldedit.core.configuration.Settings;
import com.fastasyncworldedit.core.queue.implementation.QueueHandler;
import com.fastasyncworldedit.core.util.task.RunnableVal;
import com.sk89q.worldedit.internal.util.LogManagerCompat;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.logging.log4j.Logger;

public abstract class TaskManager {
    private static final Logger LOGGER = LogManagerCompat.getLogger();
    @Deprecated(forRemoval=true, since="2.0.0")
    public static TaskManager IMP;
    static TaskManager INSTANCE;
    private final ForkJoinPool pool = new ForkJoinPool();

    protected TaskManager() {
        INSTANCE = this;
    }

    public static TaskManager taskManager() {
        if (INSTANCE == null) {
            INSTANCE = Fawe.platform().getTaskManager();
        }
        return INSTANCE;
    }

    public abstract int repeat(@Nonnull Runnable var1, int var2);

    public abstract int repeatAsync(@Nonnull Runnable var1, int var2);

    public abstract void async(@Nonnull Runnable var1);

    public abstract void task(@Nonnull Runnable var1);

    public ForkJoinPool getPublicForkJoinPool() {
        return this.pool;
    }

    @Deprecated(forRemoval=true, since="2.7.0")
    public void parallel(Collection<Runnable> runables) {
        for (Runnable run : runables) {
            this.pool.submit(run);
        }
        this.pool.awaitQuiescence(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    @Deprecated(forRemoval=true, since="2.7.0")
    public void parallel(Collection<Runnable> runnables, @Nullable Integer numThreads) {
        if (runnables == null) {
            return;
        }
        if (numThreads == null) {
            numThreads = Settings.settings().QUEUE.PARALLEL_THREADS;
        }
        if (numThreads <= 1) {
            for (Runnable run : runnables) {
                if (run == null) continue;
                run.run();
            }
            return;
        }
        int numRuns = runnables.size();
        int amountPerThread = 1 + numRuns / numThreads;
        Runnable[][] split = new Runnable[numThreads.intValue()][amountPerThread];
        Thread[] threads = new Thread[numThreads.intValue()];
        int i = 0;
        int j = 0;
        Thread[] threadArray = runnables.iterator();
        while (threadArray.hasNext()) {
            Runnable run;
            split[i][j] = run = threadArray.next();
            if (++i < numThreads) continue;
            i = 0;
            ++j;
        }
        for (i = 0; i < threads.length; ++i) {
            Runnable[] toRun = split[i];
            Thread thread = threads[i] = new Thread(() -> {
                for (Runnable run : toRun) {
                    if (run == null) continue;
                    run.run();
                }
            });
            thread.start();
        }
        for (Thread thread : threads) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void runUnsafe(Runnable run) {
        QueueHandler queue = Fawe.instance().getQueueHandler();
        queue.startUnsafe(Fawe.isMainThread());
        try {
            run.run();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        queue.endUnsafe(Fawe.isMainThread());
    }

    public void taskNow(@Nonnull Runnable runnable, boolean async) {
        if (async) {
            this.async(runnable);
        } else {
            runnable.run();
        }
    }

    public void taskNowMain(@Nonnull Runnable runnable) {
        if (Fawe.isMainThread()) {
            runnable.run();
        } else {
            this.task(runnable);
        }
    }

    public void taskNowAsync(@Nonnull Runnable runnable) {
        this.taskNow(runnable, Fawe.isMainThread());
    }

    public void taskSoonMain(@Nonnull Runnable runnable, boolean async) {
        if (async) {
            this.async(runnable);
        } else {
            this.task(runnable);
        }
    }

    public abstract void later(@Nonnull Runnable var1, int var2);

    public abstract void laterAsync(@Nonnull Runnable var1, int var2);

    public abstract void cancel(int var1);

    public <T> void objectTask(Collection<T> objects, final RunnableVal<T> task, final Runnable whenDone) {
        final Iterator<T> iterator = objects.iterator();
        this.task(new Runnable(){

            @Override
            public void run() {
                boolean hasNext;
                long start = System.currentTimeMillis();
                while ((hasNext = iterator.hasNext()) && System.currentTimeMillis() - start < 5L) {
                    task.value = iterator.next();
                    task.run();
                }
                if (!hasNext) {
                    TaskManager.this.later(whenDone, 1);
                } else {
                    TaskManager.this.later(this, 1);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated(forRemoval=true, since="2.7.0")
    public void wait(AtomicBoolean running, int timeout) {
        try {
            long start = System.currentTimeMillis();
            AtomicBoolean atomicBoolean = running;
            synchronized (atomicBoolean) {
                while (running.get()) {
                    running.wait(timeout);
                    if (!running.get() || System.currentTimeMillis() - start <= 60000L) continue;
                    new RuntimeException("FAWE is taking a long time to execute a task (might just be a symptom): ").printStackTrace();
                    LOGGER.info("For full debug information use: /fawe threads");
                }
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated(forRemoval=true, since="2.7.0")
    public void notify(AtomicBoolean running) {
        running.set(false);
        AtomicBoolean atomicBoolean = running;
        synchronized (atomicBoolean) {
            running.notifyAll();
        }
    }

    public void taskWhenFree(@Nonnull Runnable run) {
        if (Fawe.isMainThread()) {
            run.run();
        } else {
            Fawe.instance().getQueueHandler().sync(run);
        }
    }

    public <T> T syncWhenFree(@Nonnull RunnableVal<T> function) {
        if (Fawe.isMainThread()) {
            function.run();
            return function.value;
        }
        try {
            return Fawe.instance().getQueueHandler().sync(function).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T syncWhenFree(@Nonnull Supplier<T> supplier) {
        if (Fawe.isMainThread()) {
            return supplier.get();
        }
        try {
            return Fawe.instance().getQueueHandler().sync(supplier).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T sync(@Nonnull RunnableVal<T> function) {
        return this.sync((Supplier<T>)function);
    }

    public <T> T sync(Supplier<T> function) {
        if (Fawe.isMainThread()) {
            return function.get();
        }
        try {
            return Fawe.instance().getQueueHandler().sync(function).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

