/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.util;

import com.fastasyncworldedit.core.util.CachedTextureUtil;
import com.fastasyncworldedit.core.util.MathMan;
import com.fastasyncworldedit.core.util.TextureUtil;
import com.sk89q.worldedit.bukkit.fastutil.ints.Int2ObjectOpenHashMap;
import com.sk89q.worldedit.world.block.BlockType;
import java.io.FileNotFoundException;
import java.util.concurrent.ThreadLocalRandom;

public class RandomTextureUtil
extends CachedTextureUtil {
    private int index;
    private final int[] biomeMixBuffer = new int[3];
    private final Int2ObjectOpenHashMap<Integer> offsets = new Int2ObjectOpenHashMap();
    private final Int2ObjectOpenHashMap<int[]> biomeMixes = new Int2ObjectOpenHashMap();

    public RandomTextureUtil(TextureUtil parent) throws FileNotFoundException {
        super(parent);
    }

    private RandomTextureUtil(TextureUtil parent, Int2ObjectOpenHashMap<BlockType> colorBlockMap, Int2ObjectOpenHashMap<Integer> colorBiomeMap, Int2ObjectOpenHashMap<BlockType[]> colorLayerMap) throws FileNotFoundException {
        super(parent, colorBlockMap, colorBiomeMap, colorLayerMap);
    }

    @Override
    public TextureUtil fork() {
        try {
            return new RandomTextureUtil(this.parent, this.colorBlockMap, this.colorBiomeMap, this.colorLayerMap);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    protected int addRandomColor(int c1, int c2) {
        int red1 = c1 >> 16 & 0xFF;
        int green1 = c1 >> 8 & 0xFF;
        int blue1 = c1 >> 0 & 0xFF;
        byte red2 = (byte)(c2 >> 16);
        byte green2 = (byte)(c2 >> 8);
        byte blue2 = (byte)(c2 >> 0);
        int red = MathMan.clamp(red1 + this.random(red2), 0, 255);
        int green = MathMan.clamp(green1 + this.random(green2), 0, 255);
        int blue = MathMan.clamp(blue1 + this.random(blue2), 0, 255);
        return (red << 16) + (green << 8) + (blue << 0) + -16777216;
    }

    private int random(int i) {
        if (i < 0) {
            int i1 = -i;
            return -ThreadLocalRandom.current().nextInt(i1);
        }
        if (i == 0) {
            return 0;
        }
        return ThreadLocalRandom.current().nextInt(i);
    }

    @Override
    public boolean getIsBlockCloserThanBiome(char[] blockAndBiomeIdOutput, int color, int biomePriority) {
        BlockType block = this.getNearestBlock(color);
        int[] mix = this.biomeMixes.getOrDefault(color, (int[])null);
        if (mix == null) {
            int average = this.getBiomeMix(this.biomeMixBuffer, color);
            mix = new int[4];
            System.arraycopy(this.biomeMixBuffer, 0, mix, 0, 3);
            mix[3] = average;
            this.biomeMixes.put(color, mix);
        }
        if (++this.index > 2) {
            this.index = 0;
        }
        int biomeId = mix[this.index];
        int biomeAvColor = mix[3];
        int blockColor = this.getColor(block);
        blockAndBiomeIdOutput[0] = block.getDefaultState().getOrdinalChar();
        blockAndBiomeIdOutput[1] = (char)biomeId;
        return RandomTextureUtil.colorDistance(biomeAvColor, color) - (long)biomePriority > RandomTextureUtil.colorDistance(blockColor, color);
    }

    @Override
    public TextureUtil.BiomeColor getNearestBiome(int color) {
        int[] mix = this.biomeMixes.getOrDefault(color, (int[])null);
        if (mix == null) {
            int average = this.getBiomeMix(this.biomeMixBuffer, color);
            mix = new int[4];
            System.arraycopy(this.biomeMixBuffer, 0, mix, 0, 3);
            mix[3] = average;
            this.biomeMixes.put(color, mix);
        }
        if (++this.index > 2) {
            this.index = 0;
        }
        int biomeId = mix[this.index];
        return this.getBiome(biomeId);
    }

    @Override
    public BlockType getNearestBlock(int color) {
        int offsetColor = this.offsets.getOrDefault((Object)color, (Integer)0);
        offsetColor = offsetColor != 0 ? this.addRandomColor(color, offsetColor) : color;
        BlockType res = super.getNearestBlock(offsetColor);
        if (res == null) {
            return null;
        }
        int newColor = this.getColor(res);
        byte dr = (byte)((color >> 16 & 0xFF) - (newColor >> 16 & 0xFF));
        byte dg = (byte)((color >> 8 & 0xFF) - (newColor >> 8 & 0xFF));
        byte db = (byte)((color >> 0 & 0xFF) - (newColor >> 0 & 0xFF));
        this.offsets.put(color, (Integer)((dr << 16) + (dg << 8) + (db << 0)));
        return res;
    }
}

