/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.util;

import com.fastasyncworldedit.core.extent.processor.BatchProcessorHolder;
import com.fastasyncworldedit.core.extent.processor.MultiBatchProcessor;
import com.fastasyncworldedit.core.queue.IBatchProcessor;
import com.sk89q.worldedit.internal.util.LogManagerCompat;
import java.util.ArrayDeque;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.logging.log4j.Logger;

public class ProcessorTraverser<T extends IBatchProcessor> {
    private static final Logger LOGGER = LogManagerCompat.getLogger();
    private final T root;

    public ProcessorTraverser(@Nonnull T root) {
        this.root = root;
    }

    @Nullable
    public <U extends IBatchProcessor> U find(Class<U> clazz) {
        try {
            ArrayDeque<IBatchProcessor> processors = new ArrayDeque<IBatchProcessor>();
            Object processor = this.root;
            do {
                if (clazz.isAssignableFrom(processor.getClass())) {
                    return (U)((IBatchProcessor)clazz.cast(processor));
                }
                if (processor instanceof MultiBatchProcessor) {
                    MultiBatchProcessor multiProcessor = (MultiBatchProcessor)processor;
                    processors.addAll(multiProcessor.getBatchProcessors());
                    continue;
                }
                if (!(processor instanceof BatchProcessorHolder)) continue;
                BatchProcessorHolder holder = (BatchProcessorHolder)processor;
                processors.add(holder.getProcessor());
            } while ((processor = (IBatchProcessor)processors.poll()) != null);
            return null;
        }
        catch (Throwable e) {
            LOGGER.error("Error traversing processors", e);
            return null;
        }
    }
}

