/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.queue.implementation;

import com.fastasyncworldedit.core.Fawe;
import com.fastasyncworldedit.core.queue.IQueueChunk;
import com.fastasyncworldedit.core.queue.IQueueExtent;
import com.fastasyncworldedit.core.queue.implementation.QueueHandler;
import com.fastasyncworldedit.core.util.MathMan;
import com.sk89q.worldedit.bukkit.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import com.sk89q.worldedit.util.Direction;
import com.sk89q.worldedit.world.World;
import java.util.concurrent.ConcurrentLinkedQueue;

public class Flood {
    private final int maxBranch;
    private final int maxDepth;
    private final Direction[] directions;
    private final Long2ObjectLinkedOpenHashMap<long[][]> chunkVisits;
    private final Long2ObjectLinkedOpenHashMap<int[][]> chunkQueues;
    private int[] queue;
    private long[] visit;
    private final int[][] queues;
    private final long[][] visits;
    private int chunkX;
    private int chunkYLayer;
    private int chunkZ;
    private final ConcurrentLinkedQueue<int[]> queuePool = new ConcurrentLinkedQueue();
    private final int minSectionPosition;
    private final int maxSectionPosition;
    private final int sectionCount;

    public Flood(int maxBranch, int maxDepth, Direction[] directions, int minSectionPosition, int maxSectionPosition) {
        this.maxBranch = maxBranch;
        this.maxDepth = maxDepth;
        this.directions = directions;
        this.minSectionPosition = minSectionPosition;
        this.maxSectionPosition = maxSectionPosition;
        this.sectionCount = maxSectionPosition - minSectionPosition + 1;
        this.queues = new int[27][];
        this.visits = new long[27][];
        this.chunkVisits = new Long2ObjectLinkedOpenHashMap();
        this.chunkQueues = new Long2ObjectLinkedOpenHashMap();
    }

    public synchronized void run(World world) {
        QueueHandler queueHandler = Fawe.instance().getQueueHandler();
        IQueueExtent<IQueueChunk> fq = queueHandler.getQueue(world);
        while (!this.chunkQueues.isEmpty()) {
            long firstKey = this.chunkQueues.firstLongKey();
            int x = MathMan.unpairIntX(firstKey);
            int z = MathMan.unpairIntY(firstKey);
            int[][] nArray = this.chunkQueues.get(firstKey);
        }
    }

    private void init(int chunkX, int chunkYLayer, int chunkZ) {
        this.chunkX = chunkX;
        this.chunkYLayer = chunkYLayer;
        this.chunkZ = chunkZ;
    }

    public void start(int x, int y, int z) {
        this.push(x, y, z, 0);
    }

    private void push(int x, int y, int z, int depth) {
        int chunkX = x >> 4;
        int chunkZ = z >> 4;
        long pair = MathMan.pairInt(chunkX, chunkZ);
        int layer = (y >> 4) - this.minSectionPosition;
        int[] section = this.getOrCreateQueue(pair, layer);
        int val = (x & 0xF) + ((z & 0xF) << 4) + ((y & 0xF) << 8) + (depth << 12);
        this.push(section, val);
    }

    private int[] getOrCreateQueue(long pair, int layer) {
        int[] section;
        Object arrs = this.chunkQueues.get(pair);
        if (arrs == null) {
            int[][] nArrayArray = new int[this.sectionCount][];
            arrs = nArrayArray;
            this.chunkQueues.put(pair, (int[][])nArrayArray);
        }
        if ((section = arrs[layer]) == null) {
            section = this.newQueue();
            arrs[layer] = section;
        }
        return section;
    }

    private int[] newQueue() {
        int[] arr = this.queuePool.poll();
        if (arr != null) {
            arr[0] = 2;
            arr[1] = 2;
            return arr;
        }
        return new int[4096];
    }

    public int poll() {
        int index = this.queue[0];
        if (index == this.queue[1]) {
            return -1;
        }
        this.queue[0] = index + 1;
        return this.queue[index];
    }

    private void push(int[] queue, int val) {
        int indexStart = queue[0];
        int indexEnd = queue[1];
        this.push(indexStart, indexEnd, queue, val);
    }

    private void push(int indexStart, int indexEnd, int[] queue, int val) {
        if (indexStart > 2) {
            queue[0] = --indexStart;
            queue[indexStart] = val;
        } else {
            queue[indexEnd] = val;
            queue[0] = ++indexEnd;
        }
    }

    public Direction[] getDirections() {
        return this.directions;
    }

    public int getMaxBranch() {
        return this.maxBranch;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public void apply(int x, int y, int z, int depth) {
        int j = 0;
        for (int i = 0; i < this.directions.length && j < this.maxBranch; ++i) {
            int index;
            int[] queue;
            long[] visit;
            int tz;
            Direction dir = this.directions[i];
            int ty = y + dir.getBlockY();
            int tx = x + dir.getBlockX();
            int or = tx | ty | (tz = z + dir.getBlockZ());
            if (or > 15 || or < 0) {
                visit = this.visit;
                queue = this.queue;
                index = tx + (tz << 4) + (ty << 8);
            } else {
                int nextX = tx >> 4;
                int nextY = ty >> 4;
                int nextZ = tz >> 4;
                int sectionIndex = nextX + nextZ * 3 + nextZ * 9 + 13;
                visit = this.visits[sectionIndex];
                queue = this.queues[sectionIndex];
                if (visit == null || queue == null) {
                    long pair = MathMan.pairInt(this.chunkX + nextX, this.chunkZ + nextZ);
                    int layer = this.chunkYLayer + nextY;
                    if (layer < this.minSectionPosition || layer > this.maxSectionPosition) continue;
                    queue = this.getOrCreateQueue(pair, layer);
                    this.queues[sectionIndex] = queue;
                }
                index = (tx & 0xF) + ((tz & 0xF) << 4) + ((ty & 0xF) << 8);
            }
            if (this.getAndSet(visit, index)) continue;
            ++j;
            this.push(queue, index + (depth << 12));
        }
    }

    public void set(long[] bits, int i) {
        int n = i >> 6;
        bits[n] = bits[n] | 1L << (i & 0x3F);
    }

    public final boolean getAndSet(long[] bits, int i) {
        int index = i >> 6;
        long val = bits[index];
        long offset = 1L << (i & 0x3F);
        if ((val & offset) != 0L) {
            return true;
        }
        int n = index;
        bits[n] = bits[n] | offset;
        return false;
    }

    public boolean get(long[] bits, int i) {
        return (bits[i >> 6] & 1L << (i & 0x3F)) != 0L;
    }
}

