/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.queue;

import com.fastasyncworldedit.core.nbt.FaweCompoundTag;
import com.fastasyncworldedit.core.queue.IChunk;
import com.fastasyncworldedit.core.util.NbtUtils;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.enginehub.linbus.tree.LinCompoundTag;
import org.enginehub.linbus.tree.LinDoubleTag;
import org.enginehub.linbus.tree.LinListTag;
import org.enginehub.linbus.tree.LinStringTag;
import org.enginehub.linbus.tree.LinTag;
import org.enginehub.linbus.tree.LinTagType;

public interface IChunkExtent<T extends IChunk>
extends Extent {
    public T getOrCreateChunk(int var1, int var2);

    @Override
    default public <B extends BlockStateHolder<B>> boolean setBlock(int x, int y, int z, B state) {
        B chunk = this.getOrCreateChunk(x >> 4, z >> 4);
        return chunk.setBlock(x & 0xF, y, z & 0xF, state);
    }

    @Override
    default public boolean tile(int x, int y, int z, FaweCompoundTag tile) throws WorldEditException {
        T chunk = this.getOrCreateChunk(x >> 4, z >> 4);
        return chunk.tile(x & 0xF, y, z & 0xF, tile);
    }

    @Override
    default public boolean setBiome(int x, int y, int z, BiomeType biome) {
        T chunk = this.getOrCreateChunk(x >> 4, z >> 4);
        return chunk.setBiome(x & 0xF, y, z & 0xF, biome);
    }

    @Override
    default public boolean setBiome(BlockVector3 position, BiomeType biome) {
        T chunk = this.getOrCreateChunk(position.x() >> 4, position.z() >> 4);
        return chunk.setBiome(position.x() & 0xF, position.y(), position.z() & 0xF, biome);
    }

    @Override
    default public BlockState getBlock(int x, int y, int z) {
        T chunk = this.getOrCreateChunk(x >> 4, z >> 4);
        return chunk.getBlock(x & 0xF, y, z & 0xF);
    }

    @Override
    default public BaseBlock getFullBlock(int x, int y, int z) {
        T chunk = this.getOrCreateChunk(x >> 4, z >> 4);
        return chunk.getFullBlock(x & 0xF, y, z & 0xF);
    }

    @Override
    default public BiomeType getBiomeType(int x, int y, int z) {
        T chunk = this.getOrCreateChunk(x >> 4, z >> 4);
        return chunk.getBiomeType(x & 0xF, y, z & 0xF);
    }

    @Override
    default public BiomeType getBiome(BlockVector3 position) {
        T chunk = this.getOrCreateChunk(position.x() >> 4, position.z() >> 4);
        return chunk.getBiomeType(position.x() & 0xF, position.y(), position.z() & 0xF);
    }

    @Override
    default public void setSkyLight(int x, int y, int z, int value) {
        T chunk = this.getOrCreateChunk(x >> 4, z >> 4);
        chunk.setSkyLight(x & 0xF, y, z & 0xF, value);
    }

    @Override
    default public void setBlockLight(int x, int y, int z, int value) {
        T chunk = this.getOrCreateChunk(x >> 4, z >> 4);
        chunk.setSkyLight(x & 0xF, y, z & 0xF, value);
    }

    @Override
    default public int getSkyLight(int x, int y, int z) {
        T chunk = this.getOrCreateChunk(x >> 4, z >> 4);
        return chunk.getSkyLight(x & 0xF, y, z & 0xF);
    }

    @Override
    default public int getEmittedLight(int x, int y, int z) {
        T chunk = this.getOrCreateChunk(x >> 4, z >> 4);
        return chunk.getEmittedLight(x & 0xF, y, z & 0xF);
    }

    @Override
    default public int getBrightness(int x, int y, int z) {
        T chunk = this.getOrCreateChunk(x >> 4, z >> 4);
        return chunk.getBrightness(x & 0xF, y, z & 0xF);
    }

    @Override
    default public int getOpacity(int x, int y, int z) {
        T chunk = this.getOrCreateChunk(x >> 4, z >> 4);
        return chunk.getOpacity(x & 0xF, y, z & 0xF);
    }

    @Override
    default public Entity createEntity(Location location, BaseEntity entity) {
        return this.createEntity(location, entity, UUID.randomUUID());
    }

    @Override
    default public Entity createEntity(Location location, BaseEntity entity, UUID uuid) {
        T chunk = this.getOrCreateChunk(location.getBlockX() >> 4, location.getBlockZ() >> 4);
        HashMap map = new HashMap((Map<String, LinTag<?>>)entity.getNbt().value());
        map.put("Id", LinStringTag.of(entity.getType().getName()));
        ArrayList<LinDoubleTag> posList = new ArrayList<LinDoubleTag>();
        posList.add(LinDoubleTag.of(location.x()));
        posList.add(LinDoubleTag.of(location.y()));
        posList.add(LinDoubleTag.of(location.z()));
        map.put("Pos", LinListTag.of(LinTagType.doubleTag(), posList));
        NbtUtils.addUUIDToMap(map, uuid);
        chunk.entity(FaweCompoundTag.of(LinCompoundTag.of(map)));
        return new IChunkEntity(this, location, uuid, entity);
    }

    @Override
    default public void removeEntity(int x, int y, int z, UUID uuid) {
        T chunk = this.getOrCreateChunk(x >> 4, z >> 4);
        chunk.removeEntity(uuid);
    }

    public record IChunkEntity(Extent extent, Location location, UUID uuid, BaseEntity base) implements Entity
    {
        @Override
        public BaseEntity getState() {
            return this.base;
        }

        @Override
        public boolean remove() {
            this.extent.removeEntity(this.location.getBlockX(), this.location.getBlockY(), this.location.getBlockZ(), this.uuid);
            return true;
        }

        @Override
        public <T> T getFacet(Class<? extends T> cls) {
            return null;
        }

        @Override
        public Location getLocation() {
            return this.location;
        }

        @Override
        public boolean setLocation(Location location) {
            return false;
        }

        @Override
        public Extent getExtent() {
            return this.extent;
        }
    }
}

