/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.extent.processor.lighting;

import com.fastasyncworldedit.core.Fawe;
import com.fastasyncworldedit.core.configuration.Settings;
import com.fastasyncworldedit.core.extent.processor.lighting.RelightMode;
import com.fastasyncworldedit.core.extent.processor.lighting.Relighter;
import com.fastasyncworldedit.core.math.BlockVectorSet;
import com.fastasyncworldedit.core.queue.IQueueExtent;
import com.fastasyncworldedit.core.queue.implementation.chunk.ChunkHolder;
import com.fastasyncworldedit.core.util.MathMan;
import com.fastasyncworldedit.core.util.TaskManager;
import com.fastasyncworldedit.core.util.task.RunnableVal;
import com.sk89q.worldedit.bukkit.fastutil.longs.Long2ObjectOpenHashMap;
import com.sk89q.worldedit.internal.util.LogManagerCompat;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.registry.state.DirectionalProperty;
import com.sk89q.worldedit.registry.state.EnumProperty;
import com.sk89q.worldedit.util.Direction;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockTypes;
import com.sk89q.worldedit.world.registry.BlockMaterial;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;
import org.apache.logging.log4j.Logger;

public class NMSRelighter
implements Relighter {
    private static final Logger LOGGER = LogManagerCompat.getLogger();
    private static final int DISPATCH_SIZE = 64;
    private static final DirectionalProperty stairDirection = (DirectionalProperty)BlockTypes.SANDSTONE_STAIRS.getProperty("facing");
    private static final EnumProperty stairHalf = (EnumProperty)BlockTypes.SANDSTONE_STAIRS.getProperty("half");
    private static final EnumProperty stairShape = (EnumProperty)BlockTypes.SANDSTONE_STAIRS.getProperty("shape");
    private static final EnumProperty slabHalf = (EnumProperty)BlockTypes.SANDSTONE_SLAB.getProperty("type");
    private final IQueueExtent<?> queue;
    private final Map<Long, RelightSkyEntry> skyToRelight;
    private final Object present = new Object();
    private final Map<Long, Integer> chunksToSend;
    private final ConcurrentLinkedQueue<RelightSkyEntry> extendSkyToRelight = new ConcurrentLinkedQueue();
    private final Map<Long, long[][][]> lightQueue;
    private final AtomicBoolean lightLock = new AtomicBoolean(false);
    private final ConcurrentHashMap<Long, long[][][]> concurrentLightQueue;
    private final RelightMode relightMode;
    private final int maxY;
    private final int minY;
    private final int yLongPerCol;
    private final ReentrantLock lightingLock;
    private final AtomicBoolean finished = new AtomicBoolean(false);
    private boolean removeFirst;

    public NMSRelighter(IQueueExtent<?> queue) {
        this(queue, null);
    }

    public NMSRelighter(IQueueExtent<?> queue, RelightMode relightMode) {
        this.queue = queue;
        this.skyToRelight = new Long2ObjectOpenHashMap<RelightSkyEntry>(12);
        this.lightQueue = new Long2ObjectOpenHashMap<long[][][]>(12);
        this.chunksToSend = new Long2ObjectOpenHashMap<Integer>(12);
        this.concurrentLightQueue = new ConcurrentHashMap(12);
        this.maxY = queue.getMaxY();
        this.minY = queue.getMinY();
        this.yLongPerCol = this.maxY - this.minY + 1 >> 6;
        this.relightMode = relightMode != null ? relightMode : RelightMode.valueOf(Settings.settings().LIGHTING.MODE);
        this.lightingLock = new ReentrantLock();
    }

    @Override
    public boolean isEmpty() {
        return this.skyToRelight.isEmpty() && this.lightQueue.isEmpty() && this.extendSkyToRelight.isEmpty() && this.concurrentLightQueue.isEmpty();
    }

    @Override
    public ReentrantLock getLock() {
        return this.lightingLock;
    }

    @Override
    public boolean isFinished() {
        return this.finished.get();
    }

    @Override
    public synchronized void removeAndRelight(boolean sky) {
        this.removeFirst = true;
        this.fixLightingSafe(sky);
        this.removeFirst = false;
    }

    private void set(int x, int y, int z, long[][][] map) {
        long[] m2;
        Object m1 = map[z];
        if (m1 == null) {
            long[][] lArrayArray = new long[16][];
            map[z] = lArrayArray;
            m1 = lArrayArray;
        }
        if ((m2 = m1[x]) == null) {
            m1[x] = new long[this.yLongPerCol];
            m2 = m1[x];
        }
        int n = (y -= this.minY) >> 6;
        m2[n] = m2[n] | 1L << (y & 0x3F);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLightUpdate(int x, int y, int z) {
        long index = MathMan.pairInt(x >> 4, z >> 4);
        if (this.lightLock.compareAndSet(false, true)) {
            Map<Long, long[][][]> map = this.lightQueue;
            synchronized (map) {
                try {
                    Object currentMap = this.lightQueue.get(index);
                    if (currentMap == null) {
                        currentMap = new long[16][][];
                        this.lightQueue.put(index, (long[][][])currentMap);
                    }
                    this.set(x & 0xF, y, z & 0xF, (long[][][])currentMap);
                    this.lightQueue.putAll(this.concurrentLightQueue);
                    this.concurrentLightQueue.clear();
                }
                finally {
                    this.lightLock.set(false);
                }
            }
        }
        Object currentMap = this.concurrentLightQueue.get(index);
        if (currentMap == null) {
            currentMap = new long[16][][];
            this.concurrentLightQueue.put(index, (long[][][])currentMap);
        }
        this.set(x & 0xF, y, z & 0xF, (long[][][])currentMap);
    }

    @Override
    public synchronized void clear() {
        this.extendSkyToRelight.clear();
        this.skyToRelight.clear();
        this.chunksToSend.clear();
        this.lightQueue.clear();
    }

    @Override
    public boolean addChunk(int cx, int cz, byte[] fix, int bitmask) {
        RelightSkyEntry toPut = new RelightSkyEntry(cx, cz, fix, bitmask, this.minY, this.maxY);
        this.extendSkyToRelight.add(toPut);
        return true;
    }

    private synchronized Map<Long, RelightSkyEntry> getSkyMap() {
        RelightSkyEntry entry;
        while ((entry = this.extendSkyToRelight.poll()) != null) {
            long pair = MathMan.pairInt(entry.x, entry.z);
            RelightSkyEntry existing = this.skyToRelight.put(pair, entry);
            if (existing == null) continue;
            entry.bitmask |= existing.bitmask;
            if (entry.fix == null) continue;
            for (int i = 0; i < entry.fix.length; ++i) {
                int n = i;
                entry.fix[n] = (byte)(entry.fix[n] & existing.fix[i]);
            }
        }
        return this.skyToRelight;
    }

    @Override
    public synchronized void removeLighting() {
        Iterator<Map.Entry<Long, RelightSkyEntry>> iter = this.getSkyMap().entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Long, RelightSkyEntry> entry = iter.next();
            RelightSkyEntry chunk = entry.getValue();
            long pair = entry.getKey();
            this.chunksToSend.compute(pair, (k, existing) -> chunk.bitmask | (existing != null ? existing : 0));
            ChunkHolder iChunk = (ChunkHolder)this.queue.getOrCreateChunk(chunk.x, chunk.z);
            if (!iChunk.isInit()) {
                iChunk.init(this.queue, chunk.x, chunk.z);
            }
            for (int i = this.minY >> 4; i <= this.maxY >> 4; ++i) {
                iChunk.removeSectionLighting(i, true);
            }
            iter.remove();
        }
    }

    public void updateBlockLight(Map<Long, long[][][]> map) {
        int lightLevel;
        int size = map.size();
        if (size == 0) {
            return;
        }
        LinkedList<BlockVector3> lightPropagationQueue = new LinkedList<BlockVector3>();
        LinkedList<LightRemovalNode> lightRemovalQueue = new LinkedList<LightRemovalNode>();
        HashMap<BlockVector3, Object> visited = new HashMap<BlockVector3, Object>(32);
        HashMap<BlockVector3, Object> removalVisited = new HashMap<BlockVector3, Object>(32);
        BlockTypes.STONE.getMaterial();
        Iterator<Map.Entry<Long, long[][][]>> iter = map.entrySet().iterator();
        while (iter.hasNext() && size-- > 0) {
            Map.Entry<Long, long[][][]> entry = iter.next();
            long index = entry.getKey();
            long[][][] blocks = entry.getValue();
            int chunkX = MathMan.unpairIntX(index);
            int chunkZ = MathMan.unpairIntY(index);
            int bx = chunkX << 4;
            int bz = chunkZ << 4;
            ChunkHolder iChunk = (ChunkHolder)this.queue.getOrCreateChunk(chunkX, chunkZ);
            if (!iChunk.isInit()) {
                iChunk.init(this.queue, chunkX, chunkZ);
            }
            for (int lz = 0; lz < blocks.length; ++lz) {
                long[][] m1 = blocks[lz];
                if (m1 == null) continue;
                for (int lx = 0; lx < m1.length; ++lx) {
                    long[] m2 = m1[lx];
                    if (m2 == null) continue;
                    for (int i = 0; i < m2.length; ++i) {
                        int yStart = (i << 6) + this.minY;
                        long value = m2[i];
                        if (value == 0L) continue;
                        for (int j = 0; j < 64; ++j) {
                            int newLevel;
                            if ((value >> j & 1L) != 1L) continue;
                            int x = lx + bx;
                            int y = yStart + j;
                            int z = lz + bz;
                            int oldLevel = iChunk.getEmittedLight(lx, y, lz);
                            if (oldLevel == (newLevel = iChunk.getBrightness(lx, y, lz))) continue;
                            iChunk.setBlockLight(lx, y, lz, newLevel);
                            BlockVector3 node = BlockVector3.at(x, y, z);
                            if (newLevel < oldLevel) {
                                removalVisited.put(node, this.present);
                                lightRemovalQueue.add(new LightRemovalNode(node, oldLevel));
                                continue;
                            }
                            visited.put(node, this.present);
                            lightPropagationQueue.add(node);
                        }
                    }
                }
            }
            iter.remove();
        }
        while (!lightRemovalQueue.isEmpty()) {
            LightRemovalNode val = (LightRemovalNode)lightRemovalQueue.poll();
            BlockVector3 node = val.pos();
            lightLevel = val.previous();
            this.computeRemoveBlockLight(node.x() - 1, node.y(), node.z(), lightLevel, lightRemovalQueue, lightPropagationQueue, removalVisited, visited);
            this.computeRemoveBlockLight(node.x() + 1, node.y(), node.z(), lightLevel, lightRemovalQueue, lightPropagationQueue, removalVisited, visited);
            if (node.y() > this.minY) {
                this.computeRemoveBlockLight(node.x(), node.y() - 1, node.z(), lightLevel, lightRemovalQueue, lightPropagationQueue, removalVisited, visited);
            }
            if (node.y() < this.maxY) {
                this.computeRemoveBlockLight(node.x(), node.y() + 1, node.z(), lightLevel, lightRemovalQueue, lightPropagationQueue, removalVisited, visited);
            }
            this.computeRemoveBlockLight(node.x(), node.y(), node.z() - 1, lightLevel, lightRemovalQueue, lightPropagationQueue, removalVisited, visited);
            this.computeRemoveBlockLight(node.x(), node.y(), node.z() + 1, lightLevel, lightRemovalQueue, lightPropagationQueue, removalVisited, visited);
        }
        while (!lightPropagationQueue.isEmpty()) {
            boolean top;
            BlockVector3 node = (BlockVector3)lightPropagationQueue.poll();
            ChunkHolder iChunk = (ChunkHolder)this.queue.getOrCreateChunk(node.x() >> 4, node.z() >> 4);
            if (!iChunk.isInit()) {
                iChunk.init(this.queue, node.x() >> 4, node.z() >> 4);
            }
            lightLevel = iChunk.getEmittedLight(node.x() & 0xF, node.y(), node.z() & 0xF);
            BlockState state = this.queue.getBlock(node.x(), node.y(), node.z());
            String id = state.getBlockType().id().toLowerCase(Locale.ROOT);
            if (lightLevel <= 1) continue;
            if (id.contains("slab")) {
                top = state.getState(slabHalf).equalsIgnoreCase("top");
                this.computeSlab(node.x(), node.y(), node.z(), lightLevel, lightPropagationQueue, visited, top);
                continue;
            }
            if (id.contains("stair")) {
                top = state.getState(stairHalf).equalsIgnoreCase("top");
                Direction direction = this.getStairDir(state);
                String shape = this.getStairShape(state);
                this.computeStair(node.x(), node.y(), node.z(), lightLevel, lightPropagationQueue, visited, top, direction, shape);
                continue;
            }
            this.computeNormal(node.x(), node.y(), node.z(), lightLevel, lightPropagationQueue, visited);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void computeStair(int x, int y, int z, int currentLight, Queue<BlockVector3> queue, Map<BlockVector3, Object> visited, boolean top, Direction direction, String shape) {
        block30: {
            boolean b2;
            boolean b1;
            String otherShape;
            Direction otherDir;
            BlockState state;
            block31: {
                block28: {
                    block29: {
                        block26: {
                            block27: {
                                block24: {
                                    block25: {
                                        if (direction != Direction.WEST && (direction == Direction.NORTH && shape.equals("inner_right") || direction == Direction.SOUTH && shape.equals("inner_left") || direction == Direction.EAST && !shape.startsWith("outer")) || !this.checkStairEast(state = this.queue.getBlock(x + 1, y, z)) || !this.isStairOrTrueTop(state, top) || !this.isSlabOrTrueValue(state, top ? "top" : "bottom")) break block24;
                                        if (state.getBlockType().id().toLowerCase(Locale.ROOT).contains("stair")) break block25;
                                        this.computeSpreadBlockLight(x + 1, y, z, currentLight, queue, visited);
                                        break block24;
                                    }
                                    otherDir = this.getStairDir(state);
                                    otherShape = this.getStairShape(state);
                                    b1 = otherDir == Direction.NORTH && !otherShape.equals("outer_right") || otherDir == Direction.EAST && otherShape.equals("inner_left");
                                    b2 = otherDir == Direction.SOUTH && !otherShape.equals("outer_left") || otherDir == Direction.EAST && otherShape.equals("inner_right");
                                    switch (direction) {
                                        case EAST: {
                                            if ((!shape.equals("outer_right") || !b1) && (!shape.equals("outer_left") || !b2)) break;
                                            break block24;
                                        }
                                        case WEST: {
                                            if (shape.equals("straight") || shape.startsWith("outer") || (!shape.equals("inner_left") || !b1) && (!shape.equals("inner_right") || !b2)) break;
                                            break block24;
                                        }
                                        case SOUTH: {
                                            if (!b1 && (otherDir != Direction.SOUTH || !otherShape.equals("inner_right"))) break;
                                            break block24;
                                        }
                                        case NORTH: {
                                            if (b2 || otherDir == Direction.NORTH && otherShape.equals("inner_left")) break block24;
                                        }
                                    }
                                    this.computeSpreadBlockLight(x + 1, y, z, currentLight, queue, visited);
                                }
                                if (direction != Direction.EAST && (direction == Direction.SOUTH && shape.equals("inner_right") || direction == Direction.NORTH && shape.equals("inner_left") || direction == Direction.WEST && !shape.startsWith("outer")) || !this.checkStairWest(state = this.queue.getBlock(x - 1, y, z)) || !this.isStairOrTrueTop(state, top) || !this.isSlabOrTrueValue(state, top ? "top" : "bottom")) break block26;
                                if (state.getBlockType().id().toLowerCase(Locale.ROOT).contains("stair")) break block27;
                                this.computeSpreadBlockLight(x - 1, y, z, currentLight, queue, visited);
                                break block26;
                            }
                            otherDir = this.getStairDir(state);
                            otherShape = this.getStairShape(state);
                            b1 = otherDir == Direction.SOUTH && !otherShape.equals("outer_right") || otherDir == Direction.WEST && otherShape.equals("inner_left");
                            b2 = otherDir == Direction.NORTH && !otherShape.equals("outer_left") || otherDir == Direction.WEST && otherShape.equals("inner_right");
                            switch (direction) {
                                case WEST: {
                                    if ((!shape.equals("outer_right") || !b1) && (!shape.equals("outer_left") || !b2)) break;
                                    break block26;
                                }
                                case EAST: {
                                    if (shape.equals("straight") || shape.startsWith("outer") || (!shape.equals("inner_left") || !b1) && (!shape.equals("inner_right") || !b2)) break;
                                    break block26;
                                }
                                case NORTH: {
                                    if (!b1 && (otherDir != Direction.NORTH || !otherShape.equals("inner_right"))) break;
                                    break block26;
                                }
                                case SOUTH: {
                                    if (b2 || otherDir == Direction.SOUTH && otherShape.equals("inner_left")) break block26;
                                }
                            }
                            this.computeSpreadBlockLight(x - 1, y, z, currentLight, queue, visited);
                        }
                        if (direction != Direction.NORTH && (direction == Direction.WEST && shape.equals("inner_right") || direction == Direction.EAST && shape.equals("inner_left") || direction == Direction.SOUTH && !shape.startsWith("outer")) || !this.checkStairSouth(state = this.queue.getBlock(x, y, z + 1)) || !this.isStairOrTrueTop(state, top) || !this.isSlabOrTrueValue(state, top ? "top" : "bottom")) break block28;
                        if (state.getBlockType().id().toLowerCase(Locale.ROOT).contains("stair")) break block29;
                        this.computeSpreadBlockLight(x, y, z + 1, currentLight, queue, visited);
                        break block28;
                    }
                    otherDir = this.getStairDir(state);
                    otherShape = this.getStairShape(state);
                    b1 = otherDir == Direction.EAST && !otherShape.equals("outer_right") || otherDir == Direction.SOUTH && otherShape.equals("inner_left");
                    b2 = otherDir == Direction.WEST && !otherShape.equals("outer_left") || otherDir == Direction.SOUTH && otherShape.equals("inner_right");
                    switch (direction) {
                        case SOUTH: {
                            if ((!shape.equals("outer_right") || !b1) && (!shape.equals("outer_left") || !b2)) break;
                            break block28;
                        }
                        case NORTH: {
                            if (shape.equals("straight") || shape.startsWith("outer") || (!shape.equals("inner_left") || !b1) && (!shape.equals("inner_right") || !b2)) break;
                            break block28;
                        }
                        case WEST: {
                            if (!b1 && (otherDir != Direction.WEST || !otherShape.equals("inner_right"))) break;
                            break block28;
                        }
                        case EAST: {
                            if (b2 || otherDir == Direction.EAST && otherShape.equals("inner_left")) break block28;
                        }
                    }
                    this.computeSpreadBlockLight(x, y, z + 1, currentLight, queue, visited);
                }
                if (direction != Direction.SOUTH && (direction == Direction.EAST && shape.equals("inner_right") || direction == Direction.WEST && shape.equals("inner_left") || direction == Direction.NORTH && !shape.startsWith("outer")) || !this.checkStairNorth(state = this.queue.getBlock(x, y, z - 1)) || !this.isStairOrTrueTop(state, top) || !this.isSlabOrTrueValue(state, top ? "top" : "bottom")) break block30;
                if (state.getBlockType().id().toLowerCase(Locale.ROOT).contains("stair")) break block31;
                this.computeSpreadBlockLight(x, y, z - 1, currentLight, queue, visited);
                break block30;
            }
            otherDir = this.getStairDir(state);
            otherShape = this.getStairShape(state);
            b1 = otherDir == Direction.WEST && !otherShape.equals("outer_right") || otherDir == Direction.NORTH && otherShape.equals("inner_left");
            b2 = otherDir == Direction.EAST && !otherShape.equals("outer_left") || otherDir == Direction.NORTH && otherShape.equals("inner_right");
            switch (direction) {
                case NORTH: {
                    if ((!shape.equals("outer_right") || !b1) && (!shape.equals("outer_left") || !b2)) break;
                    break block30;
                }
                case SOUTH: {
                    if (shape.equals("straight") || shape.startsWith("outer") || (!shape.equals("inner_left") || !b1) && (!shape.equals("inner_right") || !b2)) break;
                    break block30;
                }
                case EAST: {
                    if (!b1 && (otherDir != Direction.EAST || !otherShape.equals("inner_right"))) break;
                    break block30;
                }
                case WEST: {
                    if (b2 || otherDir == Direction.WEST && otherShape.equals("inner_left")) break block30;
                }
            }
            this.computeSpreadBlockLight(x, y, z - 1, currentLight, queue, visited);
        }
        this.computeUpDown(x, y, z, currentLight, queue, visited, top);
    }

    private void computeSlab(int x, int y, int z, int currentLight, Queue<BlockVector3> queue, Map<BlockVector3, Object> visited, boolean top) {
        BlockState state = this.queue.getBlock(x + 1, y, z);
        if (this.checkStairEast(state) && this.isStairOrTrueTop(state, top) && this.isSlabOrTrueValue(state, top ? "top" : "bottom")) {
            this.computeSpreadBlockLight(x + 1, y, z, currentLight, queue, visited);
        }
        if (this.checkStairWest(state = this.queue.getBlock(x - 1, y, z)) && this.isStairOrTrueTop(state, top) && this.isSlabOrTrueValue(state, top ? "top" : "bottom")) {
            this.computeSpreadBlockLight(x - 1, y, z, currentLight, queue, visited);
        }
        if (this.checkStairSouth(state = this.queue.getBlock(x, y, z + 1)) && this.isStairOrTrueTop(state, top) && this.isSlabOrTrueValue(state, top ? "top" : "bottom")) {
            this.computeSpreadBlockLight(x, y, z + 1, currentLight, queue, visited);
        }
        if (this.checkStairNorth(state = this.queue.getBlock(x, y, z - 1)) && this.isStairOrTrueTop(state, top) && this.isSlabOrTrueValue(state, top ? "top" : "bottom")) {
            this.computeSpreadBlockLight(x, y, z - 1, currentLight, queue, visited);
        }
        this.computeUpDown(x, y, z, currentLight, queue, visited, top);
    }

    private void computeUpDown(int x, int y, int z, int currentLight, Queue<BlockVector3> queue, Map<BlockVector3, Object> visited, boolean top) {
        BlockState state = this.queue.getBlock(x, y - 1, z);
        if (y > 0 && top && this.isSlabOrTrueValue(state, "bottom") && this.isStairOrTrueTop(state, false)) {
            this.computeSpreadBlockLight(x, y - 1, z, currentLight, queue, visited);
        }
        state = this.queue.getBlock(x, y + 1, z);
        if (y < this.maxY && !top && this.isSlabOrTrueValue(state, "top") && this.isStairOrTrueTop(state, true)) {
            this.computeSpreadBlockLight(x, y + 1, z, currentLight, queue, visited);
        }
    }

    private void computeNormal(int x, int y, int z, int currentLight, Queue<BlockVector3> queue, Map<BlockVector3, Object> visited) {
        BlockState state = this.queue.getBlock(x + 1, y, z);
        if (this.checkStairEast(state) && (this.isSlabOrTrueValue(state, "top") || this.isSlabOrTrueValue(state, "bottom"))) {
            this.computeSpreadBlockLight(x + 1, y, z, currentLight, queue, visited);
        }
        if (this.checkStairWest(state = this.queue.getBlock(x - 1, y, z)) && (this.isSlabOrTrueValue(state, "top") || this.isSlabOrTrueValue(state, "bottom"))) {
            this.computeSpreadBlockLight(x - 1, y, z, currentLight, queue, visited);
        }
        if (this.checkStairSouth(state = this.queue.getBlock(x, y, z + 1)) && (this.isSlabOrTrueValue(state, "top") || this.isSlabOrTrueValue(state, "bottom"))) {
            this.computeSpreadBlockLight(x, y, z + 1, currentLight, queue, visited);
        }
        if (this.checkStairNorth(state = this.queue.getBlock(x, y, z - 1)) && (this.isSlabOrTrueValue(state, "top") || this.isSlabOrTrueValue(state, "bottom"))) {
            this.computeSpreadBlockLight(x, y, z - 1, currentLight, queue, visited);
        }
        state = this.queue.getBlock(x, y - 1, z);
        if (y > 0 && this.isSlabOrTrueValue(state, "bottom") && this.isStairOrTrueTop(state, false)) {
            this.computeSpreadBlockLight(x, y - 1, z, currentLight, queue, visited);
        }
        state = this.queue.getBlock(x, y + 1, z);
        if (y < this.maxY && this.isSlabOrTrueValue(state, "top") && this.isStairOrTrueTop(state, false)) {
            this.computeSpreadBlockLight(x, y + 1, z, currentLight, queue, visited);
        }
    }

    private boolean checkStairNorth(BlockState state) {
        if (!state.getBlockType().id().toLowerCase(Locale.ROOT).contains("stair")) {
            return true;
        }
        Direction direction = this.getStairDir(state);
        String shape = this.getStairShape(state);
        if (shape.startsWith("outer") || direction == Direction.NORTH) {
            return true;
        }
        if (direction == Direction.SOUTH) {
            return false;
        }
        if (direction == Direction.WEST) {
            return !shape.equals("inner_left");
        }
        return direction != Direction.EAST || !shape.equals("inner_right");
    }

    private boolean checkStairSouth(BlockState state) {
        if (!state.getBlockType().id().toLowerCase(Locale.ROOT).contains("stair")) {
            return true;
        }
        Direction direction = this.getStairDir(state);
        String shape = this.getStairShape(state);
        if (shape.startsWith("outer") || direction == Direction.SOUTH) {
            return true;
        }
        if (direction == Direction.NORTH) {
            return false;
        }
        if (direction == Direction.EAST) {
            return !shape.equals("inner_left");
        }
        return direction != Direction.WEST || !shape.equals("inner_right");
    }

    private boolean checkStairEast(BlockState state) {
        if (!state.getBlockType().id().toLowerCase(Locale.ROOT).contains("stair")) {
            return true;
        }
        Direction direction = this.getStairDir(state);
        String shape = this.getStairShape(state);
        if (shape.startsWith("outer") || direction == Direction.EAST) {
            return true;
        }
        if (direction == Direction.WEST) {
            return false;
        }
        if (direction == Direction.NORTH) {
            return !shape.equals("inner_left");
        }
        return direction != Direction.SOUTH || !shape.equals("inner_right");
    }

    private boolean checkStairWest(BlockState state) {
        if (!state.getBlockType().id().toLowerCase(Locale.ROOT).contains("stair")) {
            return true;
        }
        Direction direction = this.getStairDir(state);
        String shape = this.getStairShape(state);
        if (shape.startsWith("outer") || direction == Direction.WEST) {
            return true;
        }
        if (direction == Direction.EAST) {
            return false;
        }
        if (direction == Direction.SOUTH) {
            return !shape.equals("inner_left");
        }
        return direction != Direction.NORTH || !shape.equals("inner_right");
    }

    private Direction getStairDir(BlockState state) {
        return state.getState(stairDirection);
    }

    private String getStairShape(BlockState state) {
        return state.getState(stairShape).toLowerCase(Locale.ROOT);
    }

    private boolean isStairOrTrueTop(BlockState state, boolean top) {
        return !state.getBlockType().id().contains("stair") || state.getState(stairHalf).equals("top") == top;
    }

    private boolean isSlabOrTrueValue(BlockState state, String value) {
        return !state.getBlockType().id().contains("slab") || state.getState(slabHalf).equals(value);
    }

    private void computeRemoveBlockLight(int x, int y, int z, int currentLight, Queue<LightRemovalNode> queue, Queue<BlockVector3> spreadQueue, Map<BlockVector3, Object> visited, Map<BlockVector3, Object> spreadVisited) {
        int current;
        ChunkHolder iChunk = (ChunkHolder)this.queue.getOrCreateChunk(x >> 4, z >> 4);
        if (!iChunk.isInit()) {
            iChunk.init(this.queue, x >> 4, z >> 4);
        }
        if ((current = iChunk.getEmittedLight(x & 0xF, y, z & 0xF)) != 0 && current < currentLight) {
            iChunk.setBlockLight(x, y, z, 0);
            if (current > 1) {
                visited.computeIfAbsent(BlockVector3.at(x, y, z), k -> {
                    queue.add(new LightRemovalNode((BlockVector3)k, current));
                    return this.present;
                });
            }
        } else if (current >= currentLight) {
            spreadVisited.computeIfAbsent(BlockVector3.at(x, y, z), k -> {
                spreadQueue.add((BlockVector3)k);
                return this.present;
            });
        }
    }

    private void computeSpreadBlockLight(int x, int y, int z, int currentLight, Queue<BlockVector3> queue, Map<BlockVector3, Object> visited) {
        int correctedLight;
        BlockMaterial material = this.queue.getBlock(x, y, z).getMaterial();
        boolean solidNeedsLight = (!material.isSolid() || !material.isFullCube()) && material.getLightOpacity() > 0 && material.getLightValue() == 0;
        int n = correctedLight = !solidNeedsLight ? currentLight - Math.max(1, material.getLightOpacity()) : currentLight - 1;
        if (currentLight > 0) {
            int current;
            ChunkHolder iChunk = (ChunkHolder)this.queue.getOrCreateChunk(x >> 4, z >> 4);
            if (!iChunk.isInit()) {
                iChunk.init(this.queue, x >> 4, z >> 4);
            }
            if (currentLight > (current = iChunk.getEmittedLight(x & 0xF, y, z & 0xF))) {
                iChunk.setBlockLight(x & 0xF, y, z & 0xF, currentLight);
                visited.computeIfAbsent(BlockVector3.at(x, y, z), k -> {
                    if (correctedLight > 1) {
                        queue.add((BlockVector3)k);
                    }
                    return this.present;
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fixLightingSafe(boolean sky) {
        if (this.isEmpty()) {
            return;
        }
        if (sky) {
            this.fixSkyLighting();
        } else {
            NMSRelighter nMSRelighter = this;
            synchronized (nMSRelighter) {
                Map<Long, RelightSkyEntry> map = this.getSkyMap();
                Iterator<Map.Entry<Long, RelightSkyEntry>> iter = map.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry<Long, RelightSkyEntry> entry = iter.next();
                    this.chunksToSend.put(entry.getKey(), entry.getValue().bitmask);
                    iter.remove();
                }
            }
        }
        this.fixBlockLighting();
        this.sendChunks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fixBlockLighting() {
        Map<Long, long[][][]> map = this.lightQueue;
        synchronized (map) {
            while (!this.lightLock.compareAndSet(false, true)) {
                try {
                    this.lightLock.wait(50L);
                }
                catch (InterruptedException e) {
                    LOGGER.error((Object)e);
                }
            }
            try {
                this.updateBlockLight(this.lightQueue);
            }
            finally {
                this.lightLock.set(false);
            }
        }
    }

    @Override
    public synchronized void close() {
        Iterator<Map.Entry<Long, Integer>> iter = this.chunksToSend.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Long, Integer> entry = iter.next();
            long pair = entry.getKey();
            int bitMask = entry.getValue();
            int x = MathMan.unpairIntX(pair);
            int z = MathMan.unpairIntY(pair);
            ChunkHolder chunk = (ChunkHolder)this.queue.getOrCreateChunk(x, z);
            chunk.setBitMask(bitMask);
            iter.remove();
        }
        if (Settings.settings().LIGHTING.ASYNC) {
            this.queue.flush();
            this.finished.set(true);
        } else {
            TaskManager.taskManager().sync(new RunnableVal<Object>(){

                @Override
                public void run(Object value) {
                    NMSRelighter.this.queue.flush();
                    NMSRelighter.this.finished.set(true);
                }
            });
        }
    }

    public void flush() {
        this.close();
    }

    public synchronized void sendChunks() {
        RunnableVal<Object> runnable = new RunnableVal<Object>(){

            @Override
            public void run(Object value) {
                Iterator<Map.Entry<Long, Integer>> iter = NMSRelighter.this.chunksToSend.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry<Long, Integer> entry = iter.next();
                    long pair = entry.getKey();
                    int bitMask = entry.getValue();
                    int x = MathMan.unpairIntX(pair);
                    int z = MathMan.unpairIntY(pair);
                    ChunkHolder chunk = (ChunkHolder)NMSRelighter.this.queue.getOrCreateChunk(x, z);
                    chunk.setBitMask(bitMask);
                    chunk.flushLightToGet();
                    Fawe.platform().getPlatformAdapter().sendChunk(chunk.getOrCreateGet(), bitMask, true);
                    iter.remove();
                }
                NMSRelighter.this.finished.set(true);
            }
        };
        if (Settings.settings().LIGHTING.ASYNC) {
            runnable.run();
        } else {
            TaskManager.taskManager().sync(runnable);
        }
    }

    @Override
    public synchronized void fixSkyLighting() {
        Map<Long, RelightSkyEntry> map = this.getSkyMap();
        ArrayList<RelightSkyEntry> chunksList = new ArrayList<RelightSkyEntry>(map.size());
        Iterator<Map.Entry<Long, RelightSkyEntry>> iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Long, RelightSkyEntry> entry = iter.next();
            this.chunksToSend.put(entry.getKey(), entry.getValue().bitmask);
            chunksList.add(entry.getValue());
            iter.remove();
        }
        Collections.sort(chunksList);
        int size = chunksList.size();
        if (size > 64) {
            int amount = (size + 64 - 1) / 64;
            for (int i = 0; i < amount; ++i) {
                int start = i * 64;
                int end = Math.min(size, start + 64);
                List<RelightSkyEntry> sub = chunksList.subList(start, end);
                this.fixSkyLighting(sub);
            }
        } else {
            this.fixSkyLighting(chunksList);
        }
    }

    public void fill(byte[] mask, ChunkHolder<?> iChunk, int y, byte reason) {
        if (y >= 16) {
            Arrays.fill(mask, (byte)15);
            return;
        }
        switch (reason) {
            case 2: {
                Arrays.fill(mask, (byte)0);
                break;
            }
            case 1: {
                int index = 0;
                for (int z = 0; z < 16; ++z) {
                    for (int x = 0; x < 16; ++x) {
                        mask[index++] = (byte)iChunk.getSkyLight(x, y, z);
                    }
                }
                break;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void fixSkyLighting(List<RelightSkyEntry> sorted) {
        RelightSkyEntry[] chunks = sorted.toArray(new RelightSkyEntry[0]);
        boolean remove = this.removeFirst;
        BlockVectorSet chunkSet = null;
        if (remove) {
            BlockVectorSet tmpSet = new BlockVectorSet();
            chunkSet = new BlockVectorSet();
            for (RelightSkyEntry chunk : chunks) {
                tmpSet.add(chunk.x, 0, chunk.z);
            }
            for (RelightSkyEntry chunk : chunks) {
                int x = chunk.x;
                int z = chunk.z;
                if (!tmpSet.contains(x + 1, 0, z) || !tmpSet.contains(x - 1, 0, z) || !tmpSet.contains(x, 0, z + 1) || !tmpSet.contains(x, 0, z - 1)) continue;
                chunkSet.add(x, 0, z);
            }
        }
        int y = this.maxY;
        block7: while (y > this.minY) {
            RelightSkyEntry[] relightSkyEntryArray = chunks;
            int n = relightSkyEntryArray.length;
            int n2 = 0;
            while (true) {
                block24: {
                    ChunkHolder iChunk;
                    int bz;
                    int bx;
                    byte[] mask;
                    block25: {
                        block22: {
                            RelightSkyEntry chunk;
                            block23: {
                                if (n2 >= n) break block22;
                                chunk = relightSkyEntryArray[n2];
                                int layer = y - this.minY >> 4;
                                mask = chunk.mask;
                                bx = chunk.x << 4;
                                bz = chunk.z << 4;
                                iChunk = (ChunkHolder)this.queue.getOrCreateChunk(chunk.x, chunk.z);
                                if (chunk.fix[layer] == 0) break block23;
                                if ((y & 0xF) == 0 && layer != 0 && chunk.fix[layer - 1] == 0) {
                                    this.fill(mask, iChunk, y, chunk.fix[layer]);
                                }
                                break block24;
                            }
                            if (!iChunk.isInit()) {
                                iChunk.init(this.queue, chunk.x, chunk.z);
                            }
                            chunk.smooth = false;
                            if (!remove || (y & 0xF) != 15 || !chunkSet.contains(chunk.x, 0, chunk.z)) break block25;
                            iChunk.removeSectionLighting(y >> 4, true);
                            break block25;
                        }
                        for (RelightSkyEntry chunk : chunks) {
                            if (!chunk.smooth) continue;
                            this.smoothSkyLight(chunk, y, true);
                        }
                        for (int i = chunks.length - 1; i >= 0; --i) {
                            RelightSkyEntry chunk = chunks[i];
                            if (!chunk.smooth) continue;
                            this.smoothSkyLight(chunk, y, false);
                        }
                        --y;
                        continue block7;
                    }
                    block11: for (int j = 0; j < 256; ++j) {
                        int x = j & 0xF;
                        int z = j >> 4;
                        byte value = mask[j];
                        BlockState state = iChunk.getBlock(x, y, z);
                        BlockMaterial material = state.getMaterial();
                        int opacity = material.getLightOpacity();
                        int brightness = material.getLightValue();
                        if (brightness > 0 && brightness != iChunk.getEmittedLight(x, y, z)) {
                            this.addLightUpdate(bx + x, y, bz + z);
                        }
                        switch (value) {
                            case 0: {
                                if (opacity <= 1) break;
                                iChunk.setSkyLight(x, y, z, 0);
                                continue block11;
                            }
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: 
                            case 7: 
                            case 8: 
                            case 9: 
                            case 10: 
                            case 11: 
                            case 12: 
                            case 13: 
                            case 14: {
                                if (opacity >= value) {
                                    mask[j] = 0;
                                    if (!this.isStairOrTrueTop(state, true) || !this.isSlabOrTrueValue(state, "top") && !this.isSlabOrTrueValue(state, "double")) {
                                        iChunk.setSkyLight(x, y, z, value);
                                        continue block11;
                                    }
                                    iChunk.setSkyLight(x, y, z, 0);
                                    continue block11;
                                }
                                if (opacity <= 1) {
                                    mask[j] = value = (byte)(value - 1);
                                    break;
                                }
                                mask[j] = value = (byte)Math.max(0, value - opacity);
                                break;
                            }
                            case 15: {
                                if (opacity > 0) {
                                    mask[j] = value = (byte)(value - (byte)opacity);
                                }
                                if (!this.isStairOrTrueTop(state, true) || !this.isSlabOrTrueValue(state, "top") && !this.isSlabOrTrueValue(state, "double")) {
                                    iChunk.setSkyLight(x, y, z, value + opacity);
                                    continue block11;
                                }
                                iChunk.setSkyLight(x, y, z, value);
                                continue block11;
                            }
                        }
                        chunk.smooth = true;
                        iChunk.setSkyLight(x, y, z, value);
                    }
                }
                ++n2;
            }
            break;
        }
        return;
    }

    private void smoothSkyLight(RelightSkyEntry chunk, int y, boolean direction) {
        byte[] mask = chunk.mask;
        ChunkHolder iChunk = (ChunkHolder)this.queue.getOrCreateChunk(chunk.x, chunk.z);
        if (!iChunk.isInit()) {
            iChunk.init(this.queue, chunk.x, chunk.z);
        }
        if (direction) {
            ChunkHolder iChunkx = (ChunkHolder)this.queue.getOrCreateChunk(chunk.x - 1, chunk.z);
            ChunkHolder iChunkz = (ChunkHolder)this.queue.getOrCreateChunk(chunk.x, chunk.z - 1);
            if (!iChunkx.isInit()) {
                iChunkx.init(this.queue, chunk.x - 1, chunk.z);
            }
            if (!iChunkz.isInit()) {
                iChunkz.init(this.queue, chunk.x, chunk.z - 1);
            }
            for (int j = 0; j < 256; ++j) {
                int x = j & 0xF;
                int z = j >> 4;
                if (mask[j] >= 14 || mask[j] == 0 && iChunk.getOpacity(x, y, z) > 1) continue;
                byte value = mask[j];
                if (x != 0 && z != 0) {
                    value = (byte)Math.max(iChunk.getSkyLight(x - 1, y, z) - 1, value);
                    if (value < 14) {
                        value = (byte)Math.max(iChunk.getSkyLight(x, y, z - 1) - 1, value);
                    }
                    if (value <= mask[j]) continue;
                    mask[j] = value;
                    iChunk.setSkyLight(x, y, z, mask[j]);
                    continue;
                }
                if (x == 0 && z == 0) {
                    value = (byte)Math.max(iChunkx.getSkyLight(15, y, z) - 1, value);
                    if (value < 14) {
                        value = (byte)Math.max(iChunkz.getSkyLight(x, y, 15) - 1, value);
                    }
                    if (value <= mask[j]) continue;
                    mask[j] = value;
                    iChunk.setSkyLight(x, y, z, mask[j]);
                    continue;
                }
                if (x == 0) {
                    value = (byte)Math.max(iChunkx.getSkyLight(15, y, z) - 1, value);
                    if (value < 14) {
                        value = (byte)Math.max(iChunk.getSkyLight(x, y, z - 1) - 1, value);
                    }
                    if (value <= mask[j]) continue;
                    mask[j] = value;
                    iChunk.setSkyLight(x, y, z, mask[j]);
                    continue;
                }
                value = (byte)Math.max(iChunk.getSkyLight(x - 1, y, z) - 1, value);
                if (value < 14) {
                    value = (byte)Math.max(iChunkz.getSkyLight(x, y, 15) - 1, value);
                }
                if (value <= mask[j]) continue;
                mask[j] = value;
                iChunk.setSkyLight(x, y, z, mask[j]);
            }
        } else {
            ChunkHolder iChunkx = (ChunkHolder)this.queue.getOrCreateChunk(chunk.x + 1, chunk.z);
            ChunkHolder iChunkz = (ChunkHolder)this.queue.getOrCreateChunk(chunk.x, chunk.z + 1);
            if (!iChunkx.isInit()) {
                iChunkx.init(this.queue, chunk.x - 1, chunk.z);
            }
            if (!iChunkz.isInit()) {
                iChunkz.init(this.queue, chunk.x, chunk.z - 1);
            }
            for (int j = 255; j >= 0; --j) {
                int x = j & 0xF;
                int z = j >> 4;
                if (mask[j] >= 14 || mask[j] == 0 && iChunk.getOpacity(x, y, z) > 1) continue;
                byte value = mask[j];
                if (x != 15 && z != 15) {
                    value = (byte)Math.max(iChunk.getSkyLight(x + 1, y, z) - 1, value);
                    if (value < 14) {
                        value = (byte)Math.max(iChunk.getSkyLight(x, y, z + 1) - 1, value);
                    }
                    if (value <= mask[j]) continue;
                    mask[j] = value;
                    iChunk.setSkyLight(x, y, z, mask[j]);
                    continue;
                }
                if (x == 15 && z == 15) {
                    value = (byte)Math.max(iChunkx.getSkyLight(0, y, z) - 1, value);
                    if (value < 14) {
                        value = (byte)Math.max(iChunkz.getSkyLight(x, y, 0) - 1, value);
                    }
                    if (value <= mask[j]) continue;
                    mask[j] = value;
                    iChunk.setSkyLight(x, y, z, mask[j]);
                    continue;
                }
                if (x == 15) {
                    value = (byte)Math.max(iChunkx.getSkyLight(0, y, z) - 1, value);
                    if (value < 14) {
                        value = (byte)Math.max(iChunk.getSkyLight(x, y, z + 1) - 1, value);
                    }
                    if (value <= mask[j]) continue;
                    mask[j] = value;
                    iChunk.setSkyLight(x, y, z, mask[j]);
                    continue;
                }
                value = (byte)Math.max(iChunk.getSkyLight(x + 1, y, z) - 1, value);
                if (value < 14) {
                    value = (byte)Math.max(iChunkz.getSkyLight(x, y, 0) - 1, value);
                }
                if (value <= mask[j]) continue;
                mask[j] = value;
                iChunk.setSkyLight(x, y, z, mask[j]);
            }
        }
    }

    private static class RelightSkyEntry
    implements Comparable<RelightSkyEntry> {
        private static final Comparator<RelightSkyEntry> COMPARATOR = Comparator.comparingInt(RelightSkyEntry::x).thenComparingInt(RelightSkyEntry::z);
        public final int x;
        public final int z;
        public final byte[] mask;
        public final byte[] fix;
        public int bitmask;
        public boolean smooth;

        private RelightSkyEntry(int x, int z, byte[] fix, int bitmask, int minY, int maxY) {
            this.x = x;
            this.z = z;
            byte[] array = new byte[256];
            Arrays.fill(array, (byte)15);
            this.mask = array;
            this.bitmask = bitmask;
            if (fix == null) {
                this.fix = new byte[maxY - minY + 1 >> 4];
                Arrays.fill(this.fix, (byte)0);
            } else {
                this.fix = fix;
            }
        }

        private int x() {
            return this.x;
        }

        private int z() {
            return this.z;
        }

        public String toString() {
            return this.x + "," + this.z;
        }

        @Override
        public int compareTo(@Nonnull RelightSkyEntry o) {
            return COMPARATOR.compare(this, o);
        }
    }

    private record LightRemovalNode(BlockVector3 pos, int previous) {
    }
}

