/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.extent;

import com.fastasyncworldedit.core.FaweCache;
import com.fastasyncworldedit.core.limit.FaweLimit;
import com.fastasyncworldedit.core.util.WEManager;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.extent.AbstractDelegateExtent;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.UUID;

public class ProcessedWEExtent
extends AbstractDelegateExtent {
    private final FaweLimit limit;
    private final Extent extent;

    public ProcessedWEExtent(Extent parent, FaweLimit limit) {
        super(parent);
        this.limit = limit;
        this.extent = parent;
    }

    public void setLimit(FaweLimit other) {
        this.limit.set(other);
    }

    @Override
    public Entity createEntity(Location location, BaseEntity entity) {
        if (entity == null) {
            return null;
        }
        if (!this.limit.MAX_ENTITIES()) {
            WEManager.weManager().cancelEditSafe(this, FaweCache.MAX_ENTITIES);
            return null;
        }
        return super.createEntity(location, entity);
    }

    @Override
    public Entity createEntity(Location location, BaseEntity entity, UUID uuid) {
        if (entity == null) {
            return null;
        }
        if (!this.limit.MAX_ENTITIES()) {
            WEManager.weManager().cancelEditSafe(this, FaweCache.MAX_ENTITIES);
            return null;
        }
        return super.createEntity(location, entity, uuid);
    }

    @Override
    public BlockState getBlock(int x, int y, int z) {
        if (!this.limit.MAX_CHECKS()) {
            WEManager.weManager().cancelEditSafe(this, FaweCache.MAX_CHECKS);
            return BlockTypes.AIR.getDefaultState();
        }
        return this.extent.getBlock(x, y, z);
    }

    @Override
    public BaseBlock getFullBlock(BlockVector3 pos) {
        if (!this.limit.MAX_CHECKS()) {
            WEManager.weManager().cancelEditSafe(this, FaweCache.MAX_CHECKS);
            return BlockTypes.AIR.getDefaultState().toBaseBlock();
        }
        return this.extent.getFullBlock(pos);
    }

    public <B extends BlockStateHolder<B>> boolean setBlock(BlockVector3 location, B block) throws WorldEditException {
        return this.setBlock(location.x(), location.y(), location.z(), block);
    }

    @Override
    public BlockState getBlock(BlockVector3 location) {
        return this.getBlock(location.x(), location.y(), location.z());
    }

    @Override
    public <B extends BlockStateHolder<B>> boolean setBlock(int x, int y, int z, B block) throws WorldEditException {
        boolean hasNbt;
        boolean bl = hasNbt = block instanceof BaseBlock && block.hasNbtData();
        if (hasNbt) {
            if (!this.limit.MAX_BLOCKSTATES()) {
                WEManager.weManager().cancelEdit(this, FaweCache.MAX_TILES);
                return false;
            }
            if (!this.limit.MAX_CHANGES()) {
                WEManager.weManager().cancelEdit(this, FaweCache.MAX_CHANGES);
                return false;
            }
            return this.extent.setBlock(x, y, z, block);
        }
        if (!this.limit.MAX_CHANGES()) {
            WEManager.weManager().cancelEdit(this, FaweCache.MAX_CHANGES);
            return false;
        }
        return this.extent.setBlock(x, y, z, block);
    }

    @Override
    public boolean setBiome(BlockVector3 position, BiomeType biome) {
        if (!this.limit.MAX_CHANGES()) {
            WEManager.weManager().cancelEditSafe(this, FaweCache.MAX_CHANGES);
            return false;
        }
        return super.setBiome(position, biome);
    }
}

